/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.index.application;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.index.application.IndexJob;
import com.pandora.index.application.PingJob;
import com.pandora.index.service.ILinkedBlockingQueueService;
import com.pandora.index.service.IndexRequest;
import com.pandora.index.service.IndexServicePlugin;
import com.pandora.index.service.impl.IndexService;
import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;

public class IndexApplication
implements IApplication {
    public static boolean running = true;

    public Object start(IApplicationContext context) throws Exception {
        System.out.println("!SESSION " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()));
        try {
            final Display dis = new Display();
            Thread.currentThread().setContextClassLoader(IndexApplication.class.getClassLoader());
            LinkedBlockingDeque<IndexRequest> requestQueue = this.loadQueue();
            LocateRegistry.createRegistry(45678);
            IndexService indexService = new IndexService(dis, requestQueue);
            IndexServicePlugin.getDefault().setLinkedBlockingQueueService((ILinkedBlockingQueueService)indexService);
            Naming.rebind("rmi://127.0.0.1:45678/index", indexService);
            PingJob ping = new PingJob(dis);
            ping.schedule();
            IndexJob indexJob = new IndexJob(requestQueue);
            indexJob.schedule();
            indexJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    running = false;
                    dis.wake();
                }
            });
            HBLog.logError((Plugin)Activator.getDefault(), (String)"Indexer process rmi server started on port 45678");
            while (running) {
                if (dis.readAndDispatch()) continue;
                dis.sleep();
            }
        }
        catch (Throwable e) {
            System.out.println("INDEXER_SERVER_STARTED_FAILED");
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
        return IApplication.EXIT_OK;
    }

    private LinkedBlockingDeque<IndexRequest> loadQueue() {
        return new LinkedBlockingDeque<IndexRequest>();
    }

    public void stop() {
    }
}

