/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.dynamicpage.php;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.pandora.editor.dynamicpage.php.IPHPTokenScanner;
import java.io.StringReader;
import java_cup.runtime.Symbol;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.ast.scanner.AstLexer;
import org2.eclipse.php.internal.core.ast.scanner.php54.PhpAstLexer;

public class PHPTokenScanner
implements IPHPTokenScanner {
    protected static final String PHP_PREFIX = "<?php\n";
    private int fTokenLength;
    private int fOffset;
    private int origOffset;
    private String fContents;
    private AstLexer lexer;
    private PHPVersion phpVersion;
    private Symbol nextNextSymbol;

    public PHPTokenScanner(PHPVersion phpVersion) {
        if (phpVersion == null) {
            throw new IllegalArgumentException("A null PHP Version passed to the PHPTokenScanner");
        }
        this.phpVersion = phpVersion;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fOffset;
    }

    public IToken nextToken() {
        Symbol nextSymbol = this.nextNextSymbol;
        try {
            this.nextNextSymbol = this.lexer.next_token();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (String)"PHP token-scanner - Error getting the next token", (Throwable)e);
            this.nextNextSymbol = null;
        }
        IToken token = this.createToken(nextSymbol);
        this.fTokenLength = 0;
        if (token != Token.EOF) {
            int whiteSpacesGap = 0;
            if (this.nextNextSymbol != null && this.nextNextSymbol.sym != 0) {
                whiteSpacesGap = this.nextNextSymbol.left - nextSymbol.right;
            }
            this.fTokenLength = nextSymbol.right - nextSymbol.left + whiteSpacesGap;
            this.fOffset = this.origOffset + nextSymbol.left - PHP_PREFIX.length();
        }
        return token;
    }

    private static PhpAstLexer createEmptyLexer_54() {
        return new PhpAstLexer(new StringReader(""));
    }

    public void setRange(IDocument document, int offset, int length) {
        try {
            this.fContents = document.get(offset, length);
            this.fContents = PHP_PREFIX + this.fContents;
            this.phpVersion = PHPVersion.PHP5_4;
            this.lexer = new PhpAstLexer(new StringReader(this.fContents));
            this.lexer.resetCommentList();
            this.lexer.setUseAspTagsAsPhp(true);
            this.lexer.setUseShortTags(true);
            try {
                this.nextNextSymbol = this.lexer.next_token();
            }
            catch (Exception exception) {
                this.nextNextSymbol = null;
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (String)"PHP code-scanner - Error setting the range", (Throwable)e);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (String)"PHP code-scanner - I/O error", (Throwable)e);
        }
        this.origOffset = offset;
    }

    @Override
    public String getContents() {
        return this.fContents;
    }

    private IToken createToken(Symbol symbol) {
        if (symbol == null || symbol.sym == 0) {
            return Token.EOF;
        }
        return new Token((Object)symbol);
    }

    @Override
    public PHPVersion getPHPVersion() {
        return this.phpVersion;
    }
}

