/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.views.action;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.contentassist.Helper;
import com.pandora.core.appstream.IValue;
import com.pandora.core.stats.Stats;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;

public class SearchIdleFileReferenceJob
extends Job {
    private ProgressBar fProgressBar = null;
    private Label fMonitorLabel = null;
    private IFile fFile = null;
    private Map<IFile, List<IValue>> fProjectValues = null;
    private TreeViewer fTreeViewer = null;

    public SearchIdleFileReferenceJob(String name, IFile file, Map<IFile, List<IValue>> values, ProgressBar bar, Label monitorLabel, TreeViewer treeViewer) {
        super(name);
        this.fProjectValues = values;
        this.fFile = file;
        this.fProgressBar = bar;
        this.fMonitorLabel = monitorLabel;
        this.fTreeViewer = treeViewer;
        this.initJob();
    }

    protected void initJob() {
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.fProjectValues == null) {
            return Status.OK_STATUS;
        }
        monitor.beginTask("search...", this.fProjectValues.size());
        String fileName = this.fFile.getName();
        String[] matchs = new String[3];
        Pattern pattern = Pattern.compile("([^0-9]+)[0-9]+$");
        matchs[0] = fileName.substring(0, fileName.lastIndexOf(this.fFile.getFileExtension()) - 1);
        matchs[1] = fileName;
        matchs[2] = this.fFile.getProjectRelativePath().toString();
        Matcher matcher = pattern.matcher(matchs[0]);
        if (matcher.find()) {
            matchs[0] = matcher.group(1);
        }
        final LinkedHashMap refs = new LinkedHashMap();
        final int[] donework = new int[]{0};
        for (Map.Entry<IFile, List<IValue>> entry : this.fProjectValues.entrySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            donework[0] = donework[0] + 1;
            List<IValue> values = entry.getValue();
            if (CollectionsUtil.isNotEmpty(values)) {
                block1: for (IValue value : values) {
                    if (value.getRange() == null) continue;
                    String valString = value.getValue();
                    int i = matchs.length - 1;
                    while (i >= 0) {
                        String match = matchs[i];
                        if (!StringUtil.isEmpty((String)match) && match.length() != 1) {
                            ArrayList<IValue> refValues;
                            int c;
                            int groupCount;
                            Matcher mm;
                            if (i == 0) {
                                Pattern idlePattern = Pattern.compile("[/\\}]+(" + match + ")[\\.]{1}$|^(" + match + ")$|[/\\}]+(" + match + ")$|[/\\}]+(" + match + ")[\\{]+|^(" + match + ")[\\.]{1}$");
                                mm = idlePattern.matcher(valString);
                                if (mm.find()) {
                                    groupCount = mm.groupCount();
                                    c = 1;
                                    while (c <= groupCount) {
                                        if (mm.group(c) != null) {
                                            value.setFile(entry.getKey());
                                            value.setInnerRange(new Point(mm.start(c), mm.end(c)));
                                            if (refs.containsKey(entry.getKey())) {
                                                ((List)refs.get(entry.getKey())).add(value);
                                            } else {
                                                refValues = new ArrayList<IValue>();
                                                refValues.add(value);
                                                refs.put(entry.getKey(), refValues);
                                            }
                                        }
                                        ++c;
                                    }
                                }
                            } else if (i == 1) {
                                Pattern idlePattern = Pattern.compile("[/\\}]+(" + (match = match.replace(".", "\\.")) + ")[^\\w]|[/\\}]+(" + match + ")$|^(" + match + ")$");
                                mm = idlePattern.matcher(valString);
                                if (mm.find()) {
                                    groupCount = mm.groupCount();
                                    c = 1;
                                    while (c <= groupCount) {
                                        if (mm.group(c) != null) {
                                            value.setFile(entry.getKey());
                                            value.setInnerRange(new Point(mm.start(c), mm.end(c)));
                                            if (refs.containsKey(entry.getKey())) {
                                                ((List)refs.get(entry.getKey())).add(value);
                                            } else {
                                                refValues = new ArrayList();
                                                refValues.add(value);
                                                refs.put(entry.getKey(), refValues);
                                            }
                                            break;
                                        }
                                        ++c;
                                    }
                                }
                            } else {
                                int index = valString.indexOf(match);
                                if (index != -1) {
                                    value.setFile(entry.getKey());
                                    value.setInnerRange(new Point(index, index + match.length()));
                                    if (refs.containsKey(entry.getKey())) {
                                        ((List)refs.get(entry.getKey())).add(value);
                                        continue block1;
                                    }
                                    ArrayList<IValue> refValues2 = new ArrayList<IValue>();
                                    refValues2.add(value);
                                    refs.put(entry.getKey(), refValues2);
                                    continue block1;
                                }
                            }
                        }
                        --i;
                    }
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    SearchIdleFileReferenceJob.this.fProgressBar.setSelection(donework[0]);
                }
            });
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (Helper.okToUse((Widget)SearchIdleFileReferenceJob.this.fProgressBar)) {
                    SearchIdleFileReferenceJob.this.fProgressBar.dispose();
                }
                SearchIdleFileReferenceJob.this.fTreeViewer.setInput((Object)refs);
                if (refs.size() > 0) {
                    int length = 0;
                    for (List vals : refs.values()) {
                        if (vals == null) continue;
                        length += vals.size();
                    }
                    SearchIdleFileReferenceJob.this.fMonitorLabel.setText("\u5171\u627e\u5230" + length + "\u5904\u7591\u4f3c\u5f15\u7528");
                    Object key = refs.keySet().iterator().next();
                    SearchIdleFileReferenceJob.this.fTreeViewer.expandToLevel(key, -1);
                    List values = (List)refs.get(key);
                    if (values != null && values.size() > 0) {
                        SearchIdleFileReferenceJob.this.fTreeViewer.setSelection((ISelection)new StructuredSelection(values.get(0)), true);
                        SearchIdleFileReferenceJob.this.fTreeViewer.getTree().addTreeListener((TreeListener)new TreeAdapter(){

                            public void treeExpanded(TreeEvent e) {
                                super.treeExpanded(e);
                                Stats.addOperateInfo((String)"STREAM", (String)"SearchRefers", (String)"TreeExpanded");
                            }
                        });
                    }
                } else {
                    SearchIdleFileReferenceJob.this.fMonitorLabel.setText("\u672a\u627e\u5230\u4efb\u4f55\u5f15\u7528");
                }
            }
        });
        return Status.OK_STATUS;
    }
}

