/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.views.action;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.contentassist.Helper;
import com.aptana.editor.json.parsing.ast.JSONParseRootNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.UIUtils;
import com.pandora.core.appstream.AppStreamFileBuilder;
import com.pandora.core.appstream.IValue;
import com.pandora.core.appstream.RelationTree;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.ImageUtils;
import com.pandora.core.utils.StringUtil;
import com.pandora.editor.ui.EditorPlugin;
import com.pandora.editor.ui.JSONUtils;
import com.pandora.editor.ui.MessageWithLinkDialog;
import com.pandora.editor.ui.MobileProjectResourceCollector;
import com.pandora.editor.ui.editors.AppConfigEditor;
import com.pandora.editor.ui.editors.pages.JSONSourcePage;
import com.pandora.editor.ui.editors.views.CommonResourceFilter;
import com.pandora.editor.ui.editors.views.RefFileContentProvider;
import com.pandora.editor.ui.editors.views.RefFileLabelProvider;
import com.pandora.editor.ui.editors.views.StreamResourceLabelProvider;
import com.pandora.editor.ui.editors.views.StreamViewerSorter;
import com.pandora.editor.ui.editors.views.action.SearchIdleFileReferenceJob;
import java.awt.Desktop;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class CheckIdleResourceDialog
extends Dialog {
    private static final String OPEN_STREAM_EDITOR_ACTION_MSG = "\u70b9\u6b64\u4fee\u6b63";
    private static final String OPEN_DEFINE_UNPACKAGE_ACTION_MSG = "\u5982\u4f55\u81ea\u5b9a\u4e49\u4e0d\u6253\u5305\u6587\u4ef6\uff1f";
    private static final String OPEN_STREAM_SOURCE_EDITOR_ACTION_MSG = "\u67e5\u770b\u4e0d\u6253\u5305\u8d44\u6e90/\u81ea\u5b9a\u4e49\u6dfb\u52a0\u4e0d\u6253\u5305\u8d44\u6e90";
    private Map<IFile, List<IValue>> fProjectValues = null;
    private Map fManifest = null;
    private HMobileProject fMobileProject = null;
    private ContainerCheckedTreeViewer fContainerCheckedTreeViewer = null;
    private Object[] fCheckElements = null;
    private SearchIdleFileReferenceJob fSeatchJob = null;
    private ProgressBar fProgressBar = null;
    private Label fProcessMonitor = null;
    private Job fProcessProjectValuesJob = null;
    private static ImageDescriptor unpackImageDesc = ResourceManager.getPluginImageDescriptor((String)"com.pandora.editor.ui", (String)"icons/unpackage.png");

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "\u52a0\u5165unpackage\u6e05\u5355", true);
        this.createButton(parent, 1, "\u53d6\u6d88", false);
    }

    protected CheckIdleResourceDialog(Shell parentShell, HMobileProject mProject, Map manifest) {
        super(parentShell);
        this.fManifest = manifest;
        this.fMobileProject = mProject;
    }

    public ContainerCheckedTreeViewer getContainerCheckedTreeViewer() {
        return this.fContainerCheckedTreeViewer;
    }

    protected void okPressed() {
        if (this.fContainerCheckedTreeViewer != null) {
            this.fCheckElements = this.fContainerCheckedTreeViewer.getCheckedElements();
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(1000, 700);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Collection idles;
        Map idleResources;
        parent.getShell().setText("\u6dfb\u52a0\u6587\u4ef6\u5230unpackage\u6e05\u5355");
        Composite body = (Composite)super.createDialogArea(parent);
        this.fProcessMonitor = new Label(body, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(0, 25).applyTo((Control)this.fProcessMonitor);
        this.fProgressBar = new ProgressBar(body, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(0, 5).applyTo((Control)this.fProgressBar);
        SashForm sashForm = new SashForm(body, 256);
        GridDataFactory.fillDefaults().grab(true, true).hint(0, 800).applyTo((Control)sashForm);
        GridLayoutFactory.fillDefaults().applyTo((Composite)sashForm);
        Composite container = new Composite((Composite)sashForm, 0);
        GridLayoutFactory.fillDefaults().applyTo(container);
        this.fContainerCheckedTreeViewer = new ContainerCheckedTreeViewer(container, 65568);
        this.fContainerCheckedTreeViewer.setAutoExpandLevel(2);
        Map dependencies = (Map)this.fManifest.get("dependencies");
        if (dependencies.containsKey("idle") && (idleResources = (Map)dependencies.get("idle")).containsKey("resources") && (idles = (Collection)idleResources.get("resources")) != null && idles.size() > 30) {
            this.fContainerCheckedTreeViewer.setAutoExpandLevel(1);
        }
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.fContainerCheckedTreeViewer.getControl());
        Tree tree = this.fContainerCheckedTreeViewer.getTree();
        tree.setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(tree, 16384);
        nameColumn.setText("\u8d44\u6e90\u540d\u79f0");
        nameColumn.setWidth(260);
        TreeColumn sizeColumn = new TreeColumn(tree, 16384);
        sizeColumn.setText("\u8d44\u6e90\u5927\u5c0f");
        sizeColumn.setWidth(80);
        this.fContainerCheckedTreeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fContainerCheckedTreeViewer.setLabelProvider((IBaseLabelProvider)new StreamResourceLabelProvider(dependencies));
        this.fContainerCheckedTreeViewer.setSorter((ViewerSorter)new StreamViewerSorter());
        final List idleResources2 = new AppStreamFileBuilder().getIdleResources(this.fMobileProject);
        this.fContainerCheckedTreeViewer.setFilters(new ViewerFilter[]{new CommonResourceFilter(), new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IResource) {
                    IResource file = (IResource)element;
                    String filePath = file.getProjectRelativePath().toString();
                    if (idleResources2.contains(filePath)) {
                        return true;
                    }
                    if (file instanceof IFolder) {
                        for (String idle : idleResources2) {
                            if (!idle.startsWith(filePath)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }});
        this.fContainerCheckedTreeViewer.setInput((Object)this.fMobileProject.getProject());
        Link desc1 = new Link(container, 0);
        desc1.setText("<a>\u67e5\u770b\u4e0d\u6253\u5305\u8d44\u6e90/\u81ea\u5b9a\u4e49\u6dfb\u52a0\u4e0d\u6253\u5305\u8d44\u6e90</a>\u3002");
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, -1).applyTo((Control)desc1);
        if (this.fManifest.containsKey("unpackage")) {
            Collection unpackages = (Collection)this.fManifest.get("unpackage");
            ArrayList<IResource> resources = new ArrayList<IResource>();
            for (Object obj : unpackages) {
                IResource res;
                String filePath = obj.toString();
                if (!StringUtil.isNotBlank((String)filePath) || (res = this.fMobileProject.getProject().findMember(filePath)) == null || !res.exists()) continue;
                resources.add(res);
            }
            this.fContainerCheckedTreeViewer.setCheckedElements((Object[])resources.toArray(new IResource[resources.size()]));
        }
        desc1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (CheckIdleResourceDialog.OPEN_STREAM_SOURCE_EDITOR_ACTION_MSG.equals(e.text)) {
                        CheckIdleResourceDialog.this.openManifestEditor();
                    } else if (CheckIdleResourceDialog.OPEN_DEFINE_UNPACKAGE_ACTION_MSG.equals(e.text)) {
                        Desktop.getDesktop().browse(URI.create("http://ask.dcloud.net.cn/article/480"));
                    } else if (CheckIdleResourceDialog.OPEN_STREAM_EDITOR_ACTION_MSG.equals(e.text)) {
                        CheckIdleResourceDialog.this.openStreamEditor();
                    }
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                }
            }
        });
        final Composite rightContent = new Composite((Composite)sashForm, 0);
        GridLayoutFactory.fillDefaults().applyTo(rightContent);
        this.createFileInfoPart(rightContent, null);
        sashForm.setSashWidth(5);
        sashForm.setWeights(new int[]{40, 60});
        this.fContainerCheckedTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (selection.getFirstElement() instanceof IFile) {
                        CheckIdleResourceDialog.this.createFileInfoPart(rightContent, (IFile)selection.getFirstElement());
                    } else {
                        CheckIdleResourceDialog.this.createFileInfoPart(rightContent, null);
                    }
                }
            }
        });
        if (new AppStreamFileBuilder().hasIdleResources(this.fMobileProject)) {
            this.processProjectStringValues();
        } else {
            this.fProgressBar.dispose();
            this.fProcessMonitor.setText("\u672a\u68c0\u6d4b\u5230\u6ca1\u6709\u88ab\u5f15\u7528\u7684\u6587\u4ef6\uff0c\u6216\u8005\u6ca1\u6709\u88ab\u5f15\u7528\u7684\u6587\u4ef6\u5df2\u7ecf\u88ab\u52a0\u5165\u5230unpackage\u5217\u8868\u4e2d\u3002");
        }
        return body;
    }

    public boolean close() {
        if (this.fProcessProjectValuesJob != null) {
            this.fProcessProjectValuesJob.cancel();
            this.fProcessProjectValuesJob = null;
        }
        return super.close();
    }

    protected void processProjectStringValues() {
        this.fProcessProjectValuesJob = new Job("search project string values..."){

            protected IStatus run(IProgressMonitor monitor) {
                MobileProjectResourceCollector ctor = new MobileProjectResourceCollector(CheckIdleResourceDialog.this.fManifest);
                LinkedHashMap<IFile, List<IValue>> values = new LinkedHashMap<IFile, List<IValue>>();
                try {
                    CheckIdleResourceDialog.this.fMobileProject.getProject().accept((IResourceVisitor)ctor);
                    final List<IFile> files = ctor.getFiles();
                    AppStreamFileBuilder builder = new AppStreamFileBuilder();
                    Stats.addOperateInfo((String)"STREAM", (String)"handle idles", (String)"begin");
                    monitor.beginTask("\u6b63\u5728\u5904\u7406\u6ca1\u6709\u88ab\u5f15\u7528\u7684\u6587\u4ef6...", files.size());
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CheckIdleResourceDialog.this.fProcessMonitor.setText("\u6b63\u5728\u5904\u7406\u6ca1\u6709\u88ab\u5f15\u7528\u7684\u6587\u4ef6...");
                            CheckIdleResourceDialog.this.fProgressBar.setMinimum(0);
                            CheckIdleResourceDialog.this.fProgressBar.setMaximum(files.size());
                        }
                    });
                    for (IFile file : files) {
                        if (monitor.isCanceled()) {
                            Stats.addOperateInfo((String)"STREAM", (String)"handle idles", (String)"cancel");
                            throw new RuntimeException();
                        }
                        RelationTree tree = new RelationTree(file.getLocationURI(), null);
                        builder.processRelationTree(file, tree, CheckIdleResourceDialog.this.fMobileProject.getProject(), new HashSet(), false, (IProgressMonitor)new NullProgressMonitor());
                        if (CollectionsUtil.isNotEmpty((Collection)tree.getValues())) {
                            values.put(file, new ArrayList(tree.getValues()));
                        }
                        monitor.worked(1);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                CheckIdleResourceDialog.this.fProgressBar.setSelection(CheckIdleResourceDialog.this.fProgressBar.getSelection() + 1);
                            }
                        });
                    }
                    monitor.done();
                    CheckIdleResourceDialog.this.setProjectValues(values);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Composite parent = CheckIdleResourceDialog.this.fProcessMonitor.getParent();
                            CheckIdleResourceDialog.this.fProgressBar.dispose();
                            CheckIdleResourceDialog.this.fProcessMonitor.dispose();
                            parent.layout(true);
                            ISelection selection = CheckIdleResourceDialog.this.fContainerCheckedTreeViewer.getSelection();
                            if (selection != null) {
                                CheckIdleResourceDialog.this.fContainerCheckedTreeViewer.setSelection(selection);
                            }
                        }
                    });
                }
                catch (Exception e1) {
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e1);
                }
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)this.fProcessProjectValuesJob);
        this.fProcessProjectValuesJob.schedule();
    }

    protected Composite createFileInfoPart(Composite rightContent, final IFile firstElement) {
        Control[] controlArray = rightContent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (Helper.okToUse((Widget)child)) {
                child.dispose();
            }
            ++n2;
        }
        Composite parent = new Composite(rightContent, 0);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        if (firstElement == null) {
            Label desc = new Label(parent, 0x1000000);
            desc.setImage(unpackImageDesc.createImage());
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)desc);
            rightContent.layout();
            return parent;
        }
        Group baseInfoGroup = new Group(parent, 0);
        baseInfoGroup.setText("\u57fa\u672c\u4fe1\u606f");
        baseInfoGroup.setLayout((Layout)new FormLayout());
        GridDataFactory.fillDefaults().grab(true, false).hint(0, 125).applyTo((Control)baseInfoGroup);
        int labelWidth = 80;
        int left = 2;
        int height = 25;
        int gap = 5;
        Label fileNameLab = new Label((Composite)baseInfoGroup, 0);
        fileNameLab.setText("\u6587\u4ef6\u540d");
        FormData data = new FormData(labelWidth, height);
        data.left = new FormAttachment(left);
        data.top = new FormAttachment(5);
        fileNameLab.setLayoutData((Object)data);
        Label fileName = new Label((Composite)baseInfoGroup, 0);
        fileName.setText(firstElement.getName());
        data = new FormData(this.getTextWidth((Control)fileName, fileName.getText()), height);
        data.left = new FormAttachment((Control)fileNameLab, gap);
        data.top = new FormAttachment(5);
        fileName.setLayoutData((Object)data);
        Label filePathLab = new Label((Composite)baseInfoGroup, 0);
        filePathLab.setText("\u6587\u4ef6\u8def\u5f84");
        data = new FormData(labelWidth, height);
        data.left = new FormAttachment(left);
        data.top = new FormAttachment((Control)fileNameLab, gap);
        filePathLab.setLayoutData((Object)data);
        Label filePath = new Label((Composite)baseInfoGroup, 0);
        filePath.setText(firstElement.getProjectRelativePath().removeLastSegments(1).toString());
        data = new FormData(this.getTextWidth((Control)filePath, filePath.getText()), height);
        data.left = new FormAttachment((Control)filePathLab, gap);
        data.top = new FormAttachment((Control)fileName, gap);
        filePath.setLayoutData((Object)data);
        Label fileSizeLab = new Label((Composite)baseInfoGroup, 0);
        fileSizeLab.setText("\u6587\u4ef6\u5927\u5c0f");
        data = new FormData(labelWidth, height);
        data.left = new FormAttachment(left);
        data.top = new FormAttachment((Control)filePathLab, gap);
        fileSizeLab.setLayoutData((Object)data);
        Label fileSize = new Label((Composite)baseInfoGroup, 0);
        fileSize.setText(String.valueOf(firstElement.getLocation().makeAbsolute().toFile().length() / 1024L) + "KB");
        data = new FormData(labelWidth, height);
        data.left = new FormAttachment((Control)fileSizeLab, gap);
        data.top = new FormAttachment((Control)filePath, gap);
        fileSize.setLayoutData((Object)data);
        Label lastModifyTimeLab = new Label((Composite)baseInfoGroup, 0);
        lastModifyTimeLab.setText("\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        data = new FormData();
        data.left = new FormAttachment(left);
        data.top = new FormAttachment((Control)fileSizeLab, gap);
        lastModifyTimeLab.setLayoutData((Object)data);
        Label lastModifyTime = new Label((Composite)baseInfoGroup, 0);
        lastModifyTime.setText(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5  HH\u65f6mm\u5206ss\u79d2").format(new Date(firstElement.getLocalTimeStamp())));
        data = new FormData();
        data.left = new FormAttachment((Control)lastModifyTimeLab, gap);
        data.top = new FormAttachment((Control)fileSize, gap);
        lastModifyTime.setLayoutData((Object)data);
        lastModifyTime.pack(true);
        String fileExt = firstElement.getFileExtension();
        if (Arrays.asList("png", "jpg", "gif", "jpeg", "jpe", "bmp").contains(fileExt)) {
            Image img = SWTResourceManager.getImage((String)firstElement.getLocation().makeAbsolute().toFile().getAbsolutePath());
            data = new FormData(80, 60);
            data.left = new FormAttachment((Control)lastModifyTime, gap + 10);
            data.top = new FormAttachment(gap);
            try {
                img = ImageUtils.scaleImage((Image)img, (double)data.width, (double)data.height, (boolean)false);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            Label imgLabel = new Label((Composite)baseInfoGroup, 0x1000000);
            imgLabel.setLayoutData((Object)data);
            imgLabel.setImage(img);
            imgLabel.pack(true);
            Link link = new Link((Composite)baseInfoGroup, 0);
            link.setText("<a>\u539f\u56fe\u9884\u89c8</a>");
            data = new FormData(labelWidth, height);
            data.left = new FormAttachment((Control)lastModifyTime, gap + 25);
            data.top = new FormAttachment((Control)fileSize, gap);
            link.setLayoutData((Object)data);
            link.pack(true);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        IDE.openEditor((IWorkbenchPage)UIUtils.getActivePage(), (IFile)firstElement);
                    }
                    catch (PartInitException e1) {
                        IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e1);
                    }
                }
            });
        }
        Group refGroup = new Group(parent, 0);
        refGroup.setText("\u6587\u4ef6\u6709\u53ef\u80fd\u5728\u5982\u4e0b\u6587\u4ef6\u4e2d\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5\u5e76\u5904\u7406");
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)refGroup);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)refGroup);
        GridDataFactory.fillDefaults().grab(true, false).hint(0, 10).applyTo((Control)new Label((Composite)refGroup, 1024));
        if (this.fSeatchJob != null) {
            this.fSeatchJob.cancel();
        }
        if (CollectionsUtil.isEmpty(this.fProjectValues)) {
            rightContent.layout();
            return parent;
        }
        Label monitorLabel = new Label((Composite)refGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(0, 20).applyTo((Control)monitorLabel);
        ProgressBar bar = new ProgressBar((Composite)refGroup, 0);
        bar.setState(0);
        bar.setMinimum(0);
        bar.setMaximum(this.fProjectValues.size());
        TreeViewer treeViewer = new TreeViewer((Composite)refGroup, 65536);
        treeViewer.getTree().setHeaderVisible(false);
        TreeViewerColumn colunm = new TreeViewerColumn(treeViewer, 16384);
        colunm.getColumn().setText("");
        colunm.getColumn().setWidth(550);
        colunm.setLabelProvider((CellLabelProvider)new RefFileLabelProvider());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeViewer.getTree());
        treeViewer.setContentProvider((IContentProvider)new RefFileContentProvider());
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object value;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (value = ((IStructuredSelection)selection).getFirstElement()) instanceof IValue) {
                    IFile file = ((IValue)value).getFile();
                    Point point = ((IValue)value).getRange();
                    if (file != null) {
                        try {
                            IEditorPart editor = IDE.openEditor((IWorkbenchPage)UIUtils.getActivePage(), (IFile)file);
                            if (editor instanceof AbstractTextEditor) {
                                ((AbstractTextEditor)editor).selectAndReveal(point.x, point.y - point.x);
                            }
                            Stats.addOperateInfo((String)"STREAM", (String)CheckIdleResourceDialog.class.getSimpleName(), (String)"open editor");
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).hint(0, 3).applyTo((Control)bar);
        this.fSeatchJob = new SearchIdleFileReferenceJob("\u67e5\u627e\u6587\u4ef6\u5f15\u7528\u5904", firstElement, this.fProjectValues, bar, monitorLabel, treeViewer);
        EclipseUtil.setSystemForJob((Job)this.fSeatchJob);
        this.fSeatchJob.schedule(50L);
        rightContent.layout();
        return parent;
    }

    public int getTextWidth(Control crl, String text) {
        GC gc = new GC((Drawable)crl);
        int width = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            width += gc.getAdvanceWidth(c);
            ++i;
        }
        gc.dispose();
        return width;
    }

    protected void openStreamEditor() throws Exception {
        IFile file = this.fMobileProject.getProject().getFile("manifest.json");
        IEditorPart part = IDE.openEditor((IWorkbenchPage)UIUtils.getActivePage(), (IFile)file, (boolean)true);
        if (part instanceof AppConfigEditor) {
            AppConfigEditor configEditor = (AppConfigEditor)part;
            configEditor.setActivePage("com.pandora.editor.appstream");
            MessageWithLinkDialog dialog = new MessageWithLinkDialog(this.getParentShell(), "\u63d0\u793a", this.getParentShell().getImage(), "\u5df2\u6253\u5f00\u9875\u9762\u5f15\u7528\u5173\u7cfb\uff0c\u5728\u5de6\u4fa7\u6811\u9009\u4e2d\u4e00\u4e2a\u9875\u9762\uff0c\u53f3\u4fa7\u5176\u4ed6\u8d44\u6e90\u5217\u8868\u4e2d\u5e26\"?\"\u89d2\u6807\u7684\u6587\u4ef6\u5373\u4e3a\u672a\u88ab\u4f7f\u7528\u7684\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u3001\u914d\u7f6e\u8fd9\u4e9b\u6587\u4ef6\u7684\u5f15\u7528\u5173\u7cfb", 2, new String[]{"\u786e\u5b9a"}, 0);
            dialog.open();
        }
    }

    protected void openManifestEditor() throws Exception {
        AppConfigEditor configEditor;
        IFormPage page;
        if (!this.fManifest.containsKey("unpackage")) {
            MessageWithLinkDialog dialog = new MessageWithLinkDialog(this.getParentShell(), "\u63d0\u793a", this.getParentShell().getImage(), "\u5f53\u524d\u6ca1\u6709\u5b9a\u4e49\u4e0d\u6253\u5305\u6587\u4ef6\uff0c\u5982\u9700\u81ea\u5b9a\u4e49\u4e0d\u6253\u5305\u6587\u4ef6\u3002\u6559\u7a0b\u53c2\u8003<a>\u5982\u4f55\u81ea\u5b9a\u4e49\u4e0d\u6253\u5305\u6587\u4ef6\uff1f</a>", 2, new String[]{"\u786e\u5b9a"}, 0);
            dialog.create();
            dialog.getMessageLink().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        Desktop.getDesktop().browse(URI.create("http://ask.dcloud.net.cn/article/491"));
                    }
                    catch (Exception ex) {
                        IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                    }
                }
            });
            dialog.open();
            return;
        }
        IFile file = this.fMobileProject.getProject().getFile("manifest.json");
        IEditorPart part = IDE.openEditor((IWorkbenchPage)UIUtils.getActivePage(), (IFile)file, (boolean)true);
        if (part instanceof AppConfigEditor && (page = (configEditor = (AppConfigEditor)part).setActivePage("com.pandora.editor.appconfig.jsonsource")) instanceof JSONSourcePage) {
            JSONSourcePage sourcePage = (JSONSourcePage)page;
            IParseRootNode root = sourcePage.getSourceEditor().getAST();
            IParseNode node = JSONUtils.findJSONNodeByName((JSONParseRootNode)root, "unpackage");
            sourcePage.getSourceEditor().selectAndReveal(node.getStartingOffset() + 1, 0);
            sourcePage.getSourceEditor().setFocus();
            MessageWithLinkDialog dialog = new MessageWithLinkDialog(this.getParentShell(), "\u63d0\u793a", this.getParentShell().getImage(), "\u5df2\u6253\u5f00manifest.json\u4ee3\u7801\u89c6\u56fe,\u5176\u4e2dunpackage\u8282\u70b9\u4e2d\u8bb0\u5f55\u7684\u5373\u4e3aunpackage\u6587\u4ef6\u6e05\u5355\uff0c\u5982\u9700\u81ea\u5b9a\u4e49\u4e0d\u6253\u5305\u6587\u4ef6\uff0c\u8bf7\u53c2\u8003<a>\u5982\u4f55\u81ea\u5b9a\u4e49\u4e0d\u6253\u5305\u6587\u4ef6\uff1f</a>", 2, new String[]{"\u786e\u5b9a"}, 0);
            dialog.create();
            dialog.getMessageLink().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        Desktop.getDesktop().browse(URI.create("http://ask.dcloud.net.cn/article/491"));
                    }
                    catch (Exception ex) {
                        IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                    }
                }
            });
            dialog.open();
        }
    }

    public Object[] getCheckedElements() {
        return this.fCheckElements;
    }

    public void setProjectValues(Map<IFile, List<IValue>> values) {
        this.fProjectValues = values;
    }
}

