/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.views;

import com.pandora.editor.ui.editors.pages.AppStreamConfigPage;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wb.swt.ResourceManager;

public class HTMLViewerLabelProvider
extends WorkbenchLabelProvider {
    private AppStreamConfigPage fStreamPage = null;

    public HTMLViewerLabelProvider(AppStreamConfigPage streamPage) {
        this.fStreamPage = streamPage;
    }

    protected ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
        if (element instanceof IProject) {
            return ResourceManager.getPluginImageDescriptor((String)"com.pandora.editor.ui", (String)"icons/project.png");
        }
        return super.decorateImage(input, element);
    }

    public Font getFont(Object element) {
        IFolder folder;
        IFile file;
        if (this.fStreamPage != null && this.fStreamPage.getDiffDependencies() != null && (element instanceof IFile ? this.isDiffPage(file = (IFile)element) : element instanceof IFolder && this.hasDiffPage(folder = (IFolder)element))) {
            return new FontRegistry().getBold(this.getSystemFontName());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasDiffPage(IFolder folder) {
        try {
            if (this.fStreamPage.getDiffDependencies() == null) {
                return false;
            }
            boolean hasDiff = false;
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return hasDiff;
                }
                IResource child = iResourceArray[n2];
                if (child instanceof IFolder) {
                    if (hasDiff) return true;
                    if (this.hasDiffPage((IFolder)child)) return true;
                    boolean bl = false;
                    hasDiff = bl;
                    if (hasDiff) {
                        return hasDiff;
                    }
                } else if (child instanceof IFile && this.isDiffPage((IFile)child)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean isDiffPage(IFile file) {
        String keyPath = file.getProjectRelativePath().toString();
        if (this.fStreamPage.getDiffDependencies().containsKey(keyPath)) {
            try {
                Map page = (Map)this.fStreamPage.getDiffDependencies().get(keyPath);
                if (page != null) {
                    Collection list;
                    boolean empty = true;
                    if (page.containsKey("refer")) {
                        list = (Collection)page.get("refer");
                        empty = list.isEmpty();
                    }
                    if (page.containsKey("resources")) {
                        list = (Collection)page.get("resources");
                        empty = list.isEmpty() && empty;
                    }
                    return !empty;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    protected String getSystemFontName() {
        return Display.getDefault().getSystemFont().getFontData()[0].getName();
    }
}

