/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.pages;

import com.aptana.core.logging.IdeLog;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.model.Plus;
import com.pandora.core.mobile.model.SplashScreenSetting;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.editor.ui.EditorPlugin;
import com.pandora.editor.ui.editors.pages.AbstractAppConfigPage;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.wb.swt.ResourceManager;

public class SplashsAppConfigPage
extends AbstractAppConfigPage {
    private static final String DATA_DEFAULT_IMAGE = "DATA_DEFAULT_IMAGE";
    private static final String DATA_FILE = "DATA_FILE";
    private static final String DATA_TITLE = "DATA_TITLE";
    private static final String DATA_SIZE = "DATA_SIZE";
    private static final String DATA_FULLSIZE = "DATA_FULLSIZE";
    private String TEXT_SELECT = "     \u9009\u62e9     ";
    private String TEXT_CHANGE = "     \u66f4\u6362     ";
    private String TIP_TEXT_SELECT = "\u9009\u62e9\u542f\u52a8\u56fe\u7247";
    private String TIP_TEXT_CHANGE = "\u66f4\u6362\u542f\u52a8\u56fe\u7247";
    private Image viewImage = ResourceManager.getPluginImageDescriptor((String)"com.pandora.editor.ui", (String)"/icons/full/view.png").createImage();
    private String rootPath;
    private boolean fullscreen = false;
    private Button autoCloseRadio;
    private Button delayCloseRadio;
    private Button manualCloseRadio;
    private Text delayText;
    private Button waitingCheck;
    private Label delayLabel;
    private Map<String, Button> fileButtonMap = new HashMap<String, Button>();
    private Map<String, Button> clearButtonMap = new HashMap<String, Button>();
    private Map<String, ControlDecoration> controlDecorationMap = new HashMap<String, ControlDecoration>();
    private Map<String, Label> sizeLabelMap = new HashMap<String, Label>();

    public SplashsAppConfigPage(FormEditor editor, String id, String title, JSONObject pageConfig) {
        super(editor, id, title, pageConfig);
        this.rootPath = this.appPageConfig.optString("path");
    }

    @Override
    protected void createPageContent(IManagedForm managedForm) {
        FormToolkit formToolkit = managedForm.getToolkit();
        this.fullscreen = this.getManifestConfiguration().isFullscreen();
        this.createStartContent(formToolkit);
        this.createSplashsContent(formToolkit);
        this.bindErrorDecorations(formToolkit);
    }

    private void createStartContent(FormToolkit formToolkit) {
        Composite noticeComposite = formToolkit.createComposite(this.bodyContent);
        noticeComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 10).create());
        noticeComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Label noticeText = new Label(noticeComposite, 72);
        noticeText.setText("\u6ce8\uff1a\u542f\u52a8\u56fe\u7247\u5fc5\u987b\u4f7f\u7528png\u683c\u5f0f\u7684\u56fe\u7247\u3002\u4e0d\u652f\u6301\u5176\u4ed6\u683c\u5f0f\u7684\u56fe\u7247\u901a\u8fc7\u4fee\u6539\u540e\u7f00\u540d\u5f97\u5230\u7684png\u56fe\u7247\u3002");
        noticeText.setFont(this.boldFont);
        noticeText.setForeground(Display.getDefault().getSystemColor(3));
        Composite group = this.createGroup("\u542f\u52a8\u9009\u9879", formToolkit);
        Composite contentComposite = formToolkit.createComposite(group, 0);
        contentComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(20, 20, 15, 20).create());
        contentComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite radioComposite = new Composite(contentComposite, 0x400000);
        radioComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        radioComposite.setLayout((Layout)new FormLayout());
        int checkAndLabelSpace = 3;
        int top = 3;
        int leftSpace = 20;
        String tip = "App\u9996\u9875\u52a0\u8f7d\u5b8c\u6bd5\u540e\uff0c\u76f4\u63a5\u5173\u95ed\u542f\u52a8\u754c\u9762\u8fdb\u5165\u9996\u9875";
        this.autoCloseRadio = new Button(radioComposite, 16);
        this.autoCloseRadio.setToolTipText(tip);
        FormData fd = new FormData();
        fd.top = new FormAttachment(top);
        this.autoCloseRadio.setLayoutData((Object)fd);
        Label autoRadioLabel = formToolkit.createLabel(radioComposite, "\u81ea\u52a8\u5173\u95ed\u542f\u52a8\u754c\u9762");
        autoRadioLabel.setForeground(this.realTimeColor);
        autoRadioLabel.setToolTipText(tip);
        autoRadioLabel.setData("button", (Object)this.autoCloseRadio);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.autoCloseRadio, checkAndLabelSpace);
        fd.top = new FormAttachment(top);
        autoRadioLabel.setLayoutData((Object)fd);
        tip = "App\u9996\u9875\u52a0\u8f7d\u5b8c\u6bd5\u540e\uff0c\u5ef6\u65f6\u4e00\u5b9a\u65f6\u95f4\u5173\u95ed\u542f\u52a8\u754c\u9762\uff0c\u8bf7\u586b\u5199\u5ef6\u65f6\u65f6\u95f4\uff0c\u5ef6\u65f6\u65f6\u95f4\u4e3a0\u4e0e\u81ea\u52a8\u5173\u95ed\u6548\u679c\u76f8\u540c";
        this.delayCloseRadio = new Button(radioComposite, 16);
        this.delayCloseRadio.setToolTipText(tip);
        fd = new FormData();
        fd.left = new FormAttachment((Control)autoRadioLabel, leftSpace);
        fd.top = new FormAttachment(top);
        this.delayCloseRadio.setLayoutData((Object)fd);
        Label delayRadioLabel = formToolkit.createLabel(radioComposite, "\u5ef6\u65f6\u5173\u95ed\u542f\u52a8\u754c\u9762");
        delayRadioLabel.setForeground(this.realTimeColor);
        delayRadioLabel.setToolTipText(tip);
        delayRadioLabel.setData("button", (Object)this.delayCloseRadio);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.delayCloseRadio, checkAndLabelSpace);
        fd.top = new FormAttachment(top);
        delayRadioLabel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)delayRadioLabel, 10);
        fd.top = new FormAttachment(top);
        Label label = formToolkit.createLabel(radioComposite, "\u5ef6\u65f6");
        label.setToolTipText(tip);
        label.setForeground(this.realTimeColor);
        label.setLayoutData((Object)fd);
        this.delayText = formToolkit.createText(radioComposite, "");
        this.delayText.setEnabled(false);
        this.delayText.setToolTipText(tip);
        fd = new FormData();
        fd.width = 20;
        fd.left = new FormAttachment((Control)label, checkAndLabelSpace);
        this.delayText.setLayoutData((Object)fd);
        this.delayLabel = formToolkit.createLabel(radioComposite, "\u6beb\u79d2");
        this.delayLabel.setToolTipText(tip);
        this.delayLabel.setForeground(this.realTimeColor);
        fd = new FormData();
        fd.top = new FormAttachment(top);
        fd.left = new FormAttachment((Control)this.delayText, checkAndLabelSpace);
        this.delayLabel.setLayoutData((Object)fd);
        tip = null;
        this.manualCloseRadio = new Button(radioComposite, 16);
        this.manualCloseRadio.setToolTipText(tip);
        fd = new FormData();
        fd.top = new FormAttachment(top);
        fd.left = new FormAttachment((Control)this.delayLabel, leftSpace);
        this.manualCloseRadio.setLayoutData((Object)fd);
        tip = "\u9009\u62e9\u6b64\u9879\u540e\uff0c\u9700\u5728\u4ee3\u7801\u4e2d\u901a\u8fc7plus.navigator.closeSplashscreen\u65b9\u6cd5\u5173\u95ed\u542f\u52a8\u754c\u9762\uff0c\u5728\u6267\u884c\u8be5\u65b9\u6cd5\u524d\u542f\u52a8\u754c\u9762\u5c06\u4e00\u76f4\u663e\u793a";
        Label manualRadioLabel = formToolkit.createLabel(radioComposite, "\u624b\u52a8\u5173\u95ed\u542f\u52a8\u754c\u9762");
        manualRadioLabel.setForeground(this.realTimeColor);
        manualRadioLabel.setToolTipText(tip);
        manualRadioLabel.setData("button", (Object)this.manualCloseRadio);
        fd = new FormData();
        fd.top = new FormAttachment(top);
        fd.left = new FormAttachment((Control)this.manualCloseRadio, checkAndLabelSpace);
        manualRadioLabel.setLayoutData((Object)fd);
        tip = null;
        this.waitingCheck = formToolkit.createButton(radioComposite, null, 32);
        this.waitingCheck.setToolTipText(tip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.autoCloseRadio, 20);
        fd.left = new FormAttachment();
        this.waitingCheck.setLayoutData((Object)fd);
        Label waitingCheckLabel = formToolkit.createLabel(radioComposite, "\u542f\u52a8\u754c\u9762\u663e\u793a\u7b49\u5f85\u96ea\u82b1");
        waitingCheckLabel.setForeground(this.realTimeColor);
        waitingCheckLabel.setToolTipText(tip);
        waitingCheckLabel.setData("button", (Object)this.waitingCheck);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.autoCloseRadio, 20);
        fd.left = new FormAttachment((Control)this.waitingCheck, checkAndLabelSpace);
        waitingCheckLabel.setLayoutData((Object)fd);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Button button = (Button)e.widget.getData("button");
                if (button == SplashsAppConfigPage.this.waitingCheck) {
                    button.setSelection(!button.getSelection());
                } else {
                    button.setSelection(true);
                }
                Event event = new Event();
                event.widget = e.widget;
                event.type = 13;
                button.notifyListeners(13, event);
            }
        };
        autoRadioLabel.addMouseListener((MouseListener)mouseAdapter);
        delayRadioLabel.addMouseListener((MouseListener)mouseAdapter);
        manualRadioLabel.addMouseListener((MouseListener)mouseAdapter);
        waitingCheckLabel.addMouseListener((MouseListener)mouseAdapter);
    }

    private void createSplashsContent(FormToolkit formToolkit) {
        try {
            JSONArray listJsonArray = this.appPageConfig.optJSONArray("list");
            ArrayList<Composite> descComposites = new ArrayList<Composite>();
            int maxWidth = 0;
            int i = 0;
            while (i < listJsonArray.size()) {
                try {
                    JSONObject listJsonObject = listJsonArray.getJSONObject(i);
                    String groupTitle = listJsonObject.optString("title");
                    String splashPath = listJsonObject.optString("path");
                    String groupDesc = listJsonObject.optString("desc");
                    String imageDir = "ios/";
                    if (!groupTitle.toLowerCase().contains("ios")) {
                        imageDir = "android/";
                    }
                    Composite group = this.createGroup(groupTitle, formToolkit);
                    Composite splashsConfigContent = formToolkit.createComposite(group, 0);
                    splashsConfigContent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
                    splashsConfigContent.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(20, 20, 15, 20).spacing(0, 0).numColumns(2).create());
                    if (StringUtil.isNotBlank((String)groupDesc)) {
                        Composite descContent = formToolkit.createComposite(splashsConfigContent, 0);
                        descContent.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
                        descContent.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).create());
                        formToolkit.createLabel(descContent, groupDesc, 64).setLayoutData((Object)GridDataFactory.fillDefaults().create());
                    }
                    JSONArray splashsJsonArray = listJsonObject.optJSONArray("splashs");
                    int y = 0;
                    while (y < splashsJsonArray.size()) {
                        JSONObject splashsJSONObject = splashsJsonArray.getJSONObject(y);
                        JSONArray sizeJsonArray = splashsJSONObject.optJSONArray("size");
                        String defaultImageName = splashsJSONObject.optString("default");
                        if (StringUtil.isBlank((String)defaultImageName)) {
                            defaultImageName = "splash" + sizeJsonArray.optInt(0) + "x" + sizeJsonArray.optInt(1) + ".png";
                        }
                        JSONArray fullSizeJsonArray = null;
                        if (splashsJSONObject.has("fullsize")) {
                            fullSizeJsonArray = splashsJSONObject.optJSONArray("fullsize");
                        }
                        String title = splashsJSONObject.optString("desc");
                        final String path = StringUtil.join((String)".", (String[])new String[]{this.rootPath, splashPath, splashsJSONObject.optString("path")});
                        Point size = null;
                        size = this.fullscreen && fullSizeJsonArray != null ? new Point(fullSizeJsonArray.optInt(0), fullSizeJsonArray.optInt(1)) : new Point(sizeJsonArray.optInt(0), sizeJsonArray.optInt(1));
                        if (y == 0) {
                            Composite topConposite = formToolkit.createComposite(splashsConfigContent, 2048);
                            topConposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
                            topConposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 10).create());
                            Label label = formToolkit.createLabel(topConposite, "\u542f\u52a8\u56fe\u7247\u7c7b\u578b", 0x1000000);
                            label.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).create());
                            topConposite = formToolkit.createComposite(splashsConfigContent, 2048);
                            topConposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
                            topConposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 10).create());
                            label = formToolkit.createLabel(topConposite, "\u64cd\u4f5c", 0x1000000);
                            label.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).create());
                        }
                        Composite descComposite = formToolkit.createComposite(splashsConfigContent, 2048);
                        descComposites.add(descComposite);
                        descComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(100, 10).create());
                        Label desc = formToolkit.createLabel(descComposite, String.valueOf(title) + "\r\n" + size.x + "x" + size.y, 0x1000000);
                        desc.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
                        if (fullSizeJsonArray != null) {
                            desc.setData(DATA_TITLE, (Object)title);
                            desc.setData(DATA_SIZE, (Object)new Point(sizeJsonArray.optInt(0), sizeJsonArray.optInt(1)));
                            desc.setData(DATA_FULLSIZE, (Object)new Point(fullSizeJsonArray.optInt(0), fullSizeJsonArray.optInt(1)));
                            this.sizeLabelMap.put(path, desc);
                        }
                        Point descCompositeSize = descComposite.computeSize(-1, -1);
                        maxWidth = maxWidth > descCompositeSize.x ? maxWidth : descCompositeSize.x;
                        Composite buttonConposite = formToolkit.createComposite(splashsConfigContent, 2048);
                        buttonConposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
                        buttonConposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(40, 10).equalWidth(true).spacing(30, 10).numColumns(3).create());
                        final Label viewButton = formToolkit.createLabel(buttonConposite, null, 0);
                        viewButton.setToolTipText("\u70b9\u51fb\u9884\u89c8\u9009\u62e9\u7684\u542f\u52a8\u56fe\u7247");
                        viewButton.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).create());
                        viewButton.setImage(this.viewImage);
                        viewButton.setCursor(this.getSite().getShell().getDisplay().getSystemCursor(21));
                        URL defaultImage = EditorPlugin.getDefault().getBundle().getResource("icons/hbuilder/" + imageDir + defaultImageName);
                        if (defaultImage != null) {
                            viewButton.setData(DATA_DEFAULT_IMAGE, (Object)ResourceUtil.resourcePathToString((URL)defaultImage));
                        }
                        final Button fileButton = formToolkit.createButton(buttonConposite, this.TEXT_SELECT, 0);
                        fileButton.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).create());
                        fileButton.setToolTipText(this.TIP_TEXT_SELECT);
                        fileButton.setData(DATA_SIZE, (Object)size);
                        Button clearButton = formToolkit.createButton(buttonConposite, "  \u8fd8\u539f\u9ed8\u8ba4  ", 0);
                        clearButton.setToolTipText("\u8fd8\u539f\u4e3a\u9ed8\u8ba4\u56fe\u7247");
                        clearButton.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).create());
                        clearButton.setEnabled(false);
                        this.fileButtonMap.put(path, fileButton);
                        this.clearButtonMap.put(path, clearButton);
                        viewButton.addMouseListener((MouseListener)new MouseAdapter(){

                            public void mouseDown(MouseEvent e) {
                                String filePath = (String)fileButton.getData(SplashsAppConfigPage.DATA_FILE);
                                File file = null;
                                if (StringUtil.isBlank((String)filePath)) {
                                    String defaultPath = (String)viewButton.getData(SplashsAppConfigPage.DATA_DEFAULT_IMAGE);
                                    if (StringUtil.isNotBlank((String)defaultPath)) {
                                        file = new File(defaultPath);
                                    }
                                } else {
                                    file = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)SplashsAppConfigPage.this.getEditor().getProject(), (String)filePath);
                                }
                                if (file != null && file.exists()) {
                                    try {
                                        SplashsAppConfigPage.this.getSite().getPage().openEditor((IEditorInput)new FileStoreEditorInput(EFS.getStore((URI)file.toURI())), "org.eclipse.ui.systemExternalEditor");
                                    }
                                    catch (Throwable ex) {
                                        IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                                    }
                                }
                            }
                        });
                        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                String result;
                                File file;
                                String imagePath = (String)fileButton.getData(SplashsAppConfigPage.DATA_FILE);
                                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 65536);
                                dialog.setFilterExtensions(new String[]{"*.png"});
                                if (imagePath != null && (file = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)SplashsAppConfigPage.this.getEditor().getProject(), (String)imagePath)) != null && file.exists()) {
                                    dialog.setFilterPath(file.getParent());
                                    dialog.setFileName(file.getName());
                                }
                                if (StringUtil.isNotBlank((String)(result = dialog.open()))) {
                                    SplashsAppConfigPage.this.changeSplashFile(path, result);
                                    SplashsAppConfigPage.this.recordChangeAndVilidation(Arrays.asList(path));
                                }
                            }
                        });
                        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                SplashsAppConfigPage.this.changeSplashFile(path, null);
                                SplashsAppConfigPage.this.recordChangeAndVilidation(Arrays.asList(path));
                            }
                        });
                        ++y;
                    }
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                }
                ++i;
            }
            for (Composite descComposite : descComposites) {
                GridData gridData = GridDataFactory.fillDefaults().hint(maxWidth, -1).grab(true, true).create();
                descComposite.setLayoutData((Object)gridData);
            }
            descComposites.clear();
        }
        catch (JSONException e) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
        }
    }

    private void bindErrorDecorations(FormToolkit formToolkit) {
        SelectionAdapter selecter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.stateMask <= 0) {
                    Object source = e.getSource();
                    SplashsAppConfigPage.this.checkRadios(source);
                } else {
                    ((Button)e.getSource()).setSelection(false);
                    e.doit = false;
                }
            }
        };
        this.autoCloseRadio.addSelectionListener((SelectionListener)selecter);
        this.delayCloseRadio.addSelectionListener((SelectionListener)selecter);
        this.manualCloseRadio.addSelectionListener((SelectionListener)selecter);
        this.bindErrorValidation(null, "plus.splashscreen.autoclose", 0x1020000, formToolkit, new Control[]{this.delayCloseRadio});
        this.bindErrorValidation(null, "plus.splashscreen.autoclose", 0x1020000, formToolkit, new Control[]{this.manualCloseRadio});
        this.bindErrorValidation((Control)this.autoCloseRadio, "plus.splashscreen.autoclose", 0x1020000, formToolkit, new Control[]{this.autoCloseRadio, this.delayCloseRadio, this.manualCloseRadio}).setMarginWidth(0);
        this.bindErrorValidation((Control)this.delayLabel, "plus.splashscreen.delay", 0x1020000, formToolkit, new Control[]{this.delayText});
        this.bindErrorValidation((Control)this.waitingCheck, "plus.splashscreen.waiting", 0x1020000, formToolkit, new Control[]{this.waitingCheck}).setMarginWidth(0);
        for (String filedPath : this.fileButtonMap.keySet()) {
            this.bindErrorValidation((Control)this.fileButtonMap.get(filedPath), filedPath, 0x1020000, formToolkit, new Control[0]);
            this.controlDecorationMap.put(filedPath, this.createControlDecoration((Control)this.fileButtonMap.get(filedPath), this.fileButtonMap.get(filedPath).getParent(), 0x1020000, this.warnImage));
        }
    }

    private void checkRadios(Object source) {
        if (source == this.autoCloseRadio && this.autoCloseRadio.getSelection()) {
            this.delayCloseRadio.setSelection(false);
            this.manualCloseRadio.setSelection(false);
            this.delayText.setText("0");
        } else if (source == this.delayCloseRadio && this.delayCloseRadio.getSelection()) {
            this.autoCloseRadio.setSelection(false);
            this.manualCloseRadio.setSelection(false);
        } else if (source == this.manualCloseRadio && this.manualCloseRadio.getSelection()) {
            this.autoCloseRadio.setSelection(false);
            this.delayCloseRadio.setSelection(false);
        }
        this.delayText.setEnabled(this.delayCloseRadio.getSelection());
    }

    private boolean changeSplashFile(String path, String value) {
        Button fileButton = this.fileButtonMap.get(path);
        if (StringUtil.isBlank((String)value) && StringUtil.isBlank((String)((String)fileButton.getData(DATA_FILE)))) {
            return false;
        }
        boolean show = StringUtil.isNotBlank((String)value);
        if (show) {
            value = this.getProjectRelativePath(value);
        }
        fileButton.setData(DATA_FILE, (Object)value);
        if (show) {
            fileButton.setText(this.TEXT_CHANGE);
            fileButton.setToolTipText(this.TIP_TEXT_CHANGE);
            fileButton.getParent().setToolTipText(value);
        } else {
            fileButton.setText(this.TEXT_SELECT);
            fileButton.setToolTipText(this.TIP_TEXT_SELECT);
            fileButton.getParent().setToolTipText("");
        }
        this.clearButtonMap.get(path).setEnabled(show);
        this.checkSize(path);
        return true;
    }

    private void checkSize(String path) {
        ControlDecoration controlDecoration = this.controlDecorationMap.get(path);
        String filePath = (String)this.fileButtonMap.get(path).getData(DATA_FILE);
        if (StringUtil.isBlank((String)filePath)) {
            if (controlDecoration.isVisible()) {
                controlDecoration.hide();
            }
            return;
        }
        File file = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)this.getEditor().getProject(), (String)filePath);
        if (file != null && file.isFile() && file.exists()) {
            Point size = (Point)this.fileButtonMap.get(path).getData(DATA_SIZE);
            Image imageData = new Image((Device)this.getSite().getShell().getDisplay(), file.getAbsolutePath());
            Rectangle rectangle = imageData.getBounds();
            imageData.dispose();
            if (size.x != rectangle.width || size.y != rectangle.height) {
                String text = "\u5206\u8fa8\u7387\u4e0d\u7b26\u5408\u6807\u51c6\uff0c\u4e3a\u4e86\u4f7fApp\u6548\u679c\u66f4\u597d\uff0c\u5efa\u8bae\u66f4\u6362\u4e3a\u6b63\u786e\u5206\u8fa8\u7387\u7684\u56fe\u7247\u3002";
                if (!text.equals(controlDecoration.getDescriptionText())) {
                    controlDecoration.setDescriptionText(text);
                }
                if (!controlDecoration.isVisible()) {
                    controlDecoration.show();
                }
            } else if (controlDecoration.isVisible()) {
                controlDecoration.hide();
            }
        } else if (controlDecoration.isVisible()) {
            controlDecoration.hide();
        }
    }

    @Override
    public void fromModule(ManifastConfiguration appConfig) {
        if (appConfig.getPlus() == null) {
            appConfig.setPlus(new Plus());
        }
        if (appConfig.getPlus().getSplashscreen() == null) {
            appConfig.getPlus().setSplashscreen(new SplashScreenSetting());
        }
        int delay = 0;
        try {
            delay = Integer.parseInt(appConfig.getPlus().getSplashscreen().getDelay());
        }
        catch (NumberFormatException numberFormatException) {}
        if (appConfig.getPlus().getSplashscreen().getAutoclose()) {
            if (delay == 0) {
                this.autoCloseRadio.setSelection(true);
                this.delayCloseRadio.setSelection(false);
                this.manualCloseRadio.setSelection(false);
            } else {
                this.delayCloseRadio.setSelection(true);
                this.autoCloseRadio.setSelection(false);
                this.manualCloseRadio.setSelection(false);
            }
        } else {
            this.manualCloseRadio.setSelection(true);
            this.autoCloseRadio.setSelection(false);
            this.delayCloseRadio.setSelection(false);
        }
        this.delayText.setText(appConfig.getPlus().getSplashscreen().getDelay());
        this.delayText.setEnabled(this.delayCloseRadio.getSelection());
        this.waitingCheck.setSelection(appConfig.getPlus().getSplashscreen().isWaiting());
        boolean needCheckSize = false;
        if (this.fullscreen != appConfig.isFullscreen()) {
            needCheckSize = true;
            this.fullscreen = appConfig.isFullscreen();
            for (String path : this.sizeLabelMap.keySet()) {
                Label label = this.sizeLabelMap.get(path);
                String title = (String)label.getData(DATA_TITLE);
                Point size = (Point)(this.fullscreen ? label.getData(DATA_FULLSIZE) : label.getData(DATA_SIZE));
                label.setText(String.valueOf(title) + "\r\n" + size.x + "x" + size.y);
                this.fileButtonMap.get(path).setData(DATA_SIZE, (Object)size);
            }
        }
        for (String path : this.fileButtonMap.keySet()) {
            Object object;
            if (this.changeSplashFile(path, (String)(object = this.getFieldValue(appConfig, path.split("\\.")))) || !this.sizeLabelMap.containsKey(path) || !needCheckSize) continue;
            this.checkSize(path);
        }
    }

    @Override
    public void toModule(ManifastConfiguration appConfig) {
        if (appConfig.getPlus() == null) {
            appConfig.setPlus(new Plus());
        }
        if (appConfig.getPlus().getSplashscreen() == null) {
            appConfig.getPlus().setSplashscreen(new SplashScreenSetting());
        }
        appConfig.getPlus().getSplashscreen().setAutoclose(!this.manualCloseRadio.getSelection());
        appConfig.getPlus().getSplashscreen().setDelay(this.delayText.getText());
        appConfig.getPlus().getSplashscreen().setWaiting(this.waitingCheck.getSelection());
        for (String path : this.fileButtonMap.keySet()) {
            this.setFieldValue(appConfig, this.fileButtonMap.get(path).getData(DATA_FILE), path.split("\\."));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.viewImage.dispose();
    }
}

