/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.pages;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.model.permission.Permission;
import com.pandora.core.mobile.model.plugins.Plugins;
import com.pandora.core.mobile.verification.ManifastConfigurationVerification;
import com.pandora.editor.ui.EditorPlugin;
import com.pandora.editor.ui.editors.component.DetailedDialog;
import com.pandora.editor.ui.editors.pages.AbstractAppConfigPage;
import java.awt.Desktop;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ModulesAppConfigPage
extends AbstractAppConfigPage {
    private static final String DATA_WARN_TEXT = "DATA_WARN_TEXT";
    private static final String DATA_PATH = "DATA_PATH";
    private String SMS = "\u5e94\u7528\u7a0b\u5e8f\u5982\u5177\u6709\u77ed\u4fe1\u6743\u9650,\u63d0\u4ea4\u5e94\u7528\u5e02\u573a\u65f6\u9700\u8981\u7279\u6b8a\u7533\u8bf7,\u8be6\u60c5\u53c2\u89c1<a>\u77ed\u4fe1\u6743\u9650\u5bfc\u81f4\u5e94\u7528\u5e02\u573a\u5ba1\u6838\u65e0\u6cd5\u901a\u8fc7</a>";
    private Map<String, String> lastPermissionWarns = new HashMap<String, String>();
    private Color errorColor;
    private Color warnColor;
    private String moduleRootPath;
    private String permissionRootPath;
    private Hover hover;
    private Composite modluesComposite;
    private Composite notifyComposite;
    private Table allTable;
    private Table selectTable;
    private Button addAllButton;
    private Button addButton;
    private Button removeButton;
    private Button removeAllButton;
    private Combo selectPermissionsCombo;
    private Label permissionsWarnImageLabel;
    private Link permissionsWarnTextTextLabel;
    private Text filterPermissionsText;
    private TableViewer permissionsTable;

    public ModulesAppConfigPage(FormEditor editor, String id, String title, String titleLinkText, URL titleLinkUrl, JSONObject appPageConfig) {
        super(editor, id, title, titleLinkText, titleLinkUrl, appPageConfig);
        this.moduleRootPath = appPageConfig.optJSONObject("modules").optString("path");
        this.permissionRootPath = appPageConfig.optJSONObject("permissions").optString("path");
    }

    @Override
    protected void createPageContent(IManagedForm managedForm) {
        this.errorColor = this.getSite().getShell().getDisplay().getSystemColor(3);
        this.warnColor = new Color((Device)this.getSite().getShell().getDisplay(), 221, 171, 0);
        FormToolkit formToolkit = managedForm.getToolkit();
        ((GridLayout)this.bodyContent.getLayout()).numColumns = 2;
        ((GridLayout)this.bodyContent.getLayout()).horizontalSpacing = 40;
        this.createMoudleContent(formToolkit);
        this.createPermissonContent(formToolkit);
        this.bindErrorDecorations(formToolkit);
    }

    protected void createMoudleContent(FormToolkit formToolkit) {
        Composite moudleGroup = this.createGroup("\u6a21\u5757\u8bbe\u7f6e", formToolkit);
        this.modluesComposite = formToolkit.createComposite(moudleGroup, 0);
        this.modluesComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.modluesComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(20, 0, 0, 0).create());
        formToolkit.createLabel(this.modluesComposite, "\u6ce8\uff1a\r\n* \u53bb\u6389\u4e0d\u9700\u8981\u6a21\u5757\uff0c\u53ef\u4ee5\u51cf\u5c11\u539f\u751f\u5b89\u88c5\u5305\u7684\u4f53\u79ef\u3002\r\n", 1).setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
        this.modluesComposite.setVisible(true);
        this.notifyComposite = formToolkit.createComposite(moudleGroup, 0);
        this.notifyComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.notifyComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(20, 0, 0, 0).create());
        formToolkit.createLabel(this.notifyComposite, "* Native.js\u4ee3\u7801\u6d89\u53ca\u7684Android\u6743\u9650\u548ciOS\u7684Framwork\u9700\u8981\u81ea\u5df1\u9009\u62e9", 1).setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
        this.notifyComposite.setVisible(false);
        Composite moudleComposite = formToolkit.createComposite(moudleGroup, 0);
        moudleComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        moudleComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(20, 20, 10, 20).numColumns(3).create());
        formToolkit.createLabel(moudleComposite, "\u672a\u9009\u6a21\u5757", 0x1000000).setLayoutData((Object)GridDataFactory.fillDefaults().create());
        formToolkit.createLabel(moudleComposite, null, 0x1000000).setLayoutData((Object)GridDataFactory.fillDefaults().create());
        formToolkit.createLabel(moudleComposite, "\u5df2\u9009\u6a21\u5757", 0x1000000).setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.allTable = formToolkit.createTable(moudleComposite, 65538);
        this.allTable.setLayoutData((Object)GridDataFactory.fillDefaults().hint(200, 500).create());
        new TableColumn(this.allTable, 16384);
        Composite buttonsComposite = formToolkit.createComposite(moudleComposite, 0);
        buttonsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        buttonsComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 100).spacing(0, 30).create());
        GridDataFactory buttonGridDataFactory = GridDataFactory.fillDefaults().align(4, 0x1000000);
        this.addAllButton = formToolkit.createButton(buttonsComposite, "\u5168\u90e8\u6dfb\u52a0>>", 0);
        this.addAllButton.setLayoutData((Object)buttonGridDataFactory.create());
        this.addButton = formToolkit.createButton(buttonsComposite, "\u6dfb\u52a0  >>", 0);
        this.addButton.setLayoutData((Object)buttonGridDataFactory.create());
        this.removeButton = formToolkit.createButton(buttonsComposite, "<< \u5220\u9664", 0);
        this.removeButton.setLayoutData((Object)buttonGridDataFactory.create());
        this.removeAllButton = formToolkit.createButton(buttonsComposite, "<<\u5168\u90e8\u5220\u9664", 0);
        this.removeAllButton.setLayoutData((Object)buttonGridDataFactory.create());
        this.selectTable = formToolkit.createTable(moudleComposite, 65538);
        this.selectTable.setLayoutData((Object)GridDataFactory.copyData((GridData)((GridData)this.allTable.getLayoutData())));
        new TableColumn(this.selectTable, 16384);
        this.hover = new Hover(this.getSite().getShell());
    }

    private void createPermissonContent(FormToolkit formToolkit) {
        Composite permissonGroup = this.createGroup("Android\u6743\u9650\u8bbe\u7f6e", formToolkit);
        Composite composite = formToolkit.createComposite(permissonGroup, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(20, 20, 15, 20).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(-1, 500).create());
        Composite textComposite = formToolkit.createComposite(composite, 0);
        textComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).spacing(5, 0).create());
        textComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.selectPermissionsCombo = new Combo(textComposite, 12);
        formToolkit.adapt((Composite)this.selectPermissionsCombo);
        this.selectPermissionsCombo.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 4).grab(false, false).create());
        this.selectPermissionsCombo.setItems(new String[]{"\u5168\u90e8\u6743\u9650", "\u5df2\u9009\u62e9\u7684\u6743\u9650", "\u672a\u9009\u62e9\u7684\u6743\u9650", "\u7f3a\u5c11\u7684\u5fc5\u8981\u6743\u9650"});
        this.selectPermissionsCombo.select(0);
        this.permissionsWarnImageLabel = formToolkit.createLabel(textComposite, null, 16384);
        this.permissionsWarnImageLabel.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 0x1000000).create());
        this.permissionsWarnTextTextLabel = new Link(textComposite, 0);
        this.permissionsWarnTextTextLabel.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 0x1000000).grab(true, false).create());
        this.filterPermissionsText = new Text(composite, 2436);
        this.filterPermissionsText.setMessage("\u8f93\u5165\u8fc7\u6ee4\u6587\u5b57");
        this.filterPermissionsText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.permissionsTable = new TableViewer(composite, 67620);
        this.permissionsTable.getTable().setHeaderVisible(true);
        this.permissionsTable.getTable().setLinesVisible(true);
        new TableColumn(this.permissionsTable.getTable(), 16384).setText("\u6743\u9650");
        new TableColumn(this.permissionsTable.getTable(), 16384).setText("\u6743\u9650\u8bf4\u660e");
        this.permissionsTable.setContentProvider((IContentProvider)new PermissionContentProvider());
        this.permissionsTable.setLabelProvider((IBaseLabelProvider)new PermissionLabelProvider());
        this.permissionsTable.getTable().getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModulesAppConfigPage.this.permissionsTable.getTable().redraw();
            }
        });
        try {
            JSONArray permissionList = this.appPageConfig.optJSONObject("permissions").optJSONArray("list");
            Collections.sort(permissionList, new Comparator<JSONObject>(){

                @Override
                public int compare(JSONObject o1, JSONObject o2) {
                    return o1.optString("name").compareTo(o2.optString("name"));
                }
            });
            this.permissionsTable.setInput((Object)this.appPageConfig.optJSONObject("permissions").optJSONArray("list"));
            this.permissionsTable.getTable().getColumns()[0].pack();
            this.permissionsTable.getTable().getColumns()[1].pack();
            int width = this.permissionsTable.getTable().getColumns()[0].getWidth() + this.permissionsTable.getTable().getColumns()[1].getWidth();
            this.permissionsTable.getTable().setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).hint(width, -1).create());
        }
        catch (JSONException e) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
        }
    }

    private Set<String> getManifestConfigurationPermissions() {
        if (this.getManifestConfiguration().getPlus() != null && this.getManifestConfiguration().getPlus().getDistribute() != null && this.getManifestConfiguration().getPlus().getDistribute().getGoogle() != null) {
            return this.getManifestConfiguration().getPlus().getDistribute().getGoogle().getPermissions();
        }
        return null;
    }

    private void bindErrorDecorations(FormToolkit formToolkit) {
        this.permissionsWarnTextTextLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Desktop desk = Desktop.getDesktop();
                    desk.browse(URI.create("http://ask.dcloud.net.cn/article/245"));
                }
                catch (Throwable ex) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                }
            }
        });
        MouseTrackAdapter mouseTrackListener = new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Point pt;
                Table table = (Table)event.getSource();
                TableItem item = table.getItem(pt = new Point(event.x, event.y));
                if (item != null) {
                    String msg = (String)item.getData(ModulesAppConfigPage.DATA_WARN_TEXT);
                    if (StringUtil.isNotBlank((String)msg)) {
                        Rectangle rect = item.getBounds();
                        ModulesAppConfigPage.this.hover.setText(msg, table.toDisplay(new Point(rect.x, rect.y)));
                        ModulesAppConfigPage.this.hover.setVisible(true);
                    } else {
                        ModulesAppConfigPage.this.hover.setVisible(false);
                    }
                    return;
                }
                ModulesAppConfigPage.this.hover.setVisible(false);
            }

            public void mouseExit(MouseEvent e) {
                ModulesAppConfigPage.this.hover.setVisible(false);
            }
        };
        this.allTable.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        this.selectTable.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        this.permissionsTable.getTable().addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        MouseAdapter mouse = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                boolean add = e.widget == ModulesAppConfigPage.this.allTable;
                Table table = (Table)e.widget;
                table.setSelection(table.getItem(new Point(e.x, e.y)));
                ModulesAppConfigPage.this.selectModule(add, false);
            }
        };
        this.allTable.addMouseListener((MouseListener)mouse);
        this.selectTable.addMouseListener((MouseListener)mouse);
        KeyAdapter key = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasCommand;
                boolean isDel = e.character == '\u007f';
                boolean bl = hasCommand = e.stateMask != 0;
                if (isDel && !hasCommand) {
                    boolean add = e.widget == ModulesAppConfigPage.this.allTable;
                    ModulesAppConfigPage.this.selectModule(add, false);
                }
            }
        };
        this.allTable.addKeyListener((KeyListener)key);
        this.selectTable.addKeyListener((KeyListener)key);
        this.selectPermissionsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModulesAppConfigPage.this.permissionsTable.refresh();
                ModulesAppConfigPage.this.refreashPermissionsTable();
            }
        });
        this.filterPermissionsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModulesAppConfigPage.this.refreashPermissionsTable();
            }
        });
        SelectionAdapter selectListner = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean add = e.widget == ModulesAppConfigPage.this.addAllButton || e.widget == ModulesAppConfigPage.this.addButton;
                boolean all = e.widget == ModulesAppConfigPage.this.addAllButton || e.widget == ModulesAppConfigPage.this.removeAllButton;
                ModulesAppConfigPage.this.selectModule(add, all);
            }
        };
        this.addAllButton.addSelectionListener((SelectionListener)selectListner);
        this.addButton.addSelectionListener((SelectionListener)selectListner);
        this.removeAllButton.addSelectionListener((SelectionListener)selectListner);
        this.removeButton.addSelectionListener((SelectionListener)selectListner);
        this.permissionsTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    TableItem item = (TableItem)e.item;
                    Set permissions = (Set)ModulesAppConfigPage.this.newInstanceField(ModulesAppConfigPage.this.getManifestConfiguration(), ModulesAppConfigPage.this.permissionRootPath.split("\\."));
                    JSONObject jsonObject = (JSONObject)item.getData();
                    String permission = jsonObject.optString("permission");
                    if (item.getChecked()) {
                        permissions.add(permission);
                    } else {
                        permissions.remove(permission);
                    }
                    ModulesAppConfigPage.this.recordChangeAndVilidation(Arrays.asList(ModulesAppConfigPage.this.permissionRootPath));
                }
            }
        });
    }

    private void selectModule(boolean add, boolean all) {
        Table srcTable = null;
        Table dstTable = null;
        if (add) {
            srcTable = this.allTable;
            dstTable = this.selectTable;
        } else {
            srcTable = this.selectTable;
            dstTable = this.allTable;
        }
        TableItem[] items = null;
        items = all ? srcTable.getItems() : srcTable.getSelection();
        ArrayList<String> paths = new ArrayList<String>();
        if (items != null && items.length > 0) {
            dstTable.deselectAll();
            TableItem[] addItems = new TableItem[items.length];
            int i = 0;
            while (i < items.length) {
                TableItem srcItem = items[i];
                int index = this.getSort(dstTable, srcItem.getText());
                TableItem addItem = new TableItem(dstTable, 0, index);
                addItem.setText(srcItem.getText());
                addItem.setData(DATA_PATH, srcItem.getData(DATA_PATH));
                addItems[i] = srcItem;
                dstTable.select(index);
                if (srcItem.getText().toLowerCase().contains("native.js")) {
                    this.notifyComposite.setVisible(dstTable == this.selectTable);
                }
                paths.add(String.valueOf(this.moduleRootPath) + "." + srcItem.getData(DATA_PATH));
                ++i;
            }
            String[] modules = new String[addItems.length];
            int i2 = 0;
            while (i2 < addItems.length) {
                TableItem tableItem = addItems[i2];
                modules[i2] = (String)tableItem.getData(DATA_PATH);
                ++i2;
            }
            if (all) {
                srcTable.removeAll();
            } else {
                srcTable.remove(srcTable.getSelectionIndices());
            }
            boolean result = false;
            result = srcTable == this.allTable ? this.addModuleAndPermissions(modules) : this.removeModuleAndPermissions(true, modules);
            this.recordChangeAndVilidation(paths);
            if (result && this.permissionsTable != null && !this.permissionsTable.getTable().isDisposed()) {
                this.refreashPermissionsTable();
            }
        }
    }

    private int getSort(Table table, String text) {
        TableItem[] items = table.getItems();
        Collator collator = Collator.getInstance();
        int i = 0;
        while (i < items.length) {
            if (collator.compare(text, items[i].getText()) <= 0) {
                return i;
            }
            ++i;
        }
        return items.length;
    }

    private void refreashPermissionsTable() {
        this.permissionsTable.refresh();
        this.setPermissionsTableCheck();
        this.showPermissionsTableWarn(this.lastPermissionWarns, this.permissionsTable.getTable());
    }

    private void setPermissionsTableCheck() {
        TableItem[] items;
        Set<String> permissions = this.getManifestConfigurationPermissions();
        TableItem[] tableItemArray = items = this.permissionsTable.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (permissions.contains(((JSONObject)item.getData()).optString("permission"))) {
                item.setChecked(true);
            } else if (item.getChecked()) {
                item.setChecked(false);
            }
            ++n2;
        }
    }

    @Override
    public void fromModule(ManifastConfiguration manifastConfiguration) {
        try {
            this.allTable.removeAll();
            this.selectTable.removeAll();
            JSONArray listJsonArray = this.appPageConfig.optJSONObject("modules").optJSONArray("list");
            int i = 0;
            while (i < listJsonArray.size()) {
                try {
                    Object value;
                    JSONObject listJsonObject = listJsonArray.getJSONObject(i);
                    String title = listJsonObject.optString("desc");
                    String listPath = listJsonObject.optString("path");
                    Table table = this.allTable;
                    if (manifastConfiguration.getPermissions() != null && (value = this.getFieldValue(manifastConfiguration.getPermissions(), listPath.toLowerCase())) != null) {
                        table = this.selectTable;
                    }
                    TableItem item = new TableItem(table, 0);
                    item.setText(String.valueOf(title));
                    item.setData(DATA_PATH, (Object)listPath);
                    if (item.getText().toLowerCase().contains("native.js")) {
                        this.notifyComposite.setVisible(table == this.selectTable);
                    }
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                }
                ++i;
            }
            this.allTable.getColumn(0).setWidth(this.allTable.getSize().x - 4);
            this.allTable.setSortColumn(this.allTable.getColumn(0));
            this.selectTable.getColumn(0).setWidth(this.selectTable.getSize().x - 4);
            this.selectTable.setSortColumn(this.selectTable.getColumn(0));
            this.setPermissionsTableCheck();
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
        }
    }

    @Override
    public void toModule(ManifastConfiguration manifastConfiguration) {
    }

    @Override
    protected boolean showErrorInfo(Map<String, String> infos) {
        boolean result = this.showModuleTableErrors(infos, this.allTable);
        result = this.showModuleTableErrors(infos, this.selectTable) || result;
        this.lastPermissionWarns = ManifastConfigurationVerification.verifyPermission((ManifastConfiguration)this.getManifestConfiguration(), (IProject)this.getEditor().getProject(), (ManifastConfigurationVerification.VerificationPlatform)ManifastConfigurationVerification.VerificationPlatform.ALL);
        this.showPermissionsTableWarn(this.lastPermissionWarns, this.permissionsTable.getTable());
        return result;
    }

    private boolean showModuleTableErrors(Map<String, String> infos, Table table) {
        TableItem[] items = table.getItems();
        boolean result = false;
        if (items.length > 0) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                String path = "manifest." + this.moduleRootPath + "." + tableItem.getData(DATA_PATH);
                if (infos.containsKey(path)) {
                    result = true;
                    tableItem.setImage(this.errorImage);
                    tableItem.setForeground(this.errorColor);
                    tableItem.setData(DATA_WARN_TEXT, (Object)infos.get(path));
                } else if (tableItem.getImage(0) != null) {
                    tableItem.setImage(0, null);
                    tableItem.setForeground(null);
                    tableItem.setData(DATA_WARN_TEXT, null);
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean showPermissionsTableWarn(Map<String, String> infos, Table table) {
        TableItem[] items = table.getItems();
        if (items.length > 0) {
            TableItem first = null;
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                JSONObject JsonObject = (JSONObject)tableItem.getData();
                String path = "manifest." + this.permissionRootPath + "." + JsonObject.optString("permission");
                if (infos.containsKey(path)) {
                    tableItem.setForeground(this.warnColor);
                    tableItem.setText(String.valueOf(JsonObject.optString("name")) + " (" + infos.get(path) + ")");
                    tableItem.setData(DATA_WARN_TEXT, (Object)infos.get(path));
                    if (first == null) {
                        first = tableItem;
                    }
                } else if (tableItem.getData(DATA_WARN_TEXT) != null) {
                    tableItem.setForeground(null);
                    tableItem.setData(DATA_WARN_TEXT, null);
                    tableItem.setText(JsonObject.optString("name"));
                }
                ++n2;
            }
            for (String error : infos.values()) {
                TableItem[] selectModuleItems;
                TableItem[] tableItemArray2 = selectModuleItems = this.selectTable.getItems();
                int n3 = selectModuleItems.length;
                int n4 = 0;
                while (n4 < n3) {
                    TableItem tableItem = tableItemArray2[n4];
                    if (tableItem.getImage(0) == null && error.contains(tableItem.getText())) {
                        tableItem.setImage(this.warnImage);
                        tableItem.setForeground(this.warnColor);
                        tableItem.setData(DATA_WARN_TEXT, (Object)"\u6b64\u6a21\u5757\u53ef\u80fd\u7f3a\u5c11Android\u5e73\u53f0\u4e0b\u9700\u8981\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5Android\u6743\u9650\u8bbe\u7f6e\u4e2d\u9ec4\u8272\u6761\u76ee\u662f\u5426\u5df2\u6b63\u786e\u914d\u7f6e\uff01");
                    }
                    ++n4;
                }
            }
        }
        if (!infos.isEmpty() && this.permissionsWarnImageLabel.getImage() != this.warnImage) {
            this.permissionsWarnImageLabel.setImage(this.warnImage);
            this.permissionsWarnTextTextLabel.setText("\u8bf7\u6838\u5bf9\u5df2\u9009\u6a21\u5757\u5217\u8868\u4e2d\u9ec4\u8272\u6761\u76ee\u662f\u5426\u7f3a\u5c11Android\u6743\u9650\u8bbe\u7f6e\u4e2d\u9ec4\u8272\u6761\u76ee\u7684\u6743\u9650\u3002");
            this.permissionsWarnTextTextLabel.setForeground(this.warnColor);
            this.permissionsWarnTextTextLabel.getParent().layout();
        } else if (infos.isEmpty() && this.permissionsWarnImageLabel.getImage() != this.infoImage) {
            this.permissionsWarnImageLabel.setImage(this.infoImage);
            this.permissionsWarnTextTextLabel.setText(this.SMS);
            this.permissionsWarnTextTextLabel.setForeground(null);
            this.permissionsWarnTextTextLabel.getParent().layout();
        }
        return !infos.isEmpty();
    }

    public boolean addModuleAndPermissions(String ... moduleNames) {
        boolean result = false;
        try {
            ManifastConfiguration manifast = this.getManifestConfiguration();
            if (manifast.getPermissions() == null) {
                manifast.setPermissions(new Permission());
            }
            String[] stringArray = moduleNames;
            int n = moduleNames.length;
            int n2 = 0;
            while (n2 < n) {
                String moduleName = stringArray[n2];
                if (this.getFieldValue(manifast.getPermissions(), moduleName) == null) {
                    this.newInstanceField(manifast.getPermissions(), moduleName);
                    this.getEditor().getChangedPaths().add(String.valueOf(this.moduleRootPath) + "." + moduleName);
                    result = true;
                }
                ++n2;
            }
            boolean changePermissions = false;
            String[] stringArray2 = moduleNames;
            int n3 = moduleNames.length;
            n = 0;
            while (n < n3) {
                String moduleName = stringArray2[n];
                List<String> requiredPermissions = this.getModuleRequiredPermissions(manifast, moduleName, true);
                if (requiredPermissions != null && !requiredPermissions.isEmpty()) {
                    HashSet permissions = (HashSet)this.newInstanceField(manifast, this.permissionRootPath.split("\\."));
                    for (String requiredPermission : requiredPermissions) {
                        boolean add = permissions.add(requiredPermission);
                        boolean bl = changePermissions = changePermissions || add;
                    }
                }
                ++n;
            }
            if (changePermissions) {
                this.getEditor().getChangedPaths().add(this.permissionRootPath);
            }
            result = result || changePermissions;
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
        }
        return result;
    }

    public boolean removeModuleAndPermissions(String ... moduleName) {
        return this.removeModuleAndPermissions(false, moduleName);
    }

    public boolean removeModuleAndPermissions(boolean ask, String ... moduleNames) {
        boolean result = false;
        try {
            if (moduleNames == null || moduleNames.length == 0) {
                return result;
            }
            ManifastConfiguration manifast = this.getManifestConfiguration();
            if (manifast.getPermissions() == null) {
                manifast.setPermissions(new Permission());
            }
            ArrayList<String> modifyList = new ArrayList<String>();
            String[] stringArray = moduleNames;
            int n = moduleNames.length;
            int n2 = 0;
            while (n2 < n) {
                String moduleName = stringArray[n2];
                if (this.getFieldValue(manifast.getPermissions(), moduleName) != null) {
                    modifyList.add(moduleName);
                    this.setFieldValue(manifast.getPermissions(), null, moduleName);
                    this.getEditor().getChangedPaths().add(String.valueOf(this.moduleRootPath) + "." + moduleName);
                    result = true;
                }
                ++n2;
            }
            HashSet permissions = (HashSet)this.newInstanceField(manifast, this.permissionRootPath.split("\\."));
            HashSet<String> needRemovePermission = new HashSet<String>();
            if (permissions != null && !permissions.isEmpty()) {
                String[] stringArray2 = moduleNames;
                int n3 = moduleNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    String moduleName = stringArray2[n4];
                    needRemovePermission.addAll(this.getModuleRequiredPermissions(manifast, moduleName, false));
                    ++n4;
                }
            }
            if (!needRemovePermission.isEmpty()) {
                if (ask) {
                    MultiStatus status = new MultiStatus("com.pandora.editor.ui", 0, "\u662f\u5426\u540c\u65f6\u53bb\u9664\u6a21\u5757\u6240\u4f7f\u7528\u7684Android\u6743\u9650\u8bbe\u7f6e\uff1f\r\n\u70b9\u51fb\u8be6\u7ec6\u4fe1\u606f\u4e86\u89e3\u5c06\u53bb\u9664\u7684Android\u6743\u9650\u5217\u8868\u3002", null);
                    for (String permission : needRemovePermission) {
                        status.add((IStatus)new Status(1, "com.pandora.editor.ui", "\u6743\u9650\uff1a" + permission));
                    }
                    if (DetailedDialog.openConfirm(this.getSite().getShell(), "\u63d0\u9192", null, (IStatus)status) != 0) {
                        return result;
                    }
                }
                if (permissions.removeAll(needRemovePermission)) {
                    this.getEditor().getChangedPaths().add("plus.distribute.google.permissions");
                    result = true;
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
        }
        return result;
    }

    private Map<String, Map<String[], List<String>>> getModuleAndPermissionsMap() {
        return ManifastConfigurationVerification.getModuleAndPermissionsMap((JSONObject)this.appPageConfig);
    }

    public boolean isModuleExists(ManifastConfiguration manifast, String moduleName) {
        return manifast.getPermissions() != null && this.getFieldValue(manifast.getPermissions(), moduleName) != null;
    }

    public List<String> getModuleRequiredPermissions(ManifastConfiguration manifast, String moduleName, boolean forAddModule) {
        Plugins plugins = null;
        Set nowPermissions = null;
        Permission nowModules = manifast.getPermissions();
        if (manifast.getPlus() != null && manifast.getPlus().getDistribute() != null) {
            plugins = manifast.getPlus().getDistribute().getPlugins();
            if (manifast.getPlus().getDistribute().getGoogle() != null) {
                nowPermissions = manifast.getPlus().getDistribute().getGoogle().getPermissions();
            }
        }
        List<String> requiredDefaultPermissions = this.getModuleRequiredDefaultPermissions(plugins, moduleName, forAddModule);
        if (nowPermissions == null) {
            if (forAddModule) {
                return requiredDefaultPermissions;
            }
            return new ArrayList<String>();
        }
        ArrayList<String> needPermissions = new ArrayList<String>();
        if (requiredDefaultPermissions != null && !requiredDefaultPermissions.isEmpty()) {
            block0: for (String requiredDefaultPermission : requiredDefaultPermissions) {
                boolean contains = nowPermissions.contains(requiredDefaultPermission);
                if ((!forAddModule || contains) && (forAddModule || !contains)) continue;
                if (nowModules != null && !forAddModule) {
                    for (String key : this.getModuleAndPermissionsMap().keySet()) {
                        List<String> otherRequiredPermissions;
                        if (!moduleName.equals(key) && this.getFieldValue(nowModules, key.toLowerCase()) != null && (otherRequiredPermissions = this.getModuleRequiredDefaultPermissions(plugins, key, forAddModule)) != null && otherRequiredPermissions.contains(requiredDefaultPermission)) continue block0;
                    }
                }
                needPermissions.add(requiredDefaultPermission);
            }
        }
        return needPermissions;
    }

    private List<String> getModuleRequiredDefaultPermissions(Plugins plugins, String moduleName, boolean checkPlugin) {
        ArrayList<String> result = new ArrayList<String>();
        Map<String[], List<String>> permissionsMap = this.getModuleAndPermissionsMap().get(moduleName);
        if (permissionsMap != null && !permissionsMap.isEmpty()) {
            for (String[] pluginPaths : permissionsMap.keySet()) {
                if (pluginPaths.length == 0) {
                    result.addAll((Collection<String>)permissionsMap.get(pluginPaths));
                    continue;
                }
                if (pluginPaths.length <= 0 || checkPlugin && plugins == null || checkPlugin && this.getFieldValue(plugins, pluginPaths) == null) continue;
                result.addAll((Collection<String>)permissionsMap.get(pluginPaths));
            }
        }
        return result;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.warnColor != null) {
            this.warnColor.dispose();
        }
    }

    class Hover {
        private static final String EMPTY = "";
        private int hao = 10;
        private int haw = 8;
        private int hah = 10;
        private int hm = 2;
        Shell hoverShell;
        String text = "";
        Region region;
        boolean arrowOnLeft = true;

        Hover(Shell parent) {
            Display display = parent.getDisplay();
            this.hoverShell = new Shell(parent, 540684);
            this.hoverShell.setBackground(display.getSystemColor(29));
            this.hoverShell.setForeground(display.getSystemColor(28));
            this.hoverShell.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent pe) {
                    pe.gc.drawText(Hover.this.text, Hover.this.hm, Hover.this.hm);
                    if (!PlatformUtil.isMac()) {
                        pe.gc.drawPolygon(Hover.this.getPolygon(true));
                    }
                }
            });
            this.hoverShell.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    Hover.this.setVisible(false);
                }
            });
        }

        int[] getPolygon(boolean border) {
            int b;
            Point e = this.getExtent();
            int n = b = border ? 1 : 0;
            if (this.arrowOnLeft) {
                int[] nArray = new int[16];
                nArray[2] = e.x - b;
                nArray[4] = e.x - b;
                nArray[5] = e.y - b;
                nArray[6] = this.hao + this.haw;
                nArray[7] = e.y - b;
                nArray[8] = this.hao + this.haw / 2;
                nArray[9] = e.y + this.hah - b;
                nArray[10] = this.hao;
                nArray[11] = e.y - b;
                nArray[13] = e.y - b;
                return nArray;
            }
            int[] nArray = new int[16];
            nArray[2] = e.x - b;
            nArray[4] = e.x - b;
            nArray[5] = e.y - b;
            nArray[6] = e.x - this.hao - b;
            nArray[7] = e.y - b;
            nArray[8] = e.x - this.hao - this.haw / 2;
            nArray[9] = e.y + this.hah - b;
            nArray[10] = e.x - this.hao - this.haw;
            nArray[11] = e.y - b;
            nArray[13] = e.y - b;
            return nArray;
        }

        void dispose() {
            if (!this.hoverShell.isDisposed()) {
                this.hoverShell.dispose();
            }
            if (this.region != null) {
                this.region.dispose();
            }
        }

        void setVisible(boolean visible) {
            if (visible) {
                if (!this.hoverShell.isVisible()) {
                    this.hoverShell.setVisible(true);
                }
            } else if (this.hoverShell.isVisible()) {
                this.hoverShell.setVisible(false);
            }
        }

        void setText(String t, Point point) {
            if (t == null) {
                t = EMPTY;
            }
            if (!t.equals(this.text)) {
                Point oldSize = this.getExtent();
                this.text = t;
                this.hoverShell.redraw();
                Point newSize = this.getExtent();
                if (!oldSize.equals((Object)newSize)) {
                    this.setNewShape();
                }
            }
            Point extent = this.getExtent();
            int y = -extent.y - this.hah + 1;
            int x = this.arrowOnLeft ? -this.hao + this.haw / 2 : -extent.x + this.hao + this.haw / 2;
            this.hoverShell.setLocation(point.x + x, point.y + y);
        }

        boolean isVisible() {
            return this.hoverShell.isVisible();
        }

        Point getExtent() {
            GC gc = new GC((Drawable)this.hoverShell);
            Point e = gc.textExtent(this.text);
            gc.dispose();
            e.x += this.hm * 2;
            e.y += this.hm * 2;
            return e;
        }

        void setNewShape() {
            Region oldRegion = this.region;
            this.region = new Region();
            this.region.add(this.getPolygon(false));
            this.hoverShell.setRegion(this.region);
            if (oldRegion != null) {
                oldRegion.dispose();
            }
        }
    }

    private class PermissionContentProvider
    extends ArrayContentProvider {
        private PermissionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)inputElement;
                int comboIndex = ModulesAppConfigPage.this.selectPermissionsCombo.getSelectionIndex();
                String filterText = ModulesAppConfigPage.this.filterPermissionsText.getText();
                Pattern p = null;
                if (StringUtil.isNotBlank((String)filterText)) {
                    p = Pattern.compile(".*" + filterText + ".*");
                }
                if (comboIndex != 0 || p != null) {
                    Set manifestConfigurationPermissions = ModulesAppConfigPage.this.getManifestConfigurationPermissions();
                    if ((manifestConfigurationPermissions == null || manifestConfigurationPermissions.isEmpty()) && comboIndex == 1) {
                        return new Object[0];
                    }
                    ArrayList<JSONObject> list = new ArrayList<JSONObject>();
                    for (Object object : jsonArray) {
                        boolean add = true;
                        JSONObject jsonObject = (JSONObject)object;
                        String permission = jsonObject.optString("permission");
                        if (manifestConfigurationPermissions.contains(permission)) {
                            if (comboIndex == 2 || comboIndex == 3) {
                                add = false;
                            }
                        } else if (comboIndex == 1) {
                            add = false;
                        } else if (comboIndex == 3 && ModulesAppConfigPage.this.lastPermissionWarns != null && !ModulesAppConfigPage.this.lastPermissionWarns.containsKey("manifest." + ModulesAppConfigPage.this.permissionRootPath + "." + permission)) {
                            add = false;
                        }
                        if (!add) continue;
                        if (p != null) {
                            add = p.matcher(String.valueOf(jsonObject.optString("name")) + jsonObject.optString("desc")).find();
                        }
                        if (!add) continue;
                        list.add(jsonObject);
                    }
                    return list.toArray();
                }
                return jsonArray.toArray();
            }
            return new Object[0];
        }
    }

    private class PermissionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PermissionLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof JSONObject) {
                if (columnIndex == 0) {
                    return ((JSONObject)element).optString("name");
                }
                if (columnIndex == 1) {
                    return ((JSONObject)element).optString("desc");
                }
            }
            return null;
        }
    }
}

