/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.pages;

import com.aptana.core.logging.IdeLog;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.verification.ManifastConfigurationVerification;
import com.pandora.core.utils.ReflectUtils;
import com.pandora.core.utils.StringUtil;
import com.pandora.editor.ui.EditorPlugin;
import com.pandora.editor.ui.editors.AppConfigEditor;
import com.pandora.editor.ui.editors.component.ErrorDecoration;
import com.pandora.editor.ui.editors.component.ImageSelectWidget;
import com.pandora.ui.widget.PrettyToggleButton;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class AbstractAppConfigPage
extends FormPage {
    protected AppConfigEditor appConfigEditor;
    protected ScrolledForm form;
    protected int pageIndex;
    protected JSONObject appPageConfig;
    private Map<String, ControlDecoration> validationErrorDecorations = new LinkedHashMap<String, ControlDecoration>();
    protected Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    protected Image warnImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
    protected Image infoImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
    private boolean modelInited = false;
    private String titleLinkText;
    private URL titleLinkUrl;
    private Composite pageContent;
    private Composite titleContent;
    protected Composite bodyContent;
    protected Color realTimeColor;
    private Label titleLabel;
    private Hyperlink titleLink;
    protected Font boldFont;

    public AbstractAppConfigPage(FormEditor editor, String id, String title, JSONObject appPageConfig) {
        this(editor, id, title, null, null, appPageConfig);
    }

    public AbstractAppConfigPage(FormEditor editor, String id, String title, String titleLinkText, URL titleLinkUrl, JSONObject appPageConfig) {
        super(editor, id, title);
        this.appConfigEditor = (AppConfigEditor)editor;
        this.titleLinkText = titleLinkText;
        this.titleLinkUrl = titleLinkUrl;
        this.appPageConfig = appPageConfig;
    }

    public abstract void fromModule(ManifastConfiguration var1);

    public abstract void toModule(ManifastConfiguration var1);

    public void validation(Map<String, String> infos, boolean forceFocusError) {
        if (infos == null) {
            infos = ManifastConfigurationVerification.verify((ManifastConfiguration)this.appConfigEditor.getManifestConfiguration(), (IProject)this.appConfigEditor.getProject(), (ManifastConfigurationVerification.VerificationPlatform)ManifastConfigurationVerification.VerificationPlatform.ALL, (boolean)true);
            infos.remove("iconsplashchanged");
        }
        boolean hasSetFocus = false;
        for (String path : this.validationErrorDecorations.keySet()) {
            ControlDecoration controlDecoration = this.validationErrorDecorations.get(path);
            if (infos.containsKey(path)) {
                String desc;
                String string = desc = infos.get(path) == null ? "\u4e0d\u80fd\u4e3a\u7a7a" : (String)infos.get(path);
                if (!desc.equals(controlDecoration.getDescriptionText())) {
                    controlDecoration.setDescriptionText(desc);
                }
                if (!controlDecoration.isVisible()) {
                    controlDecoration.show();
                }
                if (!forceFocusError) continue;
                Control control = controlDecoration.getControl();
                if (hasSetFocus || !(control instanceof Text)) continue;
                hasSetFocus = control.forceFocus();
                continue;
            }
            if (!controlDecoration.isVisible() || controlDecoration.getImage() != this.errorImage) continue;
            controlDecoration.hide();
        }
        this.showErrorInfo(infos);
        this.getEditor().showAllPagesError(infos);
    }

    protected boolean showErrorInfo(Map<String, String> infos) {
        return false;
    }

    protected ControlDecoration bindErrorValidation(Control show, String path, int position, FormToolkit formToolkit, Control ... sourceToLinsten) {
        return this.bindErrorValidation(show, this.bodyContent, Arrays.asList(path), position, formToolkit, sourceToLinsten);
    }

    protected ControlDecoration bindErrorValidation(Control show, Composite range, List<String> paths, int errorPosition, FormToolkit formToolkit, Control ... sourceToLinsten) {
        ControlDecoration decoration = null;
        if (show != null) {
            decoration = this.createControlDecoration(show, show.getParent(), errorPosition, this.errorImage);
        }
        final ArrayList<String> newPaths = new ArrayList<String>();
        for (String path : paths) {
            if (!path.startsWith("manifest.")) {
                path = "manifest." + path;
            }
            newPaths.add(path);
            if (decoration == null) continue;
            this.validationErrorDecorations.put(path, decoration);
        }
        if (sourceToLinsten != null && sourceToLinsten.length > 0) {
            Control[] controlArray = sourceToLinsten;
            int n = sourceToLinsten.length;
            int n2 = 0;
            while (n2 < n) {
                Control source = controlArray[n2];
                if (source instanceof Text) {
                    ((Text)source).addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            AbstractAppConfigPage.this.recordChangeAndVilidation(newPaths);
                        }
                    });
                } else if (source instanceof Button) {
                    ((Button)source).addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (e.doit) {
                                AbstractAppConfigPage.this.recordChangeAndVilidation(newPaths);
                            }
                        }
                    });
                } else if (source instanceof PrettyToggleButton) {
                    ((PrettyToggleButton)source).addSelectListener(new PrettyToggleButton.ISelectListener(){

                        public void select(PrettyToggleButton toggleButton, boolean userClick) {
                            if (userClick) {
                                AbstractAppConfigPage.this.recordChangeAndVilidation(newPaths);
                            }
                        }
                    });
                } else if (source instanceof ImageSelectWidget) {
                    ((ImageSelectWidget)source).addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            AbstractAppConfigPage.this.recordChangeAndVilidation(newPaths);
                        }
                    });
                }
                ++n2;
            }
        }
        return decoration;
    }

    protected ControlDecoration createControlDecoration(Control showControl, Composite composite, int errorPosition, Image image) {
        ErrorDecoration decoration = null;
        decoration = new ErrorDecoration(showControl, errorPosition, this.bodyContent, false);
        decoration.setImage(image);
        decoration.setMarginWidth(2);
        decoration.setInited(true);
        decoration.hide();
        return decoration;
    }

    protected void recordChangeAndVilidation(List<String> paths) {
        if (this.modelInited) {
            this.toModule(this.appConfigEditor.getManifestConfiguration());
            for (String path : paths) {
                this.appConfigEditor.getChangedPaths().add(path);
            }
            this.validation(null, false);
            this.appConfigEditor.setDirty(true);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.realTimeColor = new Color(null, 0, 102, 204);
        FormToolkit formToolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        Composite parent = this.form.getBody();
        parent.setLayout((Layout)new FillLayout());
        this.pageContent = formToolkit.createComposite(parent);
        this.pageContent.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.titleContent = formToolkit.createComposite(this.pageContent, 0);
        this.titleContent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        FormLayout fl = new FormLayout();
        fl.marginBottom = 5;
        fl.marginTop = 5;
        fl.marginRight = 10;
        fl.marginLeft = 10;
        this.titleContent.setLayout((Layout)fl);
        this.titleLabel = formToolkit.createLabel(this.titleContent, this.getTitle(), 0);
        this.titleLabel.setLayoutData((Object)new FormData());
        if (this.boldFont == null || this.boldFont.isDisposed()) {
            Font font = this.titleLabel.getFont();
            FontData fontData = font.getFontData()[0];
            this.boldFont = new Font(font.getDevice(), fontData.getName(), fontData.getHeight(), 1);
        }
        this.titleLabel.setFont(this.boldFont);
        this.titleLabel.setText(this.getTitle());
        if (this.titleLinkText != null) {
            this.titleLink = formToolkit.createHyperlink(this.titleContent, this.titleLinkText, 0);
            FormData fd = new FormData();
            fd.left = new FormAttachment((Control)this.titleLabel, 30);
            fd.bottom = new FormAttachment((Control)this.titleLabel, 0, 1024);
            this.titleLink.setLayoutData((Object)fd);
            if (this.titleLinkUrl != null) {
                this.titleLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        try {
                            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(AbstractAppConfigPage.this.titleLinkUrl);
                        }
                        catch (Exception ex) {
                            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                        }
                    }
                });
            }
        }
        formToolkit.createLabel(this.pageContent, this.getTitle(), 258).setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.bodyContent = formToolkit.createComposite(this.pageContent, 0);
        this.bodyContent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.bodyContent.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(10, 10).spacing(0, 20).create());
        this.createPageContent(managedForm);
    }

    protected abstract void createPageContent(IManagedForm var1);

    protected Composite createGroup(String name, FormToolkit formToolkit) {
        return this.createGroup(name, this.bodyContent, formToolkit);
    }

    protected Composite createGroup(String name, Composite parent, FormToolkit formToolkit) {
        Composite group = new Composite(parent, 2048);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        group.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        Composite titleComposite = new Composite(group, 0);
        titleComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        titleComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(20, 5).create());
        Label title = new Label(titleComposite, 0);
        title.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).create());
        title.setText(name);
        title.setFont(this.boldFont);
        formToolkit.adapt(group);
        return group;
    }

    public Object getFieldValue(Object source, String ... filedPaths) {
        return ReflectUtils.getFieldValue((Object)source, (String[])filedPaths);
    }

    public void setFieldValue(Object source, Object value, String ... filedPaths) {
        ReflectUtils.setFieldValue((Object)source, (Object)value, (String[])filedPaths);
    }

    public Object newInstanceField(Object source, String ... filedPaths) {
        return ReflectUtils.newInstanceField((Object)source, (String[])filedPaths);
    }

    protected String getProjectRelativePath(String absolutePath) {
        String tmp;
        if (StringUtil.isNotBlank((String)absolutePath) && (tmp = new Path(absolutePath = absolutePath.replace("\\", "/")).makeRelativeTo(this.getEditor().getProject().getLocation()).toString()) != null && !tmp.startsWith("..")) {
            return tmp;
        }
        return absolutePath;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public boolean isModelInited() {
        return this.modelInited;
    }

    public void setModelInited(boolean modelInited) {
        this.modelInited = modelInited;
    }

    public AppConfigEditor getEditor() {
        return this.appConfigEditor;
    }

    public ManifastConfiguration getManifestConfiguration() {
        return this.appConfigEditor.getManifestConfiguration();
    }

    public void dispose() {
        super.dispose();
        if (this.realTimeColor != null && !this.realTimeColor.isDisposed()) {
            this.realTimeColor.dispose();
        }
        if (this.boldFont != null && !this.boldFont.isDisposed()) {
            this.boldFont.dispose();
        }
    }
}

