/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.component;

import com.aptana.core.logging.IdeLog;
import com.pandora.editor.ui.EditorPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ImageViewer {
    private static final int MAX_IMAGE_SIZE = 300;
    private Control source;
    private Shell shell;
    private Composite imageComposite;
    private Image showImage;
    private String showImageUrl;
    private boolean hasScrolle;

    public void show(Control source, String imageUrl) {
        try {
            if (this.shell != null && !this.shell.isDisposed() && this.showImage != null && !this.showImage.isDisposed() && this.source == source && this.showImageUrl != null && this.showImageUrl.equals(imageUrl)) {
                return;
            }
            if (!this.isDispose()) {
                this.dispose();
            }
            this.source = source;
            this.showImageUrl = imageUrl;
            this.showImage = new Image((Device)Display.getDefault(), imageUrl);
            this.hasScrolle = false;
            Rectangle imageBounds = this.showImage.getBounds();
            Point sourcePoint = source.getParent().toDisplay(source.getLocation());
            GridLayout listCompositeLayout = GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(2).margins(0, 0).create();
            int style = 4;
            if (imageBounds.width > 300 || imageBounds.height > 300) {
                style |= 0x10;
                listCompositeLayout.marginHeight = 5;
                listCompositeLayout.marginWidth = 5;
                this.hasScrolle = true;
            }
            this.shell = new Shell(Display.getDefault(), style);
            this.shell.setLayout((Layout)new FillLayout());
            final ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.shell, 768);
            this.imageComposite = new Composite((Composite)scrolledComposite, 0);
            this.imageComposite.setLayout((Layout)listCompositeLayout);
            scrolledComposite.setContent((Control)this.imageComposite);
            scrolledComposite.getVerticalBar().setIncrement(5);
            scrolledComposite.getHorizontalBar().setIncrement(5);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            Label imageLabel = new Label(this.imageComposite, 0);
            imageLabel.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).align(0x1000000, 0x1000000).grab(true, true).create());
            imageLabel.setImage(this.showImage);
            Point imageCompositeSize = this.imageComposite.computeSize(-1, -1);
            if (this.hasScrolle) {
                scrolledComposite.setMinSize(imageCompositeSize.x, imageCompositeSize.y);
            }
            Point scrolledCompositeSize = scrolledComposite.computeSize(-1, -1);
            int shellWidth = Math.min(300, scrolledCompositeSize.x);
            int shellHeight = Math.min(300, scrolledCompositeSize.y);
            this.shell.setLocation(new Point(sourcePoint.x + source.getBounds().width, sourcePoint.y));
            this.shell.setSize(shellWidth, shellHeight);
            this.shell.setVisible(true);
            if (this.hasScrolle) {
                final Listener listener = new Listener(){

                    public void handleEvent(Event event) {
                        if (!(ImageViewer.this.isDispose() || ImageViewer.this.shell.isFocusControl() || ImageViewer.this.imageComposite.isFocusControl() || ImageViewer.this.shell.getBounds().contains(ImageViewer.this.shell.getDisplay().getCursorLocation()) || ImageViewer.this.shell.getDisplay().map((Control)ImageViewer.this.source.getParent(), null, ImageViewer.this.source.getBounds()).contains(ImageViewer.this.shell.getDisplay().getCursorLocation()))) {
                            ImageViewer.this.dispose();
                        }
                    }
                };
                this.shell.getDisplay().addFilter(6, listener);
                this.shell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        ImageViewer.this.shell.getDisplay().removeFilter(6, listener);
                    }
                });
                this.shell.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        scrolledComposite.setFocus();
                    }
                });
                this.imageComposite.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        ImageViewer.this.dispose();
                    }
                });
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
        }
    }

    public boolean close(Point mouseLocation) {
        block4: {
            block5: {
                if (this.isDispose()) break block4;
                if (this.hasScrolle) break block5;
                this.dispose();
                return true;
            }
            try {
                if (!(this.shell.getBounds().contains(mouseLocation) || this.shell.isFocusControl() || this.imageComposite.isFocusControl())) {
                    this.dispose();
                    return true;
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean isDispose() {
        return this.shell == null || this.shell.isDisposed();
    }

    public void dispose() {
        try {
            if (this.shell != null && !this.shell.isDisposed()) {
                this.shell.dispose();
            }
            if (this.showImage != null && !this.showImage.isDisposed()) {
                this.showImage.dispose();
            }
            this.source = null;
            this.hasScrolle = false;
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
        }
    }
}

