/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.component;

import com.aptana.core.util.StringUtil;
import com.pandora.editor.ui.editors.component.BeforeModifyListener;
import com.pandora.editor.ui.editors.component.Messages;
import com.pandora.editor.ui.editors.listener.ConfigChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.wb.swt.ResourceManager;

public class ImageSelectWidget
extends Canvas
implements PaintListener,
MouseListener {
    private static Image highlightImage = ResourceManager.getPluginImage((String)"com.pandora.ui", (String)"icons/widget/highlight.png");
    private static Image warnImage = ResourceManager.getPluginImage((String)"com.pandora.ui", (String)"icons/warning_st_obj.gif");
    private static Image notFoundImage = ResourceManager.getPluginImage((String)"com.pandora.ui", (String)"icons/widget/not_found.png");
    private String defaultToolTip = Messages.ImageSelectWidget_ClickAndChange;
    private Image image = null;
    private String imagePath = null;
    private String imageName = null;
    private ConfigChangeListener changeListener = null;
    private Set<BeforeModifyListener> beforeModifyListeners = new HashSet<BeforeModifyListener>();
    private Set<ModifyListener> modifyListeners = new HashSet<ModifyListener>();
    private String baseLocation = null;
    private Image defaultImage = null;
    private String defaultImageUrl = null;
    private boolean autoSave = false;
    private boolean highlight = false;
    private Point validPoint = null;
    private int style;

    public ImageSelectWidget(Composite parent, Image defalutImage, String defaultImageUrl, Point validPoint, int style) {
        super(parent, 0x20000000);
        this.defaultImage = defalutImage;
        this.defaultImageUrl = defaultImageUrl;
        this.validPoint = validPoint;
        this.setCursor(new Cursor((Device)this.getDisplay(), 21));
        this.addPaintListener(this);
        this.addMouseListener(this);
        this.style = style;
    }

    public void paintControl(PaintEvent e) {
        GC g = e.gc;
        Image image = this.image == null ? this.defaultImage : this.image;
        int width = image.getBounds().width;
        int height = image.getBounds().height;
        int borderWidth = 0;
        if ((this.style & 0x800) != 0) {
            g.setForeground(this.getDisplay().getSystemColor(2));
            g.setLineWidth(2);
            g.drawRectangle(0, 0, this.getSize().x, this.getSize().y);
            borderWidth = 2;
        }
        g.setAdvanced(true);
        g.setAntialias(1);
        if (StringUtil.isNotBlank((String)this.imagePath) && this.image == null) {
            g.drawImage(notFoundImage, (this.getSize().x - ImageSelectWidget.notFoundImage.getBounds().width) / 2, (this.getSize().y - ImageSelectWidget.notFoundImage.getBounds().height) / 2);
            this.setToolTipText("\u56fe\u7247[" + this.imagePath + "]\u4e0d\u5b58\u5728\u3002");
        } else {
            g.drawImage(image, 0, 0, width, height, borderWidth / 2, borderWidth / 2, this.getSize().x - borderWidth, this.getSize().y - borderWidth);
            if (this.highlight) {
                int highlightImageWidth = ImageSelectWidget.highlightImage.getBounds().width;
                int highlightImageHeight = ImageSelectWidget.highlightImage.getBounds().height;
                g.drawImage(highlightImage, 0, 0, highlightImageWidth, highlightImageHeight, (this.getSize().x - highlightImageWidth) / 2 + borderWidth / 2, borderWidth / 2, highlightImageWidth - borderWidth, highlightImageHeight - borderWidth);
            }
            this.setToolTipText(this.defaultToolTip);
        }
        if (this.validPoint != null && image != this.defaultImage && image != notFoundImage && (width != this.validPoint.x || height != this.validPoint.y)) {
            g.drawImage(warnImage, 1, 1);
            this.setToolTipText("\u5206\u8fa8\u7387\u4e0d\u7b26\u5408\u6807\u51c6\uff0c\u4e3a\u4e86\u4f7fApp\u6548\u679c\u66f4\u597d\uff0c\u5efa\u8bae\u66f4\u6362\u4e3a\u6b63\u786e\u5206\u8fa8\u7387\u7684\u56fe\u7247\u3002");
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        String result;
        if (e.getSource() != this) {
            return;
        }
        FileDialog dialog = new FileDialog(this.getShell(), 65536);
        dialog.setFilterExtensions(new String[]{"*.png"});
        if (this.imagePath != null) {
            File file = new File(this.imagePath);
            dialog.setFilterPath(file.getParent());
            dialog.setFileName(file.getName());
        }
        if (StringUtil.isNotEmpty((String)(result = dialog.open()))) {
            this.handleAutoSave(result);
            this.setImageName(dialog.getFileName());
            this.setImagePath(result);
            if (this.changeListener != null) {
                this.changeListener.configChanged();
            }
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    private void handleAutoSave(String result) {
        if (!this.autoSave || StringUtil.isEmpty((String)this.baseLocation)) {
            return;
        }
        final File srcFile = new File(result);
        String destFilePath = String.valueOf(this.getBaseLocation()) + File.separatorChar + srcFile.getName();
        String oldFilePath = String.valueOf(this.getBaseLocation()) + File.separatorChar + this.imageName;
        final File destFile = new File(destFilePath);
        final File oldFile = new File(oldFilePath);
        if (srcFile.exists()) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            try {
                                if (oldFile.exists()) {
                                    oldFile.delete();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            FileUtils.copyFile((File)srcFile, (File)destFile);
                        }
                        catch (IOException e) {
                            throw new CoreException((IStatus)new Status(4, "com.pandora.core", e.getMessage()));
                        }
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void addConfigChangeListener(ConfigChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public String getBaseLocation() {
        return this.baseLocation;
    }

    public void setBaseLocation(String baseLocation) {
        this.baseLocation = baseLocation;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setImagePath(String imagePath) {
        if (StringUtil.isBlank((String)this.imagePath) && StringUtil.isBlank((String)imagePath) && this.image == null || this.image != null && this.imagePath == imagePath || this.image != null && this.imagePath != null && this.imagePath.equals(imagePath)) {
            return;
        }
        if (!this.fireBeforeModifyEvent(imagePath)) {
            return;
        }
        String oldPath = this.imagePath;
        String string = this.imagePath = StringUtil.isBlank((String)imagePath) ? null : imagePath;
        if (this.image != null && !this.image.isDisposed() && this.image != notFoundImage && this.image != this.defaultImage) {
            this.image.dispose();
        }
        this.image = null;
        if (this.imagePath != null) {
            this.imagePath = imagePath.replace("\\", "/");
            File file = new File(this.imagePath);
            if (file != null && file.exists() && file.isFile()) {
                try {
                    this.image = new Image((Device)this.getDisplay(), this.imagePath);
                }
                catch (Exception exception) {}
            }
        }
        this.redraw();
        this.fireModifyEvent(oldPath);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.modifyListeners.add(modifyListener);
    }

    private void fireModifyEvent(String oldPath) {
        for (ModifyListener modifyListener : this.modifyListeners) {
            Event event = new Event();
            event.widget = this;
            event.data = oldPath;
            ModifyEvent modifyEvent = new ModifyEvent(event);
            modifyEvent.widget = this;
            modifyListener.modifyText(modifyEvent);
        }
    }

    public void addBeforeModifyListener(BeforeModifyListener modifyListener) {
        this.beforeModifyListeners.add(modifyListener);
    }

    private boolean fireBeforeModifyEvent(String oldPath) {
        boolean result = true;
        for (BeforeModifyListener modifyListener : this.beforeModifyListeners) {
            Event event = new Event();
            event.widget = this;
            event.data = oldPath;
            ModifyEvent modifyEvent = new ModifyEvent(event);
            modifyEvent.widget = this;
            boolean bl = result = result && modifyListener.beforeModify(modifyEvent);
        }
        return result;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
        this.redraw();
    }

    public boolean isDefault() {
        return this.image == null && StringUtil.isBlank((String)this.imagePath);
    }

    public boolean isExist() {
        return this.image != null && StringUtil.isNotBlank((String)this.imagePath);
    }

    public boolean isResolutionCorrect() {
        if (this.validPoint != null && !this.isDefault() && this.isExist()) {
            Rectangle bounds = this.image.getBounds();
            return this.validPoint.x == bounds.width && this.validPoint.y == bounds.height;
        }
        return true;
    }

    public Point getValidPoint() {
        return this.validPoint;
    }

    public void setDefaultToolTip(String defaultToolTip) {
        this.defaultToolTip = defaultToolTip;
    }

    public String getDefaultToolTip() {
        return this.defaultToolTip;
    }

    public String getDefaultImageUrl() {
        return this.defaultImageUrl;
    }

    public void dispose() {
        if (this.image != null && !this.image.isDisposed() && this.image != notFoundImage) {
            this.image.dispose();
        }
        if (this.defaultImage != null && !this.defaultImage.isDisposed()) {
            this.defaultImage.dispose();
        }
        super.dispose();
    }
}

