/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class MobileProjectResourceCollector
implements IResourceVisitor {
    private List<IFile> fFiles = new ArrayList<IFile>();
    private Map fManifestMap = null;
    private Set<String> fUnpackages = new LinkedHashSet<String>();

    public MobileProjectResourceCollector(Map maniFestJSonMap) {
        this.fManifestMap = maniFestJSonMap;
        if (this.fManifestMap != null && this.fManifestMap.containsKey("unpackage")) {
            Collection unpackages = (Collection)this.fManifestMap.get("unpackage");
            this.fUnpackages.addAll(unpackages);
        }
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource instanceof IFolder) {
            if ("unpackage".equals(resource.getName()) && resource.getParent() instanceof IProject) {
                return false;
            }
            for (String unpackage : this.fUnpackages) {
                if (!resource.getName().startsWith(unpackage)) continue;
                return false;
            }
            return true;
        }
        if (resource instanceof IFile) {
            for (String unpackage : this.fUnpackages) {
                if (!resource.getProjectRelativePath().toString().equals(unpackage)) continue;
                return false;
            }
            this.fFiles.add((IFile)resource);
        }
        return true;
    }

    public List<IFile> getFiles() {
        return this.fFiles;
    }
}

