/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.refactoring;

import com.pandora.refactor.core.RefactorCoreActivator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditProcessor;

public class TextFileContentChange
extends TextFileChange {
    private TextEditCopier fCopier;
    private TextEdit edit;

    public TextFileContentChange(IFile file) {
        super("", file);
    }

    public TextFileContentChange(String name, IFile file) {
        super(name, file);
    }

    public void setPreviewEdit(TextEdit edit) {
        this.edit = edit;
    }

    public String getPreviewContent(IProgressMonitor pm) throws CoreException {
        PreviewAndRegion result = this.getPreviewDocument(null, pm);
        return result.document.get();
    }

    private PreviewAndRegion getPreviewDocument(TextEditBasedChangeGroup[] changes, IProgressMonitor pm) throws CoreException {
        Document document = new Document(this.getCurrentDocument(pm).get());
        boolean trackChanges = this.getKeepPreviewEdits();
        this.setKeepPreviewEdits(true);
        TextEditProcessor processor = this.createTextEditProcessor((IDocument)document, 0, true);
        try {
            processor.performEdits();
            PreviewAndRegion previewAndRegion = new PreviewAndRegion((IDocument)document, this.getNewRegion(changes));
            return previewAndRegion;
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, RefactorCoreActivator.getPluginId(), e.getMessage(), (Throwable)e));
        }
        finally {
            this.setKeepPreviewEdits(trackChanges);
        }
    }

    private TextEditProcessor createTextEditProcessor(IDocument document, int flags, boolean preview) {
        if (this.edit == null) {
            return new TextEditProcessor(document, (TextEdit)new MultiTextEdit(0, 0), flags);
        }
        ArrayList<TextEdit> excludes = new ArrayList<TextEdit>(0);
        TextEditBasedChangeGroup[] groups = this.getChangeGroups();
        int index = 0;
        while (index < groups.length) {
            TextEditBasedChangeGroup edit = groups[index];
            if (!edit.isEnabled()) {
                excludes.addAll(Arrays.asList(edit.getTextEditGroup().getTextEdits()));
            }
            ++index;
        }
        this.fCopier = new TextEditCopier(this.edit);
        TextEdit copiedEdit = this.fCopier.perform();
        boolean keep = this.getKeepPreviewEdits();
        if (keep) {
            flags |= 2;
        }
        LocalTextEditProcessor result = new LocalTextEditProcessor(document, copiedEdit, flags);
        result.setExcludes(this.mapEdit(excludes.toArray(new TextEdit[excludes.size()]), this.fCopier));
        if (!keep) {
            this.fCopier = null;
        }
        return result;
    }

    private IRegion getNewRegion(TextEditBasedChangeGroup[] changes) {
        if (changes == null) {
            if (this.edit == null) {
                return null;
            }
            return this.fCopier.getCopy(this.edit).getRegion();
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>();
        int c = 0;
        while (c < changes.length) {
            TextEdit[] edits = changes[c].getTextEditGroup().getTextEdits();
            int e = 0;
            while (e < edits.length) {
                TextEdit copy = this.fCopier.getCopy(edits[e]);
                if (copy != null) {
                    result.add(copy);
                }
                ++e;
            }
            ++c;
        }
        if (result.size() == 0) {
            return null;
        }
        return TextEdit.getCoverage((TextEdit[])result.toArray(new TextEdit[result.size()]));
    }

    private TextEdit[] mapEdit(TextEdit[] edits, TextEditCopier copier) {
        if (edits == null) {
            return null;
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>(edits.length);
        int i = 0;
        while (i < edits.length) {
            TextEdit edit = copier.getCopy(edits[i]);
            if (edit != null) {
                result.add(edit);
            }
            ++i;
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    private static final class LocalTextEditProcessor
    extends TextEditProcessor {
        private TextEdit[] fExcludes;
        private TextEdit[] fIncludes;

        protected LocalTextEditProcessor(IDocument document, TextEdit root, int flags) {
            super(document, root, flags);
        }

        public void setExcludes(TextEdit[] excludes) {
            Assert.isNotNull((Object)excludes);
            Assert.isTrue((this.fIncludes == null ? 1 : 0) != 0);
            this.fExcludes = this.flatten(excludes);
        }

        protected boolean considerEdit(TextEdit edit) {
            if (this.fExcludes != null) {
                int i = 0;
                while (i < this.fExcludes.length) {
                    if (edit.equals((Object)this.fExcludes[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (this.fIncludes != null) {
                int i = 0;
                while (i < this.fIncludes.length) {
                    if (edit.equals((Object)this.fIncludes[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return true;
        }

        private TextEdit[] flatten(TextEdit[] edits) {
            ArrayList<TextEdit> result = new ArrayList<TextEdit>(5);
            int i = 0;
            while (i < edits.length) {
                this.flatten(result, edits[i]);
                ++i;
            }
            return result.toArray(new TextEdit[result.size()]);
        }

        private void flatten(List<TextEdit> result, TextEdit edit) {
            result.add(edit);
            TextEdit[] children = edit.getChildren();
            int i = 0;
            while (i < children.length) {
                this.flatten(result, children[i]);
                ++i;
            }
        }
    }

    private static final class PreviewAndRegion {
        public IDocument document;
        public IRegion region;

        public PreviewAndRegion(IDocument d, IRegion r) {
            this.document = d;
            this.region = r;
        }
    }
}

