/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.refactoring;

import com.aptana.core.util.IOUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.ExtendedFastPartitioner;
import com.aptana.editor.common.IExtendedPartitioner;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.NullPartitionerSwitchStrategy;
import com.aptana.editor.common.text.rules.CompositePartitionScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.NullSubPartitionScanner;
import com.aptana.editor.css.CSSSourceConfiguration;
import com.aptana.editor.css.parsing.ast.CSSParseRootNode;
import com.aptana.editor.html.HTMLSourceConfiguration;
import com.aptana.editor.js.JSSourceConfiguration;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseRootNode;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class RefactorUtils {
    public static final String[] EXTENDTIONS = new String[]{"asa", "as", "applescript", "script", "css", "css.erb", "js", "htc", "jsx", "js.erb", "erb", "tex", ".build", "asp", "yaws", "rhtml", "html.erb", "adp", "json", "properties", "jsp", "sh", "bash", "zsh", "bashrc", "bash_profile", "bash_login", "profile", "bash_logout", "sty", "cls", "textile", "xml", "xsd", "xslt", "svg", "tld", "cpt", "pt", "rss", "opml", "xsl", "rst", "rest", "py", "rpy", "pyw", "cpy", "sconstruct", "sconscript", "rb", "rbx", "rjs", "rakefile", "rake", "cgi", "fcgi", "gemspec", "irbrc", "capfile", "gemfile", "haml", "sass", "rxml", "builder", "php", "txt", "htm", "shtml", "xhtml", "phtml", "inc", "tmpl", "tpl", "ctp", "html"};
    public static final String[] EXCLUDEFOLDER = new String[]{"setting/", "bin/"};
    public static final String[] JS_EXTENDTIONS = new String[]{"script", "js", "jsx", "js.erb"};
    public static final String[] CSS_EXTENDTIONS = new String[]{"css", "css.erb"};
    public static final String[] HTML_EXTENDTIONS = new String[]{"rhtml", "html.erb", "htm", "shtml", "xhtml", "phtml", "html"};
    public static String[] HTML_SRC_ATTRIBUTE = new String[]{"src", "url", "href", "action", "background", "download", "refresh"};
    public static String[] CSS_SRC_ATTRIBUTE = new String[]{"url"};
    public static String[] JS_SRC_ATTRIBUTE = new String[]{"src", "url", "href", "action", "window.location.href", "window.domain", "location", "window.location", "window.open", "window.showModalDialog", "background", "download", "refresh"};
    public static final String HTML_SRC_REG_1 = "[\\s]*=[\\s]*[\"']([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";
    public static final String HTML_SRC_REG_2 = "[\\s]*=[\\s]*([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";
    public static final String CSS_SRC_REG = "[\\s]*\\([\\s]*([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\\)]";
    public static final String JS_SRC_REG = "[\\s]*=[\\s]*[\"']([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";
    public static final String PANDORA_REPLACE_STRING = "\u4e96";
    public static final char PANDORA_REPLACE_CHAR = '\u4e96';

    public static IDocument getDocumentByIFile(IFile iFile) throws CoreException {
        InputStream inputStream = iFile.getContents();
        String content = IOUtil.read((InputStream)inputStream);
        Document document = new Document(content);
        if (RefactorUtils.isHTML(iFile)) {
            document = RefactorUtils.formatHTMLPartitioner((IDocument)document);
        } else if (RefactorUtils.isJS(iFile)) {
            document = RefactorUtils.formatJSPartitioner((IDocument)document);
        } else if (RefactorUtils.isCSS(iFile)) {
            document = RefactorUtils.formatCSSPartitioner((IDocument)document);
        }
        return document;
    }

    public static boolean isCSS(IFile ifile) {
        return Arrays.asList(CSS_EXTENDTIONS).contains(ifile.getFileExtension());
    }

    public static boolean isJS(IFile ifile) {
        return Arrays.asList(JS_EXTENDTIONS).contains(ifile.getFileExtension());
    }

    public static boolean isHTML(IFile ifile) {
        return Arrays.asList(HTML_EXTENDTIONS).contains(ifile.getFileExtension());
    }

    public static IDocument formatCSSPartitioner(IDocument document) {
        CompositePartitionScanner partitionScanner = new CompositePartitionScanner(CSSSourceConfiguration.getDefault().createSubPartitionScanner(), (ISubPartitionScanner)new NullSubPartitionScanner(), (IPartitionerSwitchStrategy)new NullPartitionerSwitchStrategy());
        ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, CSSSourceConfiguration.getDefault().getContentTypes());
        partitionScanner.setPartitioner((IExtendedPartitioner)partitioner);
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        CommonEditorPlugin.getDefault().getDocumentScopeManager().registerConfiguration(document, (IPartitioningConfiguration)CSSSourceConfiguration.getDefault());
        return document;
    }

    public static IDocument formatJSPartitioner(IDocument document) {
        CompositePartitionScanner partitionScanner = new CompositePartitionScanner(JSSourceConfiguration.getDefault().createSubPartitionScanner(), (ISubPartitionScanner)new NullSubPartitionScanner(), (IPartitionerSwitchStrategy)new NullPartitionerSwitchStrategy());
        ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, JSSourceConfiguration.getDefault().getContentTypes());
        partitionScanner.setPartitioner((IExtendedPartitioner)partitioner);
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        CommonEditorPlugin.getDefault().getDocumentScopeManager().registerConfiguration(document, (IPartitioningConfiguration)JSSourceConfiguration.getDefault());
        return document;
    }

    public static IDocument formatHTMLPartitioner(IDocument document) {
        CompositePartitionScanner partitionScanner = new CompositePartitionScanner(HTMLSourceConfiguration.getDefault().createSubPartitionScanner(), (ISubPartitionScanner)new NullSubPartitionScanner(), (IPartitionerSwitchStrategy)new NullPartitionerSwitchStrategy());
        ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, HTMLSourceConfiguration.getDefault().getContentTypes());
        partitionScanner.setPartitioner((IExtendedPartitioner)partitioner);
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        CommonEditorPlugin.getDefault().getDocumentScopeManager().registerConfiguration(document, (IPartitioningConfiguration)HTMLSourceConfiguration.getDefault());
        return document;
    }

    public static CSSParseRootNode getCSSParseRoot(IDocument document) throws Exception {
        ParseState parseState = new ParseState(document.get());
        IParseRootNode ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.css", (IParseState)parseState).getRootNode();
        CSSParseRootNode root = null;
        if (ast instanceof CSSParseRootNode) {
            root = (CSSParseRootNode)ast;
        }
        return root;
    }
}

