/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.refactoring;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.css.parsing.ast.CSSParseRootNode;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.pandora.core.utils.RegularUtils;
import com.pandora.core.utils.URIUtils;
import com.pandora.refactor.core.index.JSFileReferenceHelper;
import com.pandora.refactor.core.refactoring.RefactorIRange;
import com.pandora.refactor.core.refactoring.RefactorUtils;
import com.pandora.refactor.core.refactoring.TextFileContentChange;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.TextSearchPage;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RefactorMoveFileParticipant
extends TextSearchPage {
    IProject _Project;
    String oldName;
    String newName;
    CompositeChange result;
    CompositeChange indentifineCompositeChange;
    CompositeChange undentifineCompositeChange;
    List<String> extendList;
    List<String> excludeFolderList;
    List<IFile> srcListFile = new ArrayList<IFile>();

    public RefactorMoveFileParticipant(CompositeChange compositeChange, IResource src, String oldName, String newName) {
        this._Project = src.getProject();
        this.oldName = oldName;
        this.newName = newName;
        this.result = compositeChange;
        this.undentifineCompositeChange = new CompositeChange("UnSelected renames");
        this.undentifineCompositeChange.setEnabledShallow(false);
        this.indentifineCompositeChange = new CompositeChange("Selected renames");
        this.extendList = Arrays.asList(RefactorUtils.EXTENDTIONS);
        this.excludeFolderList = Arrays.asList(RefactorUtils.EXCLUDEFOLDER);
        if (src instanceof IFile) {
            this.srcListFile.add((IFile)src);
        }
        if (src instanceof IFolder) {
            this.getFolderFile(src.getLocationURI());
        }
    }

    private void getFolderFile(URI uri) {
        try {
            IFileStore projectStore = EFS.getStore((URI)uri);
            this.refactorFolderFiles(projectStore);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void refactorFolderFiles(IFileStore projectStore) throws CoreException {
        IFileStore[] fileStores = projectStore.childStores(0, (IProgressMonitor)new NullProgressMonitor());
        if (fileStores == null || fileStores.length == 0) {
            return;
        }
        int i = 0;
        while (i < fileStores.length) {
            IFileStore fileStore = fileStores[i];
            if (fileStores != null && fileStores.length != 0) {
                File file = fileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                if (file.isFile()) {
                    String fname = file.getName();
                    if (StringUtil.isNotBlank((String)fname)) {
                        IPath ipath = RefactorMoveFileParticipant.getIPath(fileStore);
                        IFile ifile = RefactorMoveFileParticipant.getIFile(ipath);
                        this.srcListFile.add(ifile);
                    }
                } else {
                    this.refactorFolderFiles(fileStore);
                }
            }
            ++i;
        }
    }

    private static IFile getIFile(IPath ipath) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(ipath);
        return file;
    }

    private static IPath getIPath(IFileStore fileStore) {
        String fPath = fileStore.toURI().getPath();
        IPath path = RefactorMoveFileParticipant.getIPath(fPath);
        return path;
    }

    private static IPath getIPath(String fPath) {
        IPath path = Path.fromOSString((String)fPath);
        return path;
    }

    public CompositeChange computeChange() {
        this.performAction();
        if (this.indentifineCompositeChange != null && this.indentifineCompositeChange.getChildren().length > 0) {
            this.result.add((Change)this.indentifineCompositeChange);
        }
        if (this.undentifineCompositeChange != null && this.undentifineCompositeChange.getChildren().length > 0) {
            this.result.add((Change)this.undentifineCompositeChange);
        }
        return this.result;
    }

    public boolean performAction() {
        IResource[] res = new IResource[]{this._Project};
        String[] extens = new String[]{"*.*"};
        FileTextSearchScope fts = FileTextSearchScope.newSearchScope((IResource[])res, (String[])extens, (boolean)false);
        for (IFile ifile : this.srcListFile) {
            FileSearchQuery isq = new FileSearchQuery(ifile.getName(), true, true, fts);
            isq.run((IProgressMonitor)new NullProgressMonitor());
            this.processResult(isq);
            String extend = ifile.getFileExtension();
            if (StringUtil.contains((String[])RefactorUtils.HTML_EXTENDTIONS, (String)extend)) {
                this.getHTMLFileSelfResult(ifile);
                continue;
            }
            if (StringUtil.contains((String[])RefactorUtils.CSS_EXTENDTIONS, (String)extend)) {
                this.getCSSFileSelfResult(ifile);
                continue;
            }
            if (!StringUtil.contains((String[])RefactorUtils.JS_EXTENDTIONS, (String)extend)) continue;
            this.getJSFileSelfResult(ifile);
        }
        return true;
    }

    private void getJSFileSelfResult(IFile ifile) {
        try {
            IDocument document = RefactorUtils.getDocumentByIFile(ifile);
            List<RefactorIRange> ranges = this.getJSFileRanges(ifile, document);
            if (ranges == null) {
                return;
            }
            boolean hasOnlyOne = true;
            if (ranges.size() > 1) {
                hasOnlyOne = false;
            }
            this.getJSFileSelfResult(ifile, document, ranges, hasOnlyOne);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getJSFileSelfResult(IFile ifile, IDocument document, List<RefactorIRange> ranges, boolean hasOnlyOne) throws BadLocationException {
        TextFileContentChange textFileChange = null;
        boolean hasChange = false;
        boolean hasUnChange = false;
        int prefixOffset = 0;
        CompositeChange change = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
        CompositeChange unchange = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
        unchange.setEnabledShallow(false);
        Set<String> htmlSet = JSFileReferenceHelper.getReference(ifile.getProject(), ifile.getProjectRelativePath().toString());
        String projectPath = ifile.getProject().getLocation().toString();
        for (RefactorIRange range : ranges) {
            if (range == null) continue;
            String replaceStr = document.get(range.getStartingOffset(), range.getLength());
            int startOffset = range.getStartingOffset();
            textFileChange = new TextFileContentChange(this.oldName, ifile);
            String replaceStr_new = "";
            if (!range.isSure()) continue;
            hasChange = true;
            for (String htmlPath : htmlSet) {
                String resolvePath = "";
                resolvePath = replaceStr.startsWith("/") ? replaceStr : URIUtils.resolveURI((String)htmlPath, (String)replaceStr);
                if (!StringUtil.isNotBlank((String)resolvePath) || !this.checkPathExist(resolvePath, projectPath)) continue;
                replaceStr_new = this.getFileRelativePath(replaceStr, htmlPath);
                break;
            }
            if (replaceStr.equals(replaceStr_new)) continue;
            ReplaceEdit edit = new ReplaceEdit(startOffset + prefixOffset, range.getLength(), replaceStr_new);
            textFileChange.setEdit((TextEdit)edit);
            ReplaceEdit previewEdit = new ReplaceEdit(startOffset, range.getLength(), replaceStr_new);
            textFileChange.setPreviewEdit((TextEdit)previewEdit);
            if (!hasOnlyOne) {
                if (range.isSure()) {
                    change.add((Change)textFileChange);
                } else {
                    unchange.add((Change)textFileChange);
                }
            }
            prefixOffset += replaceStr_new.length() - replaceStr.length();
        }
        this.addUnOrIndentifineCompositeChange(hasOnlyOne, change, unchange, textFileChange, hasChange, hasUnChange);
    }

    private List<RefactorIRange> getJSFileRanges(IFile ifile, IDocument document) {
        try {
            JSParseRootNode jsParseRootNode = this.getJSParseRoot(document);
            ParsJSTreeWalker parsJSTreeWalker = new ParsJSTreeWalker(ifile, document);
            parsJSTreeWalker.visit(jsParseRootNode);
            return parsJSTreeWalker.getIRanges();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean checkPathExist(String resolvePath, String projectPath) {
        String path;
        IPath iPath;
        IFile file;
        if (!resolvePath.startsWith("/")) {
            resolvePath = "/" + resolvePath;
        }
        if ((file = RefactorMoveFileParticipant.getIFile(iPath = RefactorMoveFileParticipant.getIPath(path = String.valueOf(projectPath) + resolvePath))) == null) {
            return false;
        }
        return file.exists();
    }

    private void getCSSFileSelfResult(IFile ifile) {
        try {
            IDocument document = RefactorUtils.getDocumentByIFile(ifile);
            List<RefactorIRange> ranges = this.getCSSFileRanges(ifile, document);
            boolean hasOnlyOne = true;
            if (ranges.size() > 1) {
                hasOnlyOne = false;
            }
            this.getFileSelfResult(ifile, document, ranges, hasOnlyOne);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<RefactorIRange> getCSSFileRanges(IFile ifile, IDocument document) throws Exception {
        ArrayList<RefactorIRange> ranges = new ArrayList<RefactorIRange>();
        CSSParseRootNode root = RefactorUtils.getCSSParseRoot(document);
        for (IParseNode iParseNode : root) {
            int offset = iParseNode.getStartingOffset();
            String text = document.get(iParseNode.getStartingOffset(), iParseNode.getLength());
            this.getCSSFileValues(ifile, ranges, text, offset);
        }
        return ranges;
    }

    private void getCSSFileValues(IFile ifile, List<RefactorIRange> ranges, String text, int offset) {
        String[] stringArray = RefactorUtils.CSS_SRC_ATTRIBUTE;
        int n = RefactorUtils.CSS_SRC_ATTRIBUTE.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            String regix = String.valueOf(tag) + "[\\s]*\\([\\s]*([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\\)]";
            String[] values = RegularUtils.matchs((String)regix, (String)text);
            if (values != null && values.length >= 1) {
                this.getRangesFromValues(ifile, ranges, text, offset, values);
            }
            ++n2;
        }
    }

    private void getRangesFromValues(IFile ifile, List<RefactorIRange> ranges, String text, int offset, String[] values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String resolvePath;
            String value = stringArray[n2];
            if (StringUtil.isNotBlank((String)value) && !StringUtil.isBlank((String)(resolvePath = URIUtils.resolveURI((String)ifile.getProjectRelativePath().toString(), (String)value))) && this.checkPathExist(resolvePath, ifile.getProject().getLocation().toString())) {
                int index = text.indexOf(value);
                int startOffset = offset + index;
                int length = value.length();
                RefactorIRange range = new RefactorIRange(startOffset, startOffset + length - 1, ifile, true);
                ranges.add(range);
            }
            ++n2;
        }
    }

    private void getHTMLFileSelfResult(IFile ifile) {
        try {
            IDocument document = RefactorUtils.getDocumentByIFile(ifile);
            List<RefactorIRange> ranges = this.getFileRanges(ifile, document);
            boolean hasOnlyOne = true;
            if (ranges.size() > 1) {
                hasOnlyOne = false;
            }
            this.getFileSelfResult(ifile, document, ranges, hasOnlyOne);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void getFileSelfResult(IFile ifile, IDocument document, List<RefactorIRange> ranges, boolean hasOnlyOne) throws BadLocationException {
        TextFileContentChange textFileChange = null;
        boolean hasChange = false;
        boolean hasUnChange = false;
        int prefixOffset = 0;
        CompositeChange change = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
        CompositeChange unchange = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
        unchange.setEnabledShallow(false);
        for (RefactorIRange range : ranges) {
            if (range == null) continue;
            String replaceStr = document.get(range.getStartingOffset(), range.getLength());
            int startOffset = range.getStartingOffset();
            textFileChange = new TextFileContentChange(this.oldName, ifile);
            String replaceStr_new = "";
            if (!range.isSure()) continue;
            hasChange = true;
            replaceStr_new = this.getFileRelativePath(replaceStr, ifile.getProjectRelativePath().toString());
            if (replaceStr.equals(replaceStr_new)) continue;
            ReplaceEdit edit = new ReplaceEdit(startOffset + prefixOffset, range.getLength(), replaceStr_new);
            textFileChange.setEdit((TextEdit)edit);
            ReplaceEdit previewEdit = new ReplaceEdit(startOffset, range.getLength(), replaceStr_new);
            textFileChange.setPreviewEdit((TextEdit)previewEdit);
            if (!hasOnlyOne) {
                if (range.isSure()) {
                    change.add((Change)textFileChange);
                } else {
                    unchange.add((Change)textFileChange);
                }
            }
            prefixOffset += replaceStr_new.length() - replaceStr.length();
        }
        this.addUnOrIndentifineCompositeChange(hasOnlyOne, change, unchange, textFileChange, hasChange, hasUnChange);
    }

    private String getFileRelativePath(String replaceStr, String srcFilePath) {
        String resolvePath = "";
        if (StringUtil.isNotBlank((String)srcFilePath)) {
            resolvePath = replaceStr.startsWith("/") ? replaceStr : URIUtils.resolveURI((String)srcFilePath, (String)replaceStr);
            for (IFile ifile : this.srcListFile) {
                String fileName;
                if (ifile == null || !resolvePath.equals(fileName = ifile.getProjectRelativePath().toString())) continue;
                resolvePath = URIUtils.relativeURI((String)srcFilePath, (String)resolvePath);
                return resolvePath;
            }
            if (this.newName.equals("/")) {
                this.newName = "";
            }
            srcFilePath = StringUtil.isBlank((String)this.oldName) ? String.valueOf(this.newName) + srcFilePath : srcFilePath.replace(this.oldName, this.newName);
            resolvePath = URIUtils.relativeURI((String)srcFilePath, (String)resolvePath);
        }
        return resolvePath;
    }

    private List<RefactorIRange> getFileRanges(IFile ifile, IDocument document) throws BadLocationException {
        int dlength = document.getLength();
        ArrayList<RefactorIRange> ranges = new ArrayList<RefactorIRange>();
        boolean isExist = true;
        int offset = 1;
        while (isExist) {
            String value;
            String pInfo;
            ITypedRegion typedRegion;
            if ((offset += (typedRegion = document.getPartition(offset)).getLength()) >= dlength) {
                isExist = false;
            }
            if (StringUtil.isBlank((String)(pInfo = document.get(typedRegion.getOffset(), typedRegion.getLength())).trim()) || StringUtil.isBlank((String)(value = this.getHTMLTagValue(pInfo)))) continue;
            int startOffset = typedRegion.getOffset() + pInfo.indexOf(value);
            int length = value.length();
            RefactorIRange range = new RefactorIRange(startOffset, startOffset + length - 1, ifile, true);
            ranges.add(range);
        }
        return ranges;
    }

    private void processResult(FileSearchQuery isq) {
        ISearchResult isr = isq.getSearchResult();
        if (isr instanceof FileSearchResult) {
            Object[] os;
            FileSearchResult fsr = (FileSearchResult)isr;
            Object[] objectArray = os = fsr.getElements();
            int n = os.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                Object object = objectArray[n2];
                if (object instanceof IFile && !this.srcListFile.contains(file = (IFile)object) && this.checkFile(file)) {
                    this.computeResult(fsr, object, file);
                }
                ++n2;
            }
        }
    }

    private void computeResult(FileSearchResult fileSearchResult, Object object, IFile ifile) {
        Match[] matchs = fileSearchResult.getMatches(object);
        try {
            IDocument document = RefactorUtils.getDocumentByIFile(ifile);
            boolean hasOnlyOne = false;
            if (matchs != null && matchs.length == 1) {
                hasOnlyOne = true;
            }
            if (RefactorUtils.isHTML(ifile)) {
                this.computeHTMLResult(ifile, matchs, document, hasOnlyOne);
            } else if (RefactorUtils.isJS(ifile)) {
                this.computeJSResult(ifile, matchs, document, hasOnlyOne);
            } else if (RefactorUtils.isCSS(ifile)) {
                this.computeCSSResult(ifile, matchs, document, hasOnlyOne);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void computeOtherResult(IFile ifile, Match[] matchs, IDocument document, boolean hasOnlyOne) {
        try {
            CompositeChange unchange = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            unchange.setEnabledShallow(false);
            int prefixOffset = 0;
            TextFileContentChange textFileChange = null;
            boolean hasunChange = false;
            Match[] matchArray = matchs;
            int n = matchs.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                int startOffset = match.getOffset();
                int length = match.getLength();
                String replaceStr = document.get(startOffset, length);
                textFileChange = new TextFileContentChange(this.oldName, ifile);
                String replaceStr_new = this.newName;
                textFileChange.setEnabledShallow(false);
                ReplaceEdit edit = new ReplaceEdit(startOffset + prefixOffset, length, replaceStr_new);
                textFileChange.setEdit((TextEdit)edit);
                ReplaceEdit previewEdit = new ReplaceEdit(startOffset, length, replaceStr_new);
                textFileChange.setPreviewEdit((TextEdit)previewEdit);
                hasunChange = true;
                if (!hasOnlyOne) {
                    unchange.add((Change)textFileChange);
                }
                prefixOffset += replaceStr_new.length() - replaceStr.length();
                ++n2;
            }
            this.addUnOrIndentifineCompositeChange(hasOnlyOne, null, unchange, textFileChange, false, hasunChange);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void computeCSSResult(IFile ifile, Match[] matchs, IDocument document, boolean hasOnlyOne) {
        try {
            CompositeChange change = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            CompositeChange unchange = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            unchange.setEnabledShallow(false);
            int prefixOffset = 0;
            TextFileContentChange textFileChange = null;
            boolean hasChange = false;
            boolean hasunChange = false;
            CSSParseRootNode root = RefactorUtils.getCSSParseRoot(document);
            Match[] matchArray = matchs;
            int n = matchs.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                RefactorIRange range = this.getCSSIRange(ifile, document, match, root);
                if (range != null) {
                    String replaceStr = document.get(range.getStartingOffset(), range.getLength());
                    int startOffset = range.getStartingOffset();
                    textFileChange = new TextFileContentChange(this.oldName, ifile);
                    String replaceStr_new = "";
                    if (range.isSure()) {
                        hasChange = true;
                        replaceStr_new = this.getFolderRelativePath(replaceStr, ifile.getProjectRelativePath().toString());
                        if (!replaceStr.equals(replaceStr_new)) {
                            ReplaceEdit edit = new ReplaceEdit(startOffset + prefixOffset, range.getLength(), replaceStr_new);
                            textFileChange.setEdit((TextEdit)edit);
                            ReplaceEdit previewEdit = new ReplaceEdit(startOffset, range.getLength(), replaceStr_new);
                            textFileChange.setPreviewEdit((TextEdit)previewEdit);
                            if (!hasOnlyOne) {
                                if (range.isSure()) {
                                    change.add((Change)textFileChange);
                                } else {
                                    unchange.add((Change)textFileChange);
                                }
                            }
                            prefixOffset += replaceStr_new.length() - replaceStr.length();
                        }
                    }
                }
                ++n2;
            }
            this.addUnOrIndentifineCompositeChange(hasOnlyOne, change, unchange, textFileChange, hasChange, hasunChange);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addUnOrIndentifineCompositeChange(boolean hasOnlyOne, CompositeChange change, CompositeChange unchange, TextFileContentChange textFileChange, boolean hasChange, boolean hasunChange) {
        boolean existTextFileChange;
        boolean existChange = change.getChildren().length > 0;
        boolean existUnChange = unchange.getChildren().length > 0;
        boolean bl = existTextFileChange = textFileChange != null;
        if (hasChange) {
            if (hasOnlyOne) {
                if (existTextFileChange) {
                    this.indentifineCompositeChange.add((Change)textFileChange);
                }
            } else if (existChange) {
                this.indentifineCompositeChange.add((Change)change);
            }
        }
        if (hasunChange) {
            if (hasOnlyOne) {
                if (existTextFileChange) {
                    this.undentifineCompositeChange.add((Change)textFileChange);
                }
            } else if (existUnChange) {
                this.undentifineCompositeChange.add((Change)unchange);
            }
        }
    }

    private JSParseRootNode getJSParseRoot(IDocument document) throws Exception {
        JSParseState parseState = new JSParseState(document.get());
        IParseRootNode ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (IParseState)parseState).getRootNode();
        JSParseRootNode root = (JSParseRootNode)ast;
        return root;
    }

    private void computeJSResult(IFile ifile, Match[] matchs, IDocument document, boolean hasOnlyOne) {
        try {
            CompositeChange change = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            CompositeChange unchange = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            unchange.setEnabledShallow(false);
            int prefixOffset = 0;
            TextFileContentChange textFileChange = null;
            boolean hasChange = false;
            boolean hasunChange = false;
            Set<String> htmlSet = JSFileReferenceHelper.getReference(ifile.getProject(), ifile.getProjectRelativePath().toString());
            Match[] matchArray = matchs;
            int n = matchs.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                RefactorIRange range = this.getJSIRange(ifile, document, match.getOffset(), htmlSet);
                if (range != null) {
                    String replaceStr = document.get(range.getStartingOffset(), range.getLength());
                    int startOffset = range.getStartingOffset();
                    textFileChange = new TextFileContentChange(this.oldName, ifile);
                    String replaceStr_new = "";
                    if (range.isSure()) {
                        hasChange = true;
                        for (String htmlPath : htmlSet) {
                            htmlPath = htmlPath.replace("\\", "/");
                            String resolvePath = URIUtils.resolveURI((String)(htmlPath = htmlPath.replace("\\\\", "/")), (String)replaceStr);
                            boolean isExist = this.checkResolvePathInSrcListFile(resolvePath, this.srcListFile);
                            if (!isExist) continue;
                            replaceStr_new = this.getFolderRelativePath(replaceStr, htmlPath);
                            break;
                        }
                        if (!replaceStr.equals(replaceStr_new)) {
                            ReplaceEdit edit = new ReplaceEdit(startOffset + prefixOffset, range.getLength(), replaceStr_new);
                            textFileChange.setEdit((TextEdit)edit);
                            ReplaceEdit previewEdit = new ReplaceEdit(startOffset, range.getLength(), replaceStr_new);
                            textFileChange.setPreviewEdit((TextEdit)previewEdit);
                            if (!hasOnlyOne) {
                                if (range.isSure()) {
                                    change.add((Change)textFileChange);
                                } else {
                                    unchange.add((Change)textFileChange);
                                }
                            }
                            prefixOffset += replaceStr_new.length() - replaceStr.length();
                        }
                    }
                }
                ++n2;
            }
            this.addUnOrIndentifineCompositeChange(hasOnlyOne, change, unchange, textFileChange, hasChange, hasunChange);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void computeHTMLResult(IFile ifile, Match[] matchs, IDocument document, boolean hasOnlyOne) {
        try {
            CompositeChange change = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            CompositeChange unchange = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            unchange.setEnabledShallow(false);
            int prefixOffset = 0;
            TextFileContentChange textFileChange = null;
            boolean hasChange = false;
            boolean hasUnChange = false;
            Match[] matchArray = matchs;
            int n = matchs.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                RefactorIRange range = this.getHTMLIRange(ifile, document, match);
                if (range != null) {
                    String replaceStr = document.get(range.getStartingOffset(), range.getLength());
                    int startOffset = range.getStartingOffset();
                    textFileChange = new TextFileContentChange(this.oldName, ifile);
                    String replaceStr_new = "";
                    if (range.isSure()) {
                        hasChange = true;
                        replaceStr_new = this.getFolderRelativePath(replaceStr, ifile.getProjectRelativePath().toString());
                        if (!replaceStr.equals(replaceStr_new)) {
                            ReplaceEdit edit = new ReplaceEdit(startOffset + prefixOffset, range.getLength(), replaceStr_new);
                            textFileChange.setEdit((TextEdit)edit);
                            ReplaceEdit previewEdit = new ReplaceEdit(startOffset, range.getLength(), replaceStr_new);
                            textFileChange.setPreviewEdit((TextEdit)previewEdit);
                            if (!hasOnlyOne) {
                                if (range.isSure()) {
                                    change.add((Change)textFileChange);
                                } else {
                                    unchange.add((Change)textFileChange);
                                }
                            }
                            prefixOffset += replaceStr_new.length() - replaceStr.length();
                        }
                    }
                }
                ++n2;
            }
            this.addUnOrIndentifineCompositeChange(hasOnlyOne, change, unchange, textFileChange, hasChange, hasUnChange);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private String getFolderRelativePath(String replaceStr, String srcFilePath) {
        String resolvePath = "";
        if (StringUtil.isNotBlank((String)srcFilePath)) {
            resolvePath = replaceStr.startsWith("/") ? replaceStr : URIUtils.resolveURI((String)srcFilePath, (String)replaceStr);
            if (this.newName.equals("/")) {
                this.newName = "";
            }
            resolvePath = StringUtil.isBlank((String)this.oldName) ? String.valueOf(this.newName) + resolvePath : resolvePath.replace(this.oldName, this.newName);
            resolvePath = URIUtils.relativeURI((String)srcFilePath, (String)resolvePath);
        }
        return resolvePath;
    }

    private RefactorIRange getHTMLIRange(IFile ifile, IDocument document, Match match) throws BadLocationException {
        String resolvePath;
        boolean isExist;
        int srcIndex;
        ITypedRegion partition = document.getPartition(match.getOffset());
        String wholeTag = document.get(partition.getOffset(), partition.getLength());
        String tagvalue = "";
        String type = partition.getType();
        int startOffset = 0;
        int endOffset = 0;
        if (type.equals("__js_string_double") || type.equals("__js_string_single")) {
            tagvalue = this.getHTML_JSTagValue(wholeTag);
            if (StringUtil.isBlank((String)tagvalue)) {
                tagvalue = wholeTag;
            }
            if (tagvalue.startsWith("'") || tagvalue.startsWith("\"")) {
                tagvalue = tagvalue.substring(1, tagvalue.length() - 1);
            }
            if (StringUtil.isNotBlank((String)tagvalue) && (srcIndex = this.getSrcIndex(wholeTag, tagvalue)) > 0) {
                startOffset = partition.getOffset() + srcIndex;
                endOffset = startOffset + tagvalue.length() - 1;
            }
        } else if (type.equals("__css_string_double") || type.equals("__css_string_single")) {
            tagvalue = wholeTag.substring(1, wholeTag.length() - 1);
            srcIndex = this.getSrcIndex(wholeTag, tagvalue);
            if (srcIndex > 0) {
                startOffset = partition.getOffset() + srcIndex;
                endOffset = startOffset + tagvalue.length() - 1;
            }
        } else if (type.equals("__css___dftl_partition_content_type")) {
            int offset = match.getOffset() - partition.getOffset();
            ParseState parseState = new ParseState(wholeTag);
            try {
                int srcIndex2;
                IParseNode node;
                String nodeValue;
                IParseRootNode ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.css", (IParseState)parseState).getRootNode();
                CSSParseRootNode root = null;
                if (ast instanceof CSSParseRootNode && StringUtil.isNotBlank((String)(tagvalue = this.getCSSTagValue(nodeValue = (node = (root = (CSSParseRootNode)ast).getNodeAtOffset(offset)).getText()))) && (srcIndex2 = this.getSrcIndex(wholeTag, tagvalue)) > 0) {
                    startOffset = partition.getOffset() + srcIndex2;
                    endOffset = startOffset + tagvalue.length() - 1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            tagvalue = this.getHTMLTagValue(wholeTag);
            if (StringUtil.isNotBlank((String)tagvalue) && (srcIndex = this.getSrcIndex(wholeTag, tagvalue)) > 0) {
                startOffset = partition.getOffset() + srcIndex;
                endOffset = startOffset + tagvalue.length() - 1;
            }
        }
        if (StringUtil.isNotBlank((String)tagvalue) && (isExist = this.checkResolvePathInSrcListFile(resolvePath = URIUtils.resolveURI((String)ifile.getProjectRelativePath().toString(), (String)tagvalue), this.srcListFile))) {
            return new RefactorIRange(startOffset, endOffset, ifile, true);
        }
        return null;
    }

    private RefactorIRange getCSSIRange(IFile ifile, IDocument document, Match match, CSSParseRootNode root) {
        String value;
        RefactorIRange range = null;
        IParseNode node = root.getNodeAtOffset(match.getOffset());
        String tagValue = node.getText();
        int startOffset = node.getStartingOffset();
        if (StringUtil.isNotBlank((String)tagValue) && StringUtil.isNotBlank((String)(value = this.getCSSTagValue(tagValue)))) {
            startOffset += tagValue.indexOf(value);
            String resolvePath = URIUtils.resolveURI((String)ifile.getProjectRelativePath().toString(), (String)value);
            boolean isExist = this.checkResolvePathInSrcListFile(resolvePath, this.srcListFile);
            if (isExist) {
                int endOffset = startOffset + value.length() - 1;
                return new RefactorIRange(startOffset, endOffset, ifile, true);
            }
        }
        return range;
    }

    private RefactorIRange getJSIRange(IFile ifile, IDocument document, int offset, Set<String> htmlSet) {
        RefactorIRange range = null;
        try {
            String wholeTag;
            ITypedRegion partition = document.getPartition(offset);
            if (("__js_string_single".equals(partition.getType()) || "__js_string_double".equals(partition.getType())) && StringUtil.isNotBlank((String)(wholeTag = document.get(partition.getOffset(), partition.getLength()))) && (wholeTag.startsWith("'") || wholeTag.startsWith("\""))) {
                String tagValue_ = wholeTag.substring(1, wholeTag.length() - 1);
                String value = this.getHTML_JSTagValue(tagValue_);
                if (StringUtil.isBlank((String)value)) {
                    value = tagValue_;
                }
                if (value.startsWith("'") || value.startsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                if (StringUtil.isNotBlank((String)value)) {
                    boolean isExist = false;
                    for (String htmlPath : htmlSet) {
                        String resolvePath = URIUtils.resolveURI((String)htmlPath, (String)value);
                        isExist = this.checkResolvePathInSrcListFile(resolvePath, this.srcListFile);
                        if (isExist) break;
                    }
                    if (isExist) {
                        int srcindex = this.getSrcIndex(wholeTag, value);
                        int startOffset = partition.getOffset() + srcindex;
                        int endOffset = startOffset + value.length() - 1;
                        return new RefactorIRange(startOffset, endOffset, ifile, true);
                    }
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return range;
    }

    private boolean checkResolvePathInSrcListFile(String resolvePath, List<IFile> srcListFile) {
        for (IFile iFile : srcListFile) {
            if (iFile == null || !iFile.getProjectRelativePath().toString().equals(resolvePath)) continue;
            return true;
        }
        return false;
    }

    private int getSrcIndex(String wholeTag, String srcName) {
        if (StringUtil.isBlank((String)srcName)) {
            return 0;
        }
        int srcIndex = wholeTag.indexOf(srcName);
        return srcIndex;
    }

    private String getHTMLTagValue(String wholeTag) {
        String regix = "";
        String srcvalue = "";
        String[] stringArray = RefactorUtils.HTML_SRC_ATTRIBUTE;
        int n = RefactorUtils.HTML_SRC_ATTRIBUTE.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            regix = String.valueOf(tag) + "[\\s]*=[\\s]*[\"']([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";
            srcvalue = RegularUtils.match((String)regix, (String)wholeTag, (int)1);
            if (StringUtil.isNotBlank((String)srcvalue)) {
                return srcvalue;
            }
            regix = String.valueOf(tag) + "[\\s]*=[\\s]*([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";
            srcvalue = RegularUtils.match((String)regix, (String)wholeTag, (int)1);
            if (StringUtil.isNotBlank((String)srcvalue)) {
                return srcvalue;
            }
            ++n2;
        }
        return "";
    }

    private String getHTML_JSTagValue(String wholeTag) {
        String regix = "";
        String srcvalue = "";
        String[] stringArray = RefactorUtils.JS_SRC_ATTRIBUTE;
        int n = RefactorUtils.JS_SRC_ATTRIBUTE.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            regix = String.valueOf(tag) + "[\\s]*=[\\s]*[\"']([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";
            srcvalue = RegularUtils.match((String)regix, (String)wholeTag, (int)1);
            if (StringUtil.isNotBlank((String)srcvalue)) {
                return srcvalue;
            }
            ++n2;
        }
        return "";
    }

    private String getCSSTagValue(String tagValue) {
        String regix = "";
        String srcvalue = "";
        String[] stringArray = RefactorUtils.CSS_SRC_ATTRIBUTE;
        int n = RefactorUtils.CSS_SRC_ATTRIBUTE.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            regix = String.valueOf(tag) + "[\\s]*\\([\\s]*([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\\)]";
            srcvalue = RegularUtils.match((String)regix, (String)tagValue, (int)1);
            if (StringUtil.isNotBlank((String)srcvalue)) {
                return srcvalue;
            }
            ++n2;
        }
        return "";
    }

    private boolean checkFile(IFile file) {
        if (file == null || !file.exists()) {
            return false;
        }
        String ext = file.getFileExtension();
        if (!this.extendList.contains(ext)) {
            return false;
        }
        String filePath = file.getProjectRelativePath().toString();
        for (String excludeFolder : this.excludeFolderList) {
            if (!filePath.startsWith(excludeFolder)) continue;
            return false;
        }
        return true;
    }

    class ParsJSTreeWalker
    extends JSTreeWalker {
        List<RefactorIRange> ranges = new ArrayList<RefactorIRange>();
        IFile ifile;
        IDocument document;
        Set<String> htmlSet;
        String projectPath;

        public ParsJSTreeWalker(IFile ifile, IDocument document) {
            this.ifile = ifile;
            this.document = document;
            this.htmlSet = JSFileReferenceHelper.getReference(ifile.getProject(), ifile.getProjectRelativePath().toString());
            this.projectPath = ifile.getProject().getLocation().toString();
        }

        public void visit(JSStringNode node) {
            String nodeText = node.getText();
            if (StringUtil.isNotBlank((String)nodeText)) {
                if (nodeText.startsWith("'") || nodeText.startsWith("\"")) {
                    nodeText = nodeText.substring(1);
                }
                if (nodeText.endsWith("'") || nodeText.endsWith("\"")) {
                    nodeText = nodeText.substring(0, nodeText.length() - 1);
                }
                for (String htmlPath : this.htmlSet) {
                    String resolvePath = "";
                    String srcValue = "";
                    resolvePath = nodeText.startsWith("/") ? nodeText : URIUtils.resolveURI((String)htmlPath, (String)nodeText);
                    srcValue = nodeText;
                    if (StringUtil.isBlank((String)resolvePath)) {
                        String content;
                        srcValue = content = this.getFromNodeText(nodeText);
                        resolvePath = this.getResolvePath(content, resolvePath);
                    }
                    if (!StringUtil.isNotBlank((String)resolvePath) || !RefactorMoveFileParticipant.this.checkPathExist(resolvePath, this.projectPath)) continue;
                    this.getIRange(srcValue, node);
                }
            }
            super.visit(node);
        }

        private void getIRange(String srcValue, JSStringNode node) {
            int startOffset = node.getStartingOffset();
            int length = srcValue.length();
            String nodeText = node.getText();
            int index = nodeText.indexOf(srcValue);
            if (index <= -1) {
                return;
            }
            RefactorIRange range = new RefactorIRange(startOffset += index, startOffset + length - 1, this.ifile, true);
            this.ranges.add(range);
        }

        private String getResolvePath(String nodeText, String resolvePath) {
            for (String htmlPath_ : this.htmlSet) {
                resolvePath = nodeText.startsWith("/") ? nodeText : URIUtils.resolveURI((String)htmlPath_, (String)nodeText);
                if (StringUtil.isNotBlank((String)resolvePath) && RefactorMoveFileParticipant.this.checkPathExist(resolvePath, this.projectPath)) break;
            }
            return resolvePath;
        }

        private String getFromNodeText(String nodeText) {
            String regix = "";
            String srcvalue = "";
            String content = "";
            String[] stringArray = RefactorUtils.HTML_SRC_ATTRIBUTE;
            int n = RefactorUtils.HTML_SRC_ATTRIBUTE.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                regix = String.valueOf(tag) + "[\\s]*=[\\s]*[\"']([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";
                srcvalue = RegularUtils.match((String)regix, (String)nodeText, (int)1);
                if (StringUtil.isNotBlank((String)srcvalue)) {
                    content = srcvalue;
                    break;
                }
                regix = String.valueOf(tag) + "[\\s]*=[\\s]*([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";
                srcvalue = RegularUtils.match((String)regix, (String)nodeText, (int)1);
                if (StringUtil.isNotBlank((String)srcvalue)) {
                    content = srcvalue;
                    break;
                }
                ++n2;
            }
            return content;
        }

        public List<RefactorIRange> getIRanges() {
            return this.ranges;
        }
    }
}

