/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.js.refactoring;

import com.aptana.editor.html.ext.HTMLScript;
import com.aptana.editor.js.hyperlink.JSIdentifierCollector;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.pandora.refactor.core.index.JSFileReferenceHelper;
import com.pandora.refactor.core.js.inferrer.JSInstanceInferrer;
import com.pandora.refactor.core.js.refactoring.AbstractJSRefactorStrategy;
import com.pandora.refactor.core.js.refactoring.JSRefactorRegion;
import com.pandora.refactor.core.refactoring.IRefactorStrategy;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class JSObjectRefactorStrategy
extends AbstractJSRefactorStrategy
implements IRefactorStrategy {
    protected HTMLScript htmlScript = null;
    protected JSFunctionNode objNode = null;
    protected Set<String> symbols = new HashSet<String>();

    @Override
    public void searchLocalRefactorNode(IParseNode node, String identification, RefactorContextInfo refactorInfo, IFile targetFile) {
        if (node instanceof JSIdentifierNode) {
            JSIdentifierNode identifierNode = (JSIdentifierNode)node;
            this.addResult(refactorInfo, identifierNode, targetFile);
            this.objNode = this.getObjectNode(identifierNode);
            if (this.objNode != null) {
                JSInstanceInferrer instanceInferrer = new JSInstanceInferrer(this.objNode);
                instanceInferrer.visit((JSParseRootNode)identifierNode.getRootNode());
                this.symbols.addAll(instanceInferrer.getInstanceSet());
            }
            JSIdentifierCollector identifierCollector = new JSIdentifierCollector(identifierNode.getText());
            identifierCollector.visit((JSParseRootNode)identifierNode.getRootNode());
            List identifierNodes = identifierCollector.getIdentifiers();
            this.addIdentificationNode(identifierNodes, refactorInfo, targetFile, false);
        }
    }

    protected JSFunctionNode getObjectNode(JSIdentifierNode identifierNode) {
        if (identifierNode == null) {
            return null;
        }
        JSFunctionNode funcNode = null;
        JSIdentifierNode currentNode = identifierNode;
        while (!(currentNode instanceof JSFunctionNode)) {
            if (!(currentNode.getParent() instanceof JSNode)) break;
            currentNode = (JSNode)currentNode.getParent();
        }
        if (currentNode instanceof JSFunctionNode) {
            funcNode = (JSFunctionNode)currentNode;
        }
        return funcNode;
    }

    protected void addIdentificationNode(List<JSIdentifierNode> identifierNodes, RefactorContextInfo refactorInfo, IFile targetFile, boolean isHTML) {
        for (JSIdentifierNode idNode : identifierNodes) {
            JSGetPropertyNode getPropertyNode;
            if (!(idNode.getParent() instanceof JSGetPropertyNode) || (getPropertyNode = (JSGetPropertyNode)idNode.getParent()).getRightHandSide() != idNode || getPropertyNode.getLeftHandSide() instanceof JSThisNode || "prototype".equals(getPropertyNode.getLeftHandSide().getText())) continue;
            if (isHTML) {
                if (this.htmlScript == null) continue;
                this.addResult(refactorInfo, idNode, targetFile, this.htmlScript);
                continue;
            }
            this.addResult(refactorInfo, idNode, targetFile);
        }
    }

    @Override
    public void searchOutsideRefactorNode(IFile targetJSFile, IParseNode node, String identification, RefactorContextInfo refactorInfo) {
        if (targetJSFile == null) {
            return;
        }
        IProject project = targetJSFile.getProject();
        String keyPath = targetJSFile.getLocation().toString().substring(project.getLocation().toString().length());
        if (keyPath.startsWith("/")) {
            keyPath = keyPath.substring(1);
        }
        Set<String> htmlFiles = JSFileReferenceHelper.getReference(project, keyPath);
        for (String htmlFile : htmlFiles) {
            IFile ihtmlFile = project.getFile(htmlFile);
            if (!ihtmlFile.exists()) continue;
            this.searchHTMLScriptRefactorNode(identification, refactorInfo, ihtmlFile);
        }
    }

    private void searchHTMLScriptRefactorNode(String identification, RefactorContextInfo refactorInfo, IFile ihtmlFile) {
        try {
            this.htmlScript = this.getHTMLScript(ihtmlFile);
            JSParseState parseState = new JSParseState(this.htmlScript.getSource(), 0, true, true);
            IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (IParseState)parseState).getRootNode();
            if (rootNode instanceof JSParseRootNode) {
                if (this.objNode != null) {
                    JSInstanceInferrer instanceInferrer = new JSInstanceInferrer(this.objNode);
                    instanceInferrer.visit((JSParseRootNode)rootNode);
                    this.symbols.addAll(instanceInferrer.getInstanceSet());
                }
                JSIdentifierCollector identifierCollector = new JSIdentifierCollector(identification);
                identifierCollector.visit((JSParseRootNode)rootNode);
                this.addIdentificationNode(identifierCollector.getIdentifiers(), refactorInfo, ihtmlFile, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void filterRefactorNode(RefactorContextInfo refactorInfo) {
        ArrayList<JSRefactorRegion> deleteRegions = new ArrayList<JSRefactorRegion>();
        List<JSRefactorRegion> results = refactorInfo.getResults();
        for (JSRefactorRegion refactorRegion : results) {
            JSIdentifierNode identifierNode = refactorRegion.getRefactorNode();
            if (!(identifierNode.getParent() instanceof JSGetPropertyNode)) {
                deleteRegions.add(refactorRegion);
                continue;
            }
            JSGetPropertyNode getNode = (JSGetPropertyNode)identifierNode.getParent();
            IParseNode parseNode = getNode.getLeftHandSide();
            if (!(parseNode instanceof JSThisNode)) {
                if (!this.symbols.contains(parseNode.getText())) {
                    refactorRegion.setMakeSure(false);
                    continue;
                }
                refactorRegion.setMakeSure(true);
                continue;
            }
            refactorRegion.setMakeSure(true);
        }
        this.executeFilter(refactorInfo, deleteRegions);
    }
}

