/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.js.refactoring;

import com.aptana.core.util.FileUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.ext.FileRange;
import com.aptana.editor.html.ext.HTMLFullScript;
import com.aptana.editor.html.ext.HTMLPartitionScanner;
import com.aptana.editor.html.ext.HTMLScript;
import com.aptana.editor.js.hyperlink.JSIdentifierCollector;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.pandora.refactor.core.IRefactorSearch;
import com.pandora.refactor.core.RefactorResourceVisitor;
import com.pandora.refactor.core.html.refactoring.IHTMLScriptRefactorStrategy;
import com.pandora.refactor.core.js.refactoring.JSRefactorRegion;
import com.pandora.refactor.core.refactoring.IRefactorStrategy;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public abstract class AbstractJSRefactorStrategy
implements IRefactorStrategy,
IRefactorSearch {
    @Override
    public void searchLocalRefactorNode(IParseNode node, String identification, RefactorContextInfo refactorInfo, IFile targetFile) {
    }

    @Override
    public void searchOutsideRefactorNode(IFile currentFile, IParseNode node, String identification, RefactorContextInfo refactorInfo) {
    }

    @Override
    public void filterRefactorNode(RefactorContextInfo refactorInfo) {
    }

    @Override
    public void searchFile(IFile file, RefactorContextInfo refactorInfo) {
        if (file.exists()) {
            if ("js".equals(file.getFileExtension())) {
                this.refactorJSFile(file, refactorInfo);
            } else if ("html".equals(file.getFileExtension())) {
                this.refactorHTMLFile(file, refactorInfo);
            }
        }
    }

    private void refactorHTMLFile(IFile file, RefactorContextInfo refactorInfo) {
        try {
            HTMLScript htmlScript = this.getHTMLScript(file, false);
            JSParseState parseState = new JSParseState(htmlScript.getSource(), 0, true, true);
            IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (IParseState)parseState).getRootNode();
            JSIdentifierCollector identifierCollector = new JSIdentifierCollector(refactorInfo.getOldName());
            identifierCollector.visit((JSParseRootNode)rootNode);
            List idnodes = identifierCollector.getIdentifiers();
            for (JSIdentifierNode node : idnodes) {
                this.addResult(refactorInfo, node, file, htmlScript);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refactorJSFile(IFile file, RefactorContextInfo refactorInfo) {
        try {
            File realFile = FileUtil.convertIFileToFile((IFile)file);
            String source = FileUtils.readFileToString((File)realFile);
            JSParseState parseState = new JSParseState(source, 0, true, true);
            IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (IParseState)parseState).getRootNode();
            JSIdentifierCollector identifierCollector = new JSIdentifierCollector(refactorInfo.getOldName());
            identifierCollector.visit((JSParseRootNode)rootNode);
            List idnodes = identifierCollector.getIdentifiers();
            for (JSIdentifierNode node : idnodes) {
                this.addResult(refactorInfo, node, file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected List<? extends IRange> sort(List<? extends IRange> identifierNodes) {
        if (identifierNodes == null || identifierNodes.isEmpty()) {
            return identifierNodes;
        }
        IRange[] regionArr = identifierNodes.toArray(new IRange[identifierNodes.size()]);
        Arrays.sort(regionArr, new Comparator<IRange>(){

            @Override
            public int compare(IRange o1, IRange o2) {
                return o1.getStartingOffset() - o2.getStartingOffset();
            }
        });
        return Arrays.asList(regionArr);
    }

    protected void globalSearchRefactorNode(RefactorContextInfo refactorInfo, JSIdentifierNode identifierNode) {
        RefactorResourceVisitor resourceVisitor = new RefactorResourceVisitor(this, refactorInfo);
        try {
            resourceVisitor.visit((IResource)refactorInfo.getCurrentProject());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected HTMLScript getHTMLScript(IFile file) throws IOException {
        return this.getHTMLScript(file, true);
    }

    protected HTMLScript getHTMLScript(IFile file, boolean parseReference) throws IOException {
        File localFile = FileUtil.convertIFileToFile((IFile)file);
        String contents = FileUtils.readFileToString((File)localFile);
        Document doc = new Document(contents);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new HTMLPartitionScanner(), new String[]{"__html_comment", "__html_quote_tag", "__html_single_tag", "__html_nest_tag"});
        partitioner.connect((IDocument)doc);
        doc.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        HTMLFullScript script = new HTMLFullScript((IDocument)doc, 0, file, parseReference);
        return script;
    }

    protected void addResult(RefactorContextInfo refactorInfo, JSIdentifierNode refactorNode, IFile targetFile) {
        if (this instanceof IHTMLScriptRefactorStrategy) {
            IHTMLScriptRefactorStrategy htmlScriptRefactorStrategy = (IHTMLScriptRefactorStrategy)((Object)this);
            this.addResult(refactorInfo, refactorNode, targetFile, htmlScriptRefactorStrategy.getHTMLScript());
            return;
        }
        JSRefactorRegion region = new JSRefactorRegion(refactorNode);
        region.setStartOffset(refactorNode.getStartingOffset());
        region.setEndOffset(refactorNode.getEndingOffset());
        region.setNewName(refactorInfo.getNewName());
        region.setOldName(refactorInfo.getOldName());
        region.setTargetFile(targetFile);
        if (region.getTargetFile() != null && region.getTargetFile().exists()) {
            refactorInfo.addResult(region);
        }
    }

    protected void addResult(RefactorContextInfo refactorInfo, JSIdentifierNode refactorNode, IFile targetFile, HTMLScript htmlScript) {
        FileRange fileRange = htmlScript.findActualFileRange(refactorNode.getStartingOffset());
        JSRefactorRegion region = new JSRefactorRegion(refactorNode);
        region.setStartOffset(fileRange.getStartingOffset());
        region.setEndOffset(fileRange.getEndingOffset());
        region.setNewName(refactorInfo.getNewName());
        region.setOldName(refactorInfo.getOldName());
        if (StringUtil.isEmpty((String)fileRange.getFileName())) {
            region.setTargetFile(targetFile);
        } else {
            IFile file;
            String fileName = fileRange.getFileName();
            if (fileName.startsWith("file:/")) {
                fileName = fileName.replaceFirst("file:/", "");
                if ((fileName = fileName.substring(targetFile.getProject().getLocation().toString().length())).startsWith("/")) {
                    fileName = fileName.substring(1);
                }
            }
            if ((file = targetFile.getProject().getFile(fileName)).exists()) {
                region.setTargetFile(file);
            }
        }
        if (region.getTargetFile() != null && region.getTargetFile().exists()) {
            refactorInfo.addResult(region);
        }
    }

    protected void executeFilter(RefactorContextInfo refactorInfo, List<JSRefactorRegion> deleteRegions) {
        for (JSRefactorRegion region : deleteRegions) {
            refactorInfo.removeResult(region);
        }
    }
}

