/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.js.inferrer;

import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.hyperlink.JSIdentifierCollector;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSParametersNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.parsing.ast.IParseNode;
import com.pandora.refactor.core.js.inferrer.JSLocalScopeInferrer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InferrerUtils {
    public static boolean containChild(JSNode parentNode, JSNode childNode) {
        JSIdentifierCollector identifierCollector = new JSIdentifierCollector(childNode.getText());
        identifierCollector.visit(parentNode);
        List idnodes = identifierCollector.getIdentifiers();
        for (JSIdentifierNode node : idnodes) {
            if (node != childNode) continue;
            return true;
        }
        return false;
    }

    public static boolean isNodeInTargetScope(JSIdentifierNode idnode, JSIdentifierNode targetNode) {
        JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)targetNode, (int)targetNode.getStartingOffset());
        if (scope == null || idnode == null) {
            return false;
        }
        JSScope jsScope = ParseUtil.getScopeAtOffset((IParseNode)idnode, (int)idnode.getStartingOffset());
        while (jsScope != null) {
            if (jsScope.getRange() == scope.getRange()) {
                return true;
            }
            jsScope = jsScope.getParentScope();
        }
        return false;
    }

    public static List<JSNode> searchDeclarationNodes(JSIdentifierNode identifierNode) {
        if (identifierNode == null) {
            return Collections.emptyList();
        }
        ArrayList<JSNode> resultNodes = new ArrayList<JSNode>();
        JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)identifierNode.getRootNode(), (int)identifierNode.getStartingOffset());
        boolean hasFind = false;
        while (!hasFind) {
            if (scope == null) break;
            JSNode baseNode = null;
            if (scope.getRange() instanceof JSNode) {
                baseNode = (JSNode)scope.getRange();
            }
            JSLocalScopeInferrer localScopeInferrer = new JSLocalScopeInferrer(baseNode, identifierNode.getText());
            if (baseNode == null) {
                localScopeInferrer.visit((JSParseRootNode)identifierNode.getRootNode());
            } else {
                localScopeInferrer.visit(baseNode);
            }
            List<JSIdentifierNode> identifierNodes = localScopeInferrer.getIdentifierNodes();
            for (JSIdentifierNode idNode : identifierNodes) {
                if (idNode.getParent() instanceof JSDeclarationNode && idNode.getParent().getChild(0) == idNode) {
                    hasFind = true;
                    resultNodes.add((JSNode)((JSDeclarationNode)idNode.getParent()));
                    continue;
                }
                if (idNode.getParent() instanceof JSParametersNode) {
                    hasFind = true;
                    resultNodes.add((JSNode)idNode);
                    continue;
                }
                if (!(idNode.getParent() instanceof JSAssignmentNode)) continue;
                resultNodes.add((JSNode)((JSAssignmentNode)idNode.getParent()));
            }
            scope = scope.getParentScope();
        }
        return resultNodes;
    }

    public static JSNode searchDeclarationNode(JSIdentifierNode identifierNode) {
        if (identifierNode == null) {
            return null;
        }
        JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)identifierNode.getRootNode(), (int)identifierNode.getStartingOffset());
        boolean hasFind = false;
        while (!hasFind) {
            if (scope == null) break;
            ArrayList<JSNode> resultNodes = new ArrayList<JSNode>();
            JSNode baseNode = null;
            if (scope.getRange() instanceof JSNode) {
                baseNode = (JSNode)scope.getRange();
                hasFind = InferrerUtils.includeParamsNode(identifierNode, resultNodes, baseNode);
            }
            JSLocalScopeInferrer localScopeInferrer = new JSLocalScopeInferrer(baseNode, identifierNode.getText());
            if (baseNode == null) {
                localScopeInferrer.visit((JSParseRootNode)identifierNode.getRootNode());
            } else {
                localScopeInferrer.visit(baseNode);
            }
            List<JSIdentifierNode> identifierNodes = localScopeInferrer.getIdentifierNodes();
            for (JSIdentifierNode idNode : identifierNodes) {
                if (idNode.getParent() instanceof JSDeclarationNode && idNode.getParent().getChild(0) == idNode) {
                    hasFind = true;
                    resultNodes.add((JSNode)((JSDeclarationNode)idNode.getParent()));
                    continue;
                }
                if (idNode.getParent() instanceof JSParametersNode) {
                    hasFind = true;
                    resultNodes.add((JSNode)idNode);
                    continue;
                }
                if (!(idNode.getParent() instanceof JSFunctionNode)) continue;
                hasFind = true;
                resultNodes.add((JSNode)((JSFunctionNode)idNode.getParent()));
            }
            int offset = -1;
            JSNode targetNode = null;
            if (hasFind) {
                for (JSNode resultNode : resultNodes) {
                    if (resultNode.getStartingOffset() < offset) continue;
                    offset = resultNode.getStartingOffset();
                    targetNode = resultNode;
                }
                return targetNode;
            }
            scope = scope.getParentScope();
        }
        return null;
    }

    protected static boolean includeParamsNode(JSIdentifierNode identifierNode, List<JSNode> resultNodes, JSNode baseNode) {
        boolean hasFind = false;
        if (baseNode.getParent() instanceof JSFunctionNode) {
            IParseNode[] params;
            JSParametersNode paramsNode = (JSParametersNode)((JSFunctionNode)baseNode.getParent()).getParameters();
            IParseNode[] iParseNodeArray = params = paramsNode.getChildren();
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNode param = iParseNodeArray[n2];
                if (param instanceof JSIdentifierNode) {
                    JSIdentifierNode idNode = (JSIdentifierNode)param;
                    if (identifierNode.getText().equals(idNode.getText())) {
                        resultNodes.add((JSNode)idNode);
                        hasFind = true;
                    }
                }
                ++n2;
            }
        }
        return hasFind;
    }
}

