/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.ui;

import com.pandora.core.ui.notifications.AbstractNotification;
import com.pandora.core.ui.notifications.MessageNotification;
import com.pandora.core.ui.notifications.NotificationAction;
import com.pandora.core.ui.notifications.NotificationFactory;
import com.pandora.core.ui.notifications.NotificationSender;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.PluginUtils;
import com.pandora.core.utils.RunInBrowserUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.launcher.core.IJobRunnable;
import com.pandora.launcher.core.android.AndroidLauncher;
import com.pandora.launcher.core.iphone.jna.LibraryFinder;
import com.pandora.launcher.core.listener.DeviceStartupListener;
import com.pandora.launcher.ui.DeviceManagerItem;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class MobileNotFoundDialog
extends Dialog
implements KeyListener {
    public static final int CANCEL_ID = 1001;
    public static final int ANDROID_ID = 1002;
    public static final int ITUNES_ID = 1003;
    public static final int RUN_ID = 1004;
    public static final int RUN_IN_BROWSER_ID = 1005;
    private static final String HELP_URL = "http://ask.dcloud.net.cn/article/97";
    private static final String SIM_URL = "http://ask.dcloud.net.cn/article/151";
    private boolean canRun = false;
    private IResource path = null;
    private Label showConnectLabel;
    private boolean isRunnabled;
    Color redF = null;
    Color greenF = null;

    public boolean close() {
        if (this.showConnectLabel != null) {
            this.showConnectLabel.dispose();
            this.showConnectLabel = null;
        }
        AndroidLauncher androidLauncher = DeviceStartupListener.getAndroidLauncher();
        androidLauncher.setJobRunnable(null);
        return super.close();
    }

    public MobileNotFoundDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Object element;
                Object object;
                IEditorPart part;
                ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
                ISelection selection = selectionService.getSelection();
                if (selection instanceof ITextSelection && (part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null && (object = part.getEditorInput().getAdapter(IFile.class)) != null && object instanceof IFile) {
                    MobileNotFoundDialog.this.canRun = RunInBrowserUtil.isRunnable((String)((IFile)object).getName());
                    if (MobileNotFoundDialog.this.canRun) {
                        MobileNotFoundDialog.this.path = (IResource)((IFile)object);
                        return;
                    }
                }
                if ((selection = selectionService.getSelection("org.eclipse.ui.navigator.ProjectExplorer")) instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && element instanceof IFile) {
                    IResource resource = (IResource)element;
                    MobileNotFoundDialog.this.canRun = RunInBrowserUtil.isRunnable((String)resource.getName());
                    if (MobileNotFoundDialog.this.canRun) {
                        MobileNotFoundDialog.this.path = resource;
                        return;
                    }
                }
            }
        });
        if (this.canRun) {
            Button runBtn = this.createButton(parent, 1005, "\u672c\u5730\u6d4f\u89c8\u5668\u8fd0\u884c(&B)", false);
            runBtn.addKeyListener((KeyListener)this);
        }
        Button reRunBtn = this.createButton(parent, 1004, "\u91cd\u8bd5(&R)", false);
        reRunBtn.addKeyListener((KeyListener)this);
        Button btn = this.createButton(parent, 1001, "\u53d6\u6d88(&C)", true);
        btn.setFocus();
        btn.addKeyListener((KeyListener)this);
    }

    protected Control createDialogArea(final Composite parent) {
        parent.getShell().setText("\u8fd0\u884c\u63d0\u793a");
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout(null);
        CLabel lblNewLabel = new CLabel(composite, 0);
        lblNewLabel.setImage(ResourceManager.getPluginImage((String)"com.pandora.ui", (String)"icons/warning_st_obj.gif"));
        lblNewLabel.setBounds(10, 10, 317, 23);
        lblNewLabel.setText("\u6ca1\u6709\u68c0\u6d4b\u5230\u624b\u673a\u8fde\u63a5\uff0c\u53ef\u80fd\u7684\u539f\u56e0\u5982\u4e0b\uff1a");
        int x = 43;
        int y = 40;
        int prefixY = 2;
        Label lblAndroid = new Label(composite, 0);
        lblAndroid.setBounds(33, y, 90, 15);
        lblAndroid.setText("Android\u624b\u673a\uff1a");
        lblAndroid.pack();
        y = lblAndroid.getBounds().y + lblAndroid.getBounds().height + prefixY;
        CLabel lblNewLabel_0 = new CLabel(composite, 0);
        lblNewLabel_0.setBounds(x, y, 274, 17);
        lblNewLabel_0.setText("1\u3001\u786e\u8ba4\u624b\u673a\u5df2\u901a\u8fc7\u6570\u636e\u7ebf\u8fde\u63a5\u7535\u8111\uff1b");
        lblNewLabel_0.pack();
        y = lblNewLabel_0.getBounds().y + lblNewLabel_0.getBounds().height + prefixY;
        String l1 = "\u786e\u8ba4\u624b\u673a\u8bbe\u7f6e\u4e2dUSB\u8c03\u8bd5\u6a21\u5f0f\u5df2\u5f00\u542f\uff1b";
        String l2 = "\u5982\u624b\u673a\u5c4f\u5e55\u5f39\u51fa\u9700\u4fe1\u4efb\u672c\u8ba1\u7b97\u673a\u7684\u8be2\u95ee\uff0c\u8bf7\u540c\u610f\u8be5\u6388\u6743\u3002";
        if (PlatformUtil.isWindows()) {
            Link lblNewLabel_1 = new Link(composite, 0);
            lblNewLabel_1.setBounds(x + 3, y, 274, 17);
            lblNewLabel_1.setText("2\u3001\u786e\u8ba4\u5df2\u5b89\u88c5Android\u624b\u673a\u52a9\u624b\uff0c\u5e76\u4e14Android\u624b\u673a\u52a9\u624b\u80fd\u6b63\u5e38\u8fde\u63a5\u624b       \n\u673a\uff0c\u82e5\u672a\u5b89\u88c5\u70b9\u51fb<a>\u4e0b\u8f7dAndroid\u624b\u673a\u52a9\u624b(&A) </a>\uff1b");
            lblNewLabel_1.pack();
            lblNewLabel_1.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MobileNotFoundDialog.this.androidPressed(false);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            lblNewLabel_1.addKeyListener((KeyListener)this);
            y = lblNewLabel_1.getBounds().y + lblNewLabel_1.getBounds().height + prefixY;
            CLabel lblNewLabel_2 = new CLabel(composite, 0);
            lblNewLabel_2.setText("3\u3001" + l1);
            lblNewLabel_2.setBounds(x, y, 274, 17);
            lblNewLabel_2.pack();
            y = lblNewLabel_2.getBounds().y + lblNewLabel_2.getBounds().height;
            CLabel lblNewLabel_3 = new CLabel(composite, 0);
            lblNewLabel_3.setText("4\u3001" + l2);
            lblNewLabel_3.setBounds(x, y, 274, 17);
            lblNewLabel_3.pack();
            y = lblNewLabel_3.getBounds().y + lblNewLabel_3.getBounds().height + prefixY;
        } else {
            CLabel lblNewLabel_2 = new CLabel(composite, 0);
            lblNewLabel_2.setText("2\u3001" + l1);
            lblNewLabel_2.setBounds(x, y, 274, 17);
            lblNewLabel_2.pack();
            y = lblNewLabel_2.getBounds().y + lblNewLabel_2.getBounds().height + prefixY;
            CLabel lblNewLabel_3 = new CLabel(composite, 0);
            lblNewLabel_3.setText("3\u3001" + l2);
            lblNewLabel_3.setBounds(x, y, 274, 17);
            lblNewLabel_3.pack();
            y = lblNewLabel_3.getBounds().y + lblNewLabel_3.getBounds().height + prefixY;
        }
        Label lblIos = new Label(composite, 0);
        lblIos.setText("iOS\u624b\u673a\uff1a");
        lblIos.setBounds(33, y + 8, 64, 15);
        lblIos.pack();
        y = lblIos.getBounds().y + lblIos.getBounds().height + prefixY;
        CLabel lblIositunes = new CLabel(composite, 0);
        lblIositunes.setText("1\u3001\u786e\u8ba4\u624b\u673a\u5df2\u901a\u8fc7\u6570\u636e\u7ebf\u8fde\u63a5\u7535\u8111\uff1b");
        lblIositunes.setBounds(x, y, 213, 17);
        lblIositunes.pack();
        y = lblIositunes.getBounds().y + lblIositunes.getBounds().height + prefixY;
        if (PlatformUtil.isWindows()) {
            Link lblIositunes1 = new Link(composite, 64);
            lblIositunes1.setText("2\u3001\u786e\u8ba4\u5df2\u5b89\u88c5iTunes\uff0c\u5e76\u4e14iTunes\u80fd\u6b63\u5e38\u8fde\u63a5\u624b\u673a\uff0c\u82e5\u672a\u5b89\u88c5\u70b9\u51fb\n<a>\u4e0b\u8f7diTunes(&T)</a>\uff0c\u5982\u679c\u662f64\u4f4d\u7684Windows\u7cfb\u7edf\u8fd8\u9700<a>\u5b89\u88c5iOS\u8fde\u63a5\u63d2\u4ef6(&I)</a>\n\u6216<a>\u4e0b\u8f7diTools(&O)</a>\u5e76\u5b89\u88c5\uff1b");
            lblIositunes1.setBounds(x + 3, y, 213, 17);
            lblIositunes1.pack();
            y = lblIositunes1.getBounds().y + lblIositunes1.getBounds().height + prefixY;
            lblIositunes1.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (e == null) {
                        return;
                    }
                    String text = e.text;
                    if (StringUtil.isBlank((String)text)) {
                        return;
                    }
                    MobileNotFoundDialog.this.itunesPressed(false, text);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            lblIositunes1.addKeyListener((KeyListener)this);
            CLabel lblIositunes2 = new CLabel(composite, 0);
            lblIositunes2.setText("3\u3001" + l2);
            lblIositunes2.setBounds(x, y, 213, 17);
            lblIositunes2.pack();
            y = lblIositunes2.getBounds().y + lblIositunes2.getBounds().height + prefixY;
        } else {
            CLabel lblIositunes2 = new CLabel(composite, 0);
            lblIositunes2.setText("2\u3001" + l2);
            lblIositunes2.setBounds(x, y, 213, 17);
            lblIositunes2.pack();
            y = lblIositunes2.getBounds().y + lblIositunes2.getBounds().height + prefixY;
        }
        Link simLink = new Link(composite, 0);
        simLink.setBounds(33, y += 8, 69, 17);
        simLink.setText("\u9700\u8981\u5728\u6a21\u62df\u5668\u8fd0\u884c\u8bf7<a>\u70b9\u51fb\u8fd9\u91cc(&S)</a>");
        simLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MobileNotFoundDialog.this.openUrl(MobileNotFoundDialog.SIM_URL);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        simLink.pack();
        simLink.addKeyListener((KeyListener)this);
        y = simLink.getBounds().y + simLink.getBounds().height + prefixY;
        Link link = new Link(composite, 0);
        link.setBounds(33, y + 8, 69, 17);
        link.setText("\u82e5\u8fd8\u6709\u5176\u4ed6\u95ee\u9898\uff0c\u8bf7\u70b9\u51fb<a>\u771f\u673a\u8fd0\u884c\u5e38\u89c1\u6545\u969c\u6392\u9664\u6307\u5357(&F)</a>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MobileNotFoundDialog.this.openUrl(MobileNotFoundDialog.HELP_URL);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        link.pack();
        link.addKeyListener((KeyListener)this);
        y = link.getBounds().y + link.getBounds().height + prefixY;
        AndroidLauncher androidLauncher = DeviceStartupListener.getAndroidLauncher();
        int ly = y;
        if (androidLauncher.isRunning()) {
            androidLauncher.setJobRunnable(new IJobRunnable(){

                public void isRunnabled() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MobileNotFoundDialog.this.isRunnabled = true;
                            if (MobileNotFoundDialog.this.showConnectLabel == null || MobileNotFoundDialog.this.showConnectLabel.isDisposed()) {
                                return;
                            }
                            MobileNotFoundDialog.this.showConnectLabel.setText("\u624b\u673a\u68c0\u6d4b\u5df2\u5b8c\u6210\uff0c\u672a\u68c0\u6d4b\u5230\u624b\u673a\u3002");
                            MobileNotFoundDialog.this.showConnectLabel.pack();
                        }
                    });
                }

                public void hasDevices() {
                    parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MobileNotFoundDialog.this.isRunnabled = true;
                            if (MobileNotFoundDialog.this.showConnectLabel == null || MobileNotFoundDialog.this.showConnectLabel.isDisposed()) {
                                return;
                            }
                            MobileNotFoundDialog.this.showConnectLabel.setText("\u5df2\u68c0\u6d4b\u5230\u624b\u673a\uff0c\u70b9\u51fb[\u91cd\u8bd5]");
                            if ((this).MobileNotFoundDialog.this.greenF == null) {
                                (this).MobileNotFoundDialog.this.greenF = SWTResourceManager.getColor((int)6);
                            }
                            MobileNotFoundDialog.this.showConnectLabel.setForeground((this).MobileNotFoundDialog.this.greenF);
                            MobileNotFoundDialog.this.showConnectLabel.pack();
                        }
                    });
                }
            });
            if (!this.isRunnabled) {
                this.showConnectLabel = new Label(composite, 0);
                this.showConnectLabel.setBounds(33, ly + 10, 90, 15);
                this.showConnectLabel.setText("\u6b63\u5728\u68c0\u6d4b\u624b\u673a\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...");
                if (this.redF == null || this.redF.isDisposed()) {
                    this.redF = SWTResourceManager.getColor((int)3);
                }
                this.showConnectLabel.setForeground(this.redF);
                this.showConnectLabel.pack();
            }
        }
        CLabel blankLabel = new CLabel(composite, 0);
        blankLabel.setBounds(33, y, 69, 10);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1001: {
                this.cancelPressed();
                break;
            }
            case 1004: {
                this.reRun();
                break;
            }
            case 1005: {
                if (this.path == null) break;
                RunInBrowserUtil.runInEnableRunner(null, (IResource)this.path);
                break;
            }
        }
    }

    private void reRun() {
        boolean isOK = DeviceManagerItem.runInDevice(Display.getDefault().getActiveShell(), null, null, null, false);
        if (isOK) {
            this.close();
            DeviceManagerItem.runInDevice(Display.getDefault().getActiveShell(), null, null, null, true);
        } else {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (shell != null && !shell.isDisposed()) {
                MessageNotification msg = NotificationFactory.getInstance().createWorkbenchErrorNotify("\u771f\u673a\u8fd0\u884c\u5931\u8d25", "\u91cd\u8bd5\u5931\u8d25\uff0c\u672a\u68c0\u6d4b\u5230\u624b\u673a\uff01", "launcher.error", new NotificationAction[0]);
                msg.setDelayClose(1000L);
                NotificationSender.getInstance().notify(new AbstractNotification[]{msg});
            }
        }
    }

    private void itunesPressed(boolean needClose, String type) {
        if (StringUtil.isBlank((String)type)) {
            return;
        }
        if (type.toLowerCase().contains("itunes")) {
            this.openUrl("http://www.apple.com.cn/itunes/download/");
        } else if (type.toLowerCase().contains("itools")) {
            this.openUrl("http://www.itools.cn/");
        } else if (type.toLowerCase().contains("ios")) {
            if (LibraryFinder.isWindows64Bit()) {
                if (!LibraryFinder.isPluginInstalled() && !Platform.inDevelopmentMode()) {
                    PluginUtils.notifyInstallPlugin((String)"com.pandora.launcher.resource.win32.x86_64", (String)"com.pandora.launcher.resource.feature", (String)"", (String)"", (String)"", (boolean)false);
                } else {
                    MessageDialog.openInformation((Shell)this.getParentShell(), (String)"\u63d2\u4ef6\u5b89\u88c5", (String)"\u8be5\u63d2\u4ef6\u5df2\u5b89\u88c5\uff0c\u8bf7\u786e\u8ba4");
                }
            } else {
                MessageDialog.openInformation((Shell)this.getParentShell(), (String)"\u63d2\u4ef6\u5b89\u88c5", (String)"\u975e64\u4f4dWindows\u7cfb\u7edf\u65e0\u9700\u5b89\u88c5\uff0c\u8bf7\u786e\u8ba4");
            }
        }
        if (needClose) {
            this.close();
        }
    }

    private void openUrl(String url) {
        try {
            URI uri = new URI(url);
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void androidPressed(boolean needClose) {
        this.openUrl("http://www.360.cn/shoujizhushou/");
        if (needClose) {
            this.close();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.getDialogArea() == null || this.getDialogArea().isDisposed()) {
            return;
        }
        char key = e.character;
        int stateMask = e.stateMask;
        int keycode = e.keyCode;
        int alt = SWT.MOD3;
        if (PlatformUtil.isMac()) {
            alt = SWT.MOD4;
        }
        if (PlatformUtil.isWindows()) {
            if (stateMask == alt && (key == 'F' || key == 'f')) {
                this.openUrl(HELP_URL);
            }
            if (stateMask == alt && (key == 'S' || key == 's')) {
                this.openUrl(SIM_URL);
            }
            if (stateMask == alt && (key == 'T' || key == 't')) {
                this.itunesPressed(false, "itunes");
            }
            if (stateMask == alt && (key == 'O' || key == 'o')) {
                this.itunesPressed(false, "itools");
            }
            if (stateMask == alt && (key == 'A' || key == 'a')) {
                this.androidPressed(false);
            }
        } else {
            if (stateMask == alt && (key == 'F' || key == 'f' || keycode == 102)) {
                this.openUrl(HELP_URL);
            }
            if (stateMask == alt && (key == 'S' || key == 's' || keycode == 115)) {
                this.openUrl(SIM_URL);
            }
            if (stateMask == alt && (key == 'C' || key == 'c' || keycode == 99)) {
                this.buttonPressed(1001);
            }
            if (stateMask == alt && (key == 'R' || key == 'r' || keycode == 114)) {
                this.buttonPressed(1004);
            }
            if (stateMask == alt && (key == 'B' || key == 'b' || keycode == 98)) {
                this.buttonPressed(1005);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

