/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.ui;

import com.pandora.core.log.HBLog;
import com.pandora.launcher.core.HMobileDeviceLauncher;
import com.pandora.launcher.ui.LauncherActivator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;

public class LauncherConsoleParticipant
implements IConsolePageParticipant,
ILaunchesListener2 {
    private Action restartAction;
    private ILaunch launch;

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void init(IPageBookViewPage page, IConsole console) {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        ProcessConsole processConsole = (ProcessConsole)console;
        final String projectName = processConsole.getProcess().getAttribute(HMobileDeviceLauncher.ATTR_PROJECT);
        IProcess process = processConsole.getProcess();
        this.launch = process.getLaunch();
        this.restartAction = new Action("\u91cd\u65b0\u8fd0\u884c", DebugPluginImages.getImageDescriptor((String)"IMG_ELCL_RESTART")){

            public void run() {
                block6: {
                    try {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        if (project == null || !project.exists()) break block6;
                        try {
                            if (LauncherConsoleParticipant.this.launch != null && !LauncherConsoleParticipant.this.launch.isTerminated()) {
                                DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)LauncherConsoleParticipant.this);
                                LauncherConsoleParticipant.this.launch.terminate();
                                while (!LauncherConsoleParticipant.this.launch.isTerminated()) {
                                    Thread.sleep(100L);
                                }
                                Thread.sleep(200L);
                            }
                        }
                        catch (Exception e) {
                            HBLog.logError((Plugin)LauncherActivator.getDefault(), (Throwable)e);
                        }
                        HMobileDeviceLauncher.launch((IProject)project, (String)"run");
                    }
                    catch (Exception e) {
                        HBLog.logError((Plugin)LauncherActivator.getDefault(), (Throwable)e);
                    }
                }
            }
        };
        IToolBarManager manager = page.getSite().getActionBars().getToolBarManager();
        manager.appendToGroup("launchGroup", (IAction)this.restartAction);
    }

    public void dispose() {
        this.launch = null;
        this.restartAction = null;
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesTerminated(ILaunch[] launches) {
        if (this.launch == null || this.restartAction == null) {
            return;
        }
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launche = iLaunchArray[n2];
            if (this.launch == launche) {
                this.restartAction.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_ACT_RUN"));
                break;
            }
            ++n2;
        }
    }
}

