/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.ui;

import com.pandora.core.utils.ProjectUtils;
import com.pandora.launcher.core.DefaultMobileManager;
import com.pandora.launcher.core.HMobileDeviceLauncher;
import com.pandora.launcher.core.IMobileListener;
import com.pandora.launcher.core.LauncherCoreActivator;
import com.pandora.launcher.core.internal.Mobile;
import com.pandora.launcher.core.iphone.jna.LibraryFinder;
import com.pandora.launcher.core.listener.DeviceStartupListener;
import com.pandora.launcher.ui.DeviceManager;
import com.pandora.launcher.ui.LauncherActivator;
import com.pandora.launcher.ui.MobileNotFoundDialog;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceManager;

public class DeviceManagerItem
extends ContributionItem
implements IMobileListener {
    private static ToolItem menuToolItem = null;
    private static Rectangle rectangle = null;

    public DeviceManagerItem() {
    }

    public DeviceManagerItem(String id) {
        super(id);
    }

    public void fill(final Menu menu, int index) {
        super.fill(menu, index);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                DeviceManagerItem.this.startPhoneLauncher(true);
                DeviceManager manager = LauncherActivator.getDefault().getDeviceManager();
                manager.initDevices(menu);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        DeviceManager manager = LauncherActivator.getDefault().getDeviceManager();
        manager.initDevices(menu);
    }

    private void startPhoneLauncher(boolean needCheck) {
        DeviceStartupListener.startAndroidLauncher();
        DeviceStartupListener.startIOSSimulatorLauncher();
        if (!LibraryFinder.LOADED) {
            if (needCheck) {
                DeviceManagerItem.checkIOSPluginInstalled();
            }
            DeviceStartupListener.startIPhoneLauncher();
        }
    }

    public static void checkIOSPluginInstalled() {
        if (!LibraryFinder.LOADED && LibraryFinder.checkPluginInstalled()) {
            LibraryFinder.openInstallDailog();
        }
    }

    public void fill(final ToolBar toolBar, int index) {
        super.fill(toolBar, index);
        final Menu menu = new Menu((Decorations)toolBar.getShell(), 8);
        menuToolItem = new ToolItem(toolBar, 4);
        menuToolItem.setImage(ResourceManager.getPluginImage((String)"com.pandora.launcher.ui", (String)"icons/Run_in_devic.png"));
        menuToolItem.setToolTipText("\u5728\u624b\u673a\u8bbe\u5907\u4e0a\u8fd0\u884c/\u505c\u6b62\u79fb\u52a8\u5e94\u7528");
        menuToolItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 4) {
                    DeviceManagerItem.this.startPhoneLauncher(true);
                    DeviceManagerItem.showMobileMenu(toolBar, menu, menuToolItem);
                } else {
                    DeviceManagerItem.this.startPhoneLauncher(false);
                    DeviceManagerItem.runInDevice(toolBar.getShell(), toolBar, menu, null, true);
                }
            }
        });
        if (rectangle == null && menuToolItem != null && !menuToolItem.isDisposed()) {
            rectangle = menuToolItem.getBounds();
        }
        DefaultMobileManager.getInstance().addMobileListener((IMobileListener)this);
    }

    private static void showMobileMenu(ToolBar toolBar, Menu menu, ToolItem menuToolItem) {
        if (rectangle == null && menuToolItem != null && !menuToolItem.isDisposed()) {
            rectangle = menuToolItem.getBounds();
        }
        Point pt = new Point(DeviceManagerItem.rectangle.x, DeviceManagerItem.rectangle.y + DeviceManagerItem.rectangle.height);
        pt = toolBar.toDisplay(pt);
        menu.setLocation(pt.x, pt.y);
        DeviceManager manager = LauncherActivator.getDefault().getDeviceManager();
        manager.initDevices(menu);
        menu.setVisible(true);
    }

    private static void showMessageBox(String title, String message, Shell shell) {
        MessageBox box = new MessageBox(shell, 8);
        box.setMessage(message);
        box.setText(title);
        box.open();
    }

    private static void showMobileNotFoundDialog() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MobileNotFoundDialog dialog = new MobileNotFoundDialog(Display.getDefault().getActiveShell());
                dialog.open();
            }
        });
    }

    public void connected(Mobile mobile) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void disConnected(Mobile mobile) {
    }

    public void running(IProject project, Mobile mobile) {
    }

    public void stoped(IProject project, Mobile mobile) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean runInDevice(Shell shell, ToolBar toolBar, Menu menu, IProject project, boolean needShow) {
        List mobiles;
        List mobileLists;
        if (toolBar == null || menu == null) {
            DeviceStartupListener.startAndroidLauncher();
        }
        if ((mobileLists = LauncherCoreActivator.getMachineList()) == null || mobileLists.isEmpty()) {
            if (!needShow) return needShow;
            DeviceManagerItem.showMobileNotFoundDialog();
            return true;
        }
        DeviceManagerItem.checkIOSPluginInstalled();
        if (!needShow) {
            return true;
        }
        if (project == null) {
            project = ProjectUtils.getCurrentProject();
        }
        try {
            if (project == null || !project.hasNature("com.pandora.projects.ui.MKeyNature")) {
                DeviceManager manager = LauncherActivator.getDefault().getDeviceManager();
                IProject res = manager.selectProject(shell);
                if (res == null || !res.hasNature("com.pandora.projects.ui.MKeyNature")) {
                    return needShow;
                }
                project = res;
            }
        }
        catch (CoreException coreException) {}
        if ((mobiles = LauncherCoreActivator.getMachineList()) == null || mobiles.isEmpty()) {
            if (!needShow) return needShow;
            DeviceManagerItem.showMobileNotFoundDialog();
            return true;
        } else if (mobiles.size() == 1 || toolBar == null || menu == null) {
            Mobile preMobile = DefaultMobileManager.getCurrentMobile();
            if (preMobile == null || !mobiles.contains(preMobile)) {
                preMobile = (Mobile)mobiles.get(0);
            }
            if (preMobile.getStatus() == DefaultMobileManager.MobileStatus.RUNNING) {
                DefaultMobileManager.getInstance().stoped(project, preMobile);
                return needShow;
            }
            DefaultMobileManager.setCurrentMobile((Mobile)preMobile);
            HMobileDeviceLauncher.launch((IProject)project, (String)"run");
            return true;
        } else {
            DeviceManagerItem.showMobileMenu(toolBar, menu, menuToolItem);
        }
        return true;
    }
}

