/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class ZipUtils {
    public static void zip(String fileDir, String zipFile) throws IOException {
        ZipUtils.zip(fileDir, zipFile, null);
    }

    public static void zip(String fileDir, String zipFile, FileFilter filter) throws IOException {
        File file = new File(fileDir);
        if (!file.exists()) {
            throw new FileNotFoundException(fileDir);
        }
        ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(zipFile));
        zos.setEncoding("utf-8");
        ZipEntry ze = null;
        byte[] buf = new byte[1024];
        int readLen = 0;
        if (file.isFile()) {
            ze = new ZipEntry(file.getName());
            ze.setSize(file.length());
            ze.setTime(file.lastModified());
            zos.putNextEntry(ze);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            while ((readLen = ((InputStream)is).read(buf, 0, 1024)) != -1) {
                zos.write(buf, 0, readLen);
            }
            ((InputStream)is).close();
        } else {
            List<File> fileList = ZipUtils.getSubFiles(file, filter);
            int i = 0;
            while (i < fileList.size()) {
                File f = fileList.get(i);
                if (f.isDirectory()) {
                    String[] strfile = f.list();
                    if (strfile.length == 0) {
                        ze = new ZipEntry(String.valueOf(ZipUtils.getAbsFileName(fileDir, f)) + "/");
                        ze.setSize(f.length());
                        ze.setTime(f.lastModified());
                        zos.putNextEntry(ze);
                    }
                } else {
                    ze = new ZipEntry(ZipUtils.getAbsFileName(fileDir, f));
                    ze.setSize(f.length());
                    ze.setTime(f.lastModified());
                    zos.putNextEntry(ze);
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
                    while ((readLen = ((InputStream)is).read(buf, 0, 1024)) != -1) {
                        zos.write(buf, 0, readLen);
                    }
                    ((InputStream)is).close();
                }
                ++i;
            }
        }
        zos.close();
    }

    public static void unzip(String zipFile, String destdir) throws IOException {
        ZipUtils.unzip(zipFile, destdir, "utf-8");
    }

    public static void unzip(String zipFile, String destdir, String encode) throws IOException {
        ZipFile zip = new ZipFile(zipFile, encode);
        Enumeration en = zip.getEntries();
        ZipEntry entry = null;
        byte[] buffer = new byte[1024];
        int length = -1;
        InputStream input = null;
        BufferedOutputStream bos = null;
        File file = null;
        while (en.hasMoreElements()) {
            entry = (ZipEntry)en.nextElement();
            if (entry.isDirectory()) {
                file = new File(destdir, entry.getName());
                if (file.exists()) continue;
                file.mkdir();
                continue;
            }
            input = zip.getInputStream(entry);
            file = new File(destdir, entry.getName());
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            bos = new BufferedOutputStream(new FileOutputStream(file));
            while ((length = input.read(buffer)) != -1) {
                bos.write(buffer, 0, length);
            }
            bos.close();
            input.close();
        }
        zip.close();
    }

    private static List<File> getSubFiles(File baseDir, FileFilter filter) {
        ArrayList<File> ret = new ArrayList<File>();
        File[] tmp = baseDir.listFiles(filter);
        int i = 0;
        while (i < tmp.length) {
            if (tmp[i].isDirectory() && tmp[i].listFiles().length > 0) {
                ret.addAll(ZipUtils.getSubFiles(tmp[i], filter));
            } else {
                ret.add(tmp[i]);
            }
            ++i;
        }
        return ret;
    }

    private static String getAbsFileName(String baseDir, File realFileName) {
        File real = realFileName;
        File base = new File(baseDir);
        String ret = real.getName();
        while ((real = real.getParentFile()) != null && !real.equals(base)) {
            ret = String.valueOf(real.getName()) + "/" + ret;
        }
        return ret;
    }
}

