/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.utils.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class PropertiesHelper {
    private static final String EXTENSION = ".properties";
    private static final String USER_HOME_PROPERTY = "user.home";
    private static final String OS_NAME = "os.name";
    private static final String OS_NAME_LINUX = "linux";
    private static final String OS_NAME_MAC = "mac";
    private static final String Pandora_DIRECTORY_GENERAL = "HBuilder User/";
    private static final String Pandora_DIRECTORY_MACOSX = "/Documents/Pandora User/";
    public static String Pandora_PATH = "";

    public static Properties loadConfig(String fileName) {
        File file = new File(String.valueOf(Pandora_PATH) + fileName);
        InputStream in = null;
        Properties p = new Properties();
        try {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                if ((in = new FileInputStream(file)) != null) {
                    p.load(in);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return p;
    }

    public static String getValueByKey(String fileName, String key) {
        String value = "";
        if (StringUtil.isBlank((String)fileName)) {
            return value;
        }
        Properties p = PropertiesHelper.loadConfig(fileName = String.valueOf(fileName) + EXTENSION);
        if (p != null) {
            if (StringUtil.isEmpty((String)p.getProperty(key))) {
                value = "";
                return value;
            }
            try {
                value = new String(p.getProperty(key).getBytes("iso-8859-1"), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static void setValueByKey(String fileName, String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        PropertiesHelper.setValueByKey(fileName, map);
    }

    public static <T> void setValueByKey(String fileName, HashMap<String, String> map) {
        block18: {
            if (StringUtil.isBlank((String)fileName)) {
                return;
            }
            if (map == null) {
                return;
            }
            fileName = String.valueOf(fileName) + EXTENSION;
            Properties p = PropertiesHelper.loadConfig(fileName);
            Set<String> set = map.keySet();
            FileOutputStream fos = null;
            try {
                try {
                    for (String key : set) {
                        if (StringUtil.isBlank((String)key)) continue;
                        if (p.containsKey(key)) {
                            p.setProperty(key, map.get(key));
                            continue;
                        }
                        p.put(key, map.get(key));
                    }
                    File file = new File(String.valueOf(Pandora_PATH) + fileName);
                    fos = new FileOutputStream(file);
                    p.store(fos, "");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getValueByFullPathAndKey(String fullPath, String key) {
        String string;
        String str;
        FileInputStream input;
        block5: {
            Properties pp = new Properties();
            input = null;
            input = new FileInputStream(fullPath);
            pp.load(input);
            str = new String(pp.getProperty(key).getBytes("iso-8859-1"), "utf-8");
            if (!StringUtil.isBlank((String)str)) break block5;
            IOUtils.closeQuietly((InputStream)input);
            return "";
        }
        try {
            string = str;
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
            return "";
        }
        IOUtils.closeQuietly((InputStream)input);
        return string;
    }

    public static void save(Properties p, File file) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            p.store(out, null);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static Properties load(File file) throws IOException {
        FileInputStream in = null;
        Properties p = new Properties();
        try {
            in = new FileInputStream(file);
            p.load(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return p;
    }
}

