/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.auth;

import com.pandora.core.CoreActivator;
import com.pandora.core.auth.Messages;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.exception.ConnectionException;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.core.log.HBLog;
import com.pandora.core.proxy.ProxyService;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.LoginUtils;
import com.pandora.core.utils.StringUtil;
import com.pandora.core.utils.WorkspaceUtil;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UserAuthService {
    private static String MAC = null;

    public static ResponseObj login(String username, String password) throws Exception {
        return UserAuthService.userLoginAndReg(username, password, "UserAction!login");
    }

    public static boolean checkHasLogined(boolean showdailog) {
        HBLog.logTrace((Plugin)CoreActivator.getDefault(), (String)Messages.UserAuthService_0);
        boolean hasLogined = true;
        if (UserAuth.isLoginSucess() != 1) {
            hasLogined = false;
            try {
                hasLogined = UserAuthService.relogin();
            }
            catch (Exception e) {
                if (showdailog) {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"\u9519\u8bef", (String)e.getMessage());
                }
                HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            }
        }
        return hasLogined;
    }

    public static ResponseObj regist(String username, String password) throws Exception {
        return UserAuthService.userLoginAndReg(username, password, "UserAction!register");
    }

    public static ResponseObj userLoginAndReg(String username, String password, String command) throws Exception {
        String res = UserAuthService.validateUserInfo(username, password);
        if (!res.equals("1001")) {
            ResponseObj responseObj = new ResponseObj();
            responseObj.setRspcode("1003");
            responseObj.setRspdesc(res);
            return responseObj;
        }
        UserAuth.initUserAuth(username, password);
        ProxyService.initProxy();
        HashMap<String, String> reqmap = new HashMap<String, String>();
        HttpClientUtils httpClientUtils = HttpClientUtils.getInstance(command);
        if (command.equals("UserAction!register")) {
            reqmap.put("email", username);
            reqmap.put("password", password);
            reqmap.put("mac", UserAuthService.getMAC());
        } else if (command.equals("UserAction!login")) {
            reqmap.put("email", username);
            reqmap.put("password", password);
            reqmap.put("mac", UserAuthService.getMAC());
        }
        httpClientUtils.addRequestBody(reqmap);
        ResponseObj responseObj = httpClientUtils.excute(null, null, false);
        if (responseObj != null && responseObj.getRspcode().equals("1001")) {
            try {
                LoginUtils.saveDefaultUserInfo(username, password, WorkspaceUtil.getCodeDir(username));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Exception ex = new Exception(responseObj.getRspdesc());
            Stats.addExceptionInfo(ex);
            throw ex;
        }
        HBLog.logTrace((Plugin)CoreActivator.getDefault(), (String)"======\u767b\u5f55\u6210\u529f======");
        UserAuth.setToken(responseObj.getToken());
        UserAuth.setHasLoginSucess(1);
        LoginUtils.notifyLoginStatus();
        Stats.addLoginInfo(username);
        return responseObj;
    }

    public static ResponseObj checkIsDuringEvent(String username) {
        ProxyService.initProxy();
        HttpClientUtils httpClientUtils = HttpClientUtils.getInstance("EventAction!check");
        if (StringUtil.isNotBlank((String)username)) {
            httpClientUtils.addRequestBody("email", username);
        }
        return httpClientUtils.excuteGet();
    }

    public static String validateUserInfo(String userName, String password) {
        String result = "1001";
        String EMAIL_REGEX = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
        if (StringUtil.isBlank((String)userName)) {
            result = Messages.UserAuthService_14;
            return result;
        }
        if (!userName.matches(EMAIL_REGEX)) {
            result = Messages.UserAuthService_15;
            return result;
        }
        if (StringUtil.isBlank((String)password)) {
            result = Messages.UserAuthService_16;
            return result;
        }
        if (password.length() < 6) {
            result = Messages.UserAuthService_17;
            return result;
        }
        return result;
    }

    public static ResponseObj forgetPassword(String username) {
        String EMAIL_REGEX = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
        ResponseObj responseObj = new ResponseObj();
        responseObj.setRspcode("1003");
        if (StringUtil.isBlank((String)username)) {
            responseObj.setRspdesc(Messages.UserAuthService_20);
            return responseObj;
        }
        if (!username.matches(EMAIL_REGEX)) {
            responseObj.setRspdesc(Messages.UserAuthService_21);
            return responseObj;
        }
        HttpClientUtils httpClientUtils = HttpClientUtils.getInstance("UserAction!forgetPassword");
        HashMap<String, String> reqmap = new HashMap<String, String>();
        reqmap.put("email", username);
        httpClientUtils.addRequestBody(reqmap);
        responseObj = httpClientUtils.excute(null, null, false);
        if (responseObj != null && responseObj.getRspcode().equals("1001")) {
            HBLog.logTrace((Plugin)CoreActivator.getDefault(), (String)"======\u627e\u56de\u5bc6\u7801\u6210\u529f\uff01======");
        } else {
            Exception ex = new Exception(responseObj.getRspdesc());
            Stats.addExceptionInfo(ex);
        }
        return responseObj;
    }

    public static String getMAC() {
        try {
            if (MAC == null) {
                Enumeration<NetworkInterface> el = NetworkInterface.getNetworkInterfaces();
                StringBuilder macs = new StringBuilder();
                while (el.hasMoreElements()) {
                    byte[] mac = el.nextElement().getHardwareAddress();
                    if (mac == null) continue;
                    StringBuilder builder = new StringBuilder();
                    byte[] byArray = mac;
                    int n = mac.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        builder.append(String.format("%02x", b));
                        builder.append("-");
                        ++n2;
                    }
                    if (builder.length() <= 0) continue;
                    builder.deleteCharAt(builder.length() - 1);
                    if (macs.length() > 0) {
                        macs.append(",");
                    }
                    macs.append((CharSequence)builder);
                }
                MAC = macs.toString();
            }
            return MAC;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static boolean relogin() throws Exception {
        boolean isSuc = false;
        String password = LoginUtils.getPassword();
        if (StringUtil.isBlank((String)password)) {
            return false;
        }
        ResponseObj responseObj = UserAuthService.login(UserAuth.getUsername(), password);
        if ("1001".equals(responseObj.getRspcode())) {
            isSuc = true;
        } else {
            if ("999".equals(responseObj.getRspcode())) {
                throw new ConnectionException("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\uff0c\u5982\u9700\u8bbe\u7f6e\u4ee3\u7406\uff0c\u8bf7\u9000\u51fa\u8d26\u53f7\u5728\u767b\u5f55\u754c\u9762\u8bbe\u7f6e\u4ee3\u7406\uff01");
            }
            isSuc = false;
        }
        return isSuc;
    }
}

