/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.appstream;

import com.google.gson.annotations.Expose;
import com.pandora.core.appstream.IValue;
import com.pandora.core.appstream.ValueType;
import com.pandora.core.utils.CollectionsUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;

public class RelationTree {
    @Expose
    private URI path = null;
    @Expose
    private List<RelationTree> children;
    private RelationTree parent = null;
    private Map<String, String> basePaths;
    private boolean link = false;
    private IValue fSelfValue = null;
    private Collection<IValue> fValues = null;

    public void setLink(boolean link) {
        this.link = link;
    }

    public IValue getSelfValue() {
        return this.fSelfValue;
    }

    public boolean isLink() {
        return this.link;
    }

    public RelationTree(URI path, IValue selfValue) {
        this.path = path;
        this.fSelfValue = selfValue;
    }

    public void addValue(IValue value) {
        if (this.fValues == null) {
            this.fValues = new ArrayList<IValue>();
        }
        this.fValues.add(value);
    }

    public Collection<IValue> getValues() {
        return this.fValues;
    }

    public Collection<IValue> getValues(ValueType type) {
        if (type != null && this.fValues != null) {
            ArrayList<IValue> results = new ArrayList<IValue>();
            for (IValue value : this.fValues) {
                if (value == null || type != value.getType()) continue;
                results.add(value);
            }
            return results;
        }
        return this.fValues;
    }

    public String getBasePath(String key) {
        if (this.basePaths == null || !this.basePaths.containsKey(key)) {
            return "";
        }
        return this.basePaths.get(key);
    }

    public void addChild(RelationTree child) {
        if (this.children == null) {
            this.children = new ArrayList<RelationTree>();
        }
        if (!this.children.contains(child)) {
            this.children.add(child);
            child.setParent(this);
        }
    }

    public RelationTree getParent() {
        return this.parent;
    }

    public void setParent(RelationTree parent) {
        this.parent = parent;
    }

    public boolean isPageView() {
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(this.path.getPath());
        return contentType != null && "com.aptana.contenttype.html".equals(contentType.getId());
    }

    public boolean isContainer() {
        return this.path != null && (this.isPageView() || this.path.getPath().toLowerCase().endsWith(".css"));
    }

    public boolean hasChildren() {
        return CollectionsUtil.isNotEmpty(this.children);
    }

    public RelationTree getContainer() {
        RelationTree container = this;
        while (!container.isContainer()) {
            if (container.getParent() == null) break;
            container = container.getParent();
        }
        return container;
    }

    public URI getPath() {
        return this.path;
    }

    public List<RelationTree> getChildren() {
        return this.children;
    }

    public boolean isLeaf() {
        String name = this.getPath().toString().toLowerCase();
        return !this.isContainer() && !name.endsWith(".js");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationTree other = (RelationTree)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String toString() {
        return this.path == null ? "" : this.path.toString();
    }

    public void registerBasePath(String key, String basePath) {
        if (this.basePaths == null) {
            this.basePaths = new HashMap<String, String>();
        }
        this.basePaths.put(key, basePath);
    }
}

