/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.appstream;

import com.pandora.core.appstream.IASTParser;
import com.pandora.core.utils.RegistryUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public class ASTParseManager {
    private Map<String, IASTParser> parsers = null;

    private ASTParseManager() {
    }

    private static ASTParseManager getInstance() {
        return new ASTParseManager();
    }

    private IASTParser _getParser(String contentType) {
        if (this.parsers == null) {
            try {
                this.initParsers();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.parsers.get(contentType);
    }

    private void initParsers() throws Exception {
        this.parsers = new HashMap<String, IASTParser>();
        List<IConfigurationElement> elements = RegistryUtils.getEp("com.pandora.core.ASTParser", "parser");
        for (IConfigurationElement el : elements) {
            String contentType = el.getAttribute("contentType");
            Object obj = el.createExecutableExtension("class");
            if (!(obj instanceof IASTParser)) continue;
            this.parsers.put(contentType, (IASTParser)obj);
        }
    }

    public static IASTParser getParser(String contentType) {
        return ASTParseManager.getInstance()._getParser(contentType);
    }
}

