/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.wizards;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.projects.internal.wizards.Messages;
import com.pandora.core.auth.UserAuth;
import com.pandora.projects.exception.ProjectException;
import com.pandora.projects.service.ProjectService;
import com.pandora.projects.ui.Activator;
import com.pandora.projects.ui.handler.ICreateProjectHandler;
import com.pandora.projects.ui.page.NewHMobileProjectWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.ide.misc.FileInfoAttributesMatcher;
import org.osgi.service.prefs.BackingStoreException;

public class NewHMobileProjectWizard
extends Wizard
implements INewWizard {
    public static final String ID = "com.pandora.projects.ui.wizards.NewHMobileProjectWizard";
    private String appid = null;
    private ProjectService projectService = new ProjectService();
    protected NewHMobileProjectWizardPage newProjectPage = null;

    public void addPages() {
        this.newProjectPage = new NewHMobileProjectWizardPage("\u521b\u5efa\u79fb\u52a8App");
        this.addPage((IWizardPage)this.newProjectPage);
    }

    public boolean performFinish() {
        try {
            if (this.checkCreateProjectCondition()) {
                this.appid = UserAuth.isLoginSucess() == 1 ? this.projectService.applyProject(this.newProjectPage.getProjectName()) : "nologin";
                final ICreateProjectHandler projectHandler = this.newProjectPage.getProjectHandler();
                projectHandler.setAppid(this.appid);
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        NewHMobileProjectWizard.this.runCreateProjectProgress(projectHandler, monitor);
                    }
                });
                return true;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.newProjectPage.setErrorMessage(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ProjectException e) {
            e.printStackTrace();
            this.newProjectPage.setErrorMessage(e.getMessage());
        }
        return false;
    }

    protected void runCreateProjectProgress(final ICreateProjectHandler projectHandler, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (NewHMobileProjectWizard.this.newProjectPage != null) {
                        IProject project = projectHandler.create(monitor);
                        NewHMobileProjectWizard.this.settingProject(project, monitor);
                        project.refreshLocal(2, monitor);
                    }
                }
            }, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e, Messages.AbstractNewProjectWizard_ProjectListener_NoDescriptor_Error);
        }
    }

    protected void settingIndexFilterDir(IProject project) {
        String pattern = "workspace:/{0}/bin";
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.index.core.ui");
        String oldFilters = prefs.get("FILTERED_INDEX_URIS", "");
        StringBuffer filter = new StringBuffer();
        filter.append(MessageFormat.format(pattern, project.getName()));
        if (StringUtil.isNotEmpty((String)oldFilters)) {
            filter.append("\u0000");
            filter.append(oldFilters);
        }
        prefs.put("FILTERED_INDEX_URIS", filter.toString());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e1) {
            e1.printStackTrace();
        }
    }

    protected void setResourceFilter(IProject project, IProgressMonitor monitor) {
        try {
            FileInfoMatcherDescription set = new FileInfoMatcherDescription(FileInfoAttributesMatcher.ID, (Object)this.createFilterArgument("bin"));
            FileInfoMatcherDescription bin = new FileInfoMatcherDescription(FileInfoAttributesMatcher.ID, (Object)this.createFilterArgument("setting"));
            FileInfoMatcherDescription filter = new FileInfoMatcherDescription("org.eclipse.ui.ide.orFilterMatcher", (Object)new FileInfoMatcherDescription[]{set, bin});
            project.createFilter(10, filter, 128, monitor);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    protected String createFilterArgument(String path) {
        FileInfoAttributesMatcher.Argument argument = new FileInfoAttributesMatcher.Argument();
        argument.key = FileInfoAttributesMatcher.KEY_PROPJECT_RELATIVE_PATH;
        argument.operator = FileInfoAttributesMatcher.OPERATOR_MATCHES;
        argument.pattern = path;
        return FileInfoAttributesMatcher.encodeArguments((FileInfoAttributesMatcher.Argument)argument);
    }

    protected void settingProject(IProject project, IProgressMonitor monitor) {
        this.settingProjectProperties(project, monitor);
        this.setResourceFilter(project, monitor);
    }

    protected void settingProjectProperties(IProject project, IProgressMonitor monitor) {
    }

    protected boolean checkCreateProjectCondition() throws CoreException {
        return this.newProjectPage.validatePage();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("\u521b\u5efa\u79fb\u52a8App");
        this.setHelpAvailable(false);
    }

    public boolean isHelpAvailable() {
        return false;
    }
}

