/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.wizards;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.UntitledFileStorageEditorInput;
import com.aptana.ide.ui.io.actions.CopyFilesOperation;
import com.pandora.core.utils.ZipUtils;
import com.pandora.projects.templates.FileTemplate;
import com.pandora.projects.templates.FileTemplatesManager;
import com.pandora.projects.templates.TemplateType;
import com.pandora.projects.ui.Activator;
import com.pandora.projects.ui.page.NewFileWizardPage;
import com.pandora.projects.ui.wizards.Messages;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

public abstract class NewFileWizard
extends Wizard
implements INewWizard {
    public static final String TEMPLATE_PATH = "/templates/file/";
    protected NewFileWizardPage page = null;
    protected ISelection selection;

    public NewFileWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("\u521b\u5efa\u6587\u4ef6\u5411\u5bfc");
    }

    public void addPages() {
        this.page = new NewFileWizardPage(this.selection, this);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        final FileTemplate termplateFile = this.page.getFileTemplate();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewFileWizard.this.doFinish(containerName, fileName, termplateFile, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewFileWizard_0, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, FileTemplate fileTemplate, IProgressMonitor monitor) throws CoreException {
        IFile file;
        block19: {
            if (StringUtil.isEmpty((String)containerName)) {
                this.createTempFile(fileName, fileTemplate, monitor);
                return;
            }
            monitor.beginTask(String.valueOf(Messages.NewFileWizard_1) + fileName, 2);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = root.findMember((IPath)new Path(containerName));
            if (!resource.exists() || !(resource instanceof IContainer)) {
                this.throwCoreException(String.valueOf(Messages.NewFileWizard_Container) + containerName + Messages.NewFileWizard_DoesNotExist);
            }
            IContainer container = (IContainer)resource;
            File tmpDir = null;
            IFile iFile = file = StringUtil.isEmpty((String)fileName) ? null : container.getFile((IPath)new Path(fileName));
            if (fileTemplate.getTemplateType() == TemplateType.FILE) {
                try {
                    InputStream stream = this.openContentStream(fileTemplate, file);
                    if (file.exists()) {
                        file.setContents(stream, true, true, monitor);
                    } else {
                        file.create(stream, true, monitor);
                    }
                    stream.close();
                }
                catch (IOException iOException) {}
            } else if (fileTemplate.getTemplateType() == TemplateType.GROUP) {
                tmpDir = Activator.getDefault().getBundle().getDataFile("template_group_tmp");
                FileUtils.deleteQuietly((File)tmpDir);
                tmpDir.mkdirs();
                try {
                    try {
                        ZipUtils.unzip((String)fileTemplate.getFile().getAbsolutePath(), (String)tmpDir.getAbsolutePath(), (String)FileTemplatesManager.getInstance().getEncode(fileTemplate));
                        CopyFilesOperation copyFilesOperation = new CopyFilesOperation(this.getShell());
                        copyFilesOperation.setShowSourceOfOverwrite(false);
                        File[] files = tmpDir.listFiles();
                        if (files != null && files.length > 0) {
                            IFileStore[] fs = new IFileStore[files.length];
                            int i = 0;
                            while (i < files.length) {
                                fs[i] = EFS.getStore((URI)files[i].toURI());
                                ++i;
                            }
                            copyFilesOperation.copyFiles(fs, EFS.getStore((URI)resource.getLocationURI()), monitor);
                            container.refreshLocal(1, monitor);
                            i = 0;
                            while (i < files.length) {
                                IFolder folder;
                                File f = files[i];
                                if (f.isDirectory() && (folder = container.getFolder((IPath)new Path(f.getName()))).exists()) {
                                    folder.refreshLocal(1, monitor);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                        FileUtils.deleteQuietly((File)tmpDir);
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.deleteQuietly((File)tmpDir);
                    throw throwable;
                }
                FileUtils.deleteQuietly((File)tmpDir);
            }
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.NewFileWizard_OpeningFileForEditing);
        if (file != null && file.exists()) {
            this.openIde(file);
        }
        monitor.worked(1);
    }

    private void createTempFile(String fileName, FileTemplate fileTemplate, IProgressMonitor monitor) {
        block12: {
            monitor.beginTask(String.valueOf(Messages.NewFileWizard_1) + fileName, 2);
            IEditorDescriptor editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(fileName);
            String editorId = editorDescriptor == null ? "com.aptana.editor.text" : editorDescriptor.getId();
            FileOutputStream output = null;
            try {
                try {
                    InputStream stream = this.openContentStream(fileTemplate, null);
                    File tempFile = File.createTempFile(fileName, null);
                    output = new FileOutputStream(tempFile);
                    IOUtil.pipe((InputStream)stream, (OutputStream)output);
                    tempFile.deleteOnExit();
                    monitor.worked(1);
                    monitor.setTaskName(Messages.NewFileWizard_OpeningFileForEditing);
                    UntitledFileStorageEditorInput editorInput = new UntitledFileStorageEditorInput(tempFile.toURI(), fileName, stream);
                    this.openIde((IEditorInput)editorInput, editorId);
                    monitor.worked(1);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                    if (output == null) break block12;
                    try {
                        output.close();
                    }
                    catch (IOException e2) {
                        IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e2);
                    }
                }
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected IProject getProject() {
        IStructuredSelection iss;
        if (this.selection != null && this.selection instanceof IStructuredSelection && (iss = (IStructuredSelection)this.selection).getFirstElement() instanceof IResource) {
            IResource res = (IResource)iss.getFirstElement();
            return res.getProject();
        }
        return null;
    }

    protected void openIde(final IEditorInput editorInput, final String editorId) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)editorId);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                }
            }
        });
    }

    protected void openIde(final IFile file) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    if ("manifest.json".equals(file.getName())) {
                        try {
                            if (!file.getProject().hasNature("com.pandora.projects.ui.MKeyNature")) {
                                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"com.aptana.editor.json");
                                return;
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
    }

    private InputStream openContentStream(FileTemplate fileTemplate, IFile file) {
        String contents = this.getDefaultTemplate();
        InputStream is = null;
        try {
            if (fileTemplate == null || fileTemplate.getFile() == null || !fileTemplate.getFile().exists()) {
                Bundle bundle = Platform.getBundle((String)"com.pandora.projects.ui");
                if (bundle != null) {
                    URL url = bundle.getResource(TEMPLATE_PATH + contents);
                    is = url.openStream();
                }
            } else {
                is = new FileInputStream(fileTemplate.getFile());
            }
            int len = is.available();
            byte[] bs = new byte[len];
            is.read(bs);
            String template = new String(bs);
            template = this.settingVariables(file, template);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(template.getBytes());
            IOUtils.closeQuietly((InputStream)is);
            return byteArrayInputStream;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return new ByteArrayInputStream("".getBytes());
    }

    protected String settingVariables(IFile file, String contents) throws CoreException {
        String template = contents;
        try {
            IProject project = this.getProject();
            if (project != null) {
                template = template.replaceAll("\\{CHARSET\\}", project.getDefaultCharset());
                if (file != null) {
                    String uri = project.getFile("js/mui.min.js").getLocation().makeRelativeTo(file.getParent().getLocation()).toString();
                    template = template.replaceAll("\\{MUI_JS_LOC\\}", uri.toString());
                    uri = project.getFile("css/mui.min.css").getLocation().makeRelativeTo(file.getParent().getLocation()).toString();
                    template = template.replaceAll("\\{MUI_CSS_LOC\\}", uri.toString());
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
            return contents;
        }
        return template;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.pandora.projects.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public abstract String getFileType();

    public abstract String getFileExt();

    public abstract String getDefaultTemplate();
}

