/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.startup;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.FileUtil;
import com.pandora.core.stats.Stats;
import com.pandora.projects.ui.Activator;
import com.pandora.ui.action.ImportFolderAction;
import com.pandora.ui.utils.IDEUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorAreaHelper;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.editors.text.UntitledTextFileWizard;
import org.eclipse.ui.internal.presentations.PaneFolder;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabFolder;
import org.eclipse.ui.internal.presentations.util.AbstractTabFolder;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.TabbedStackPresentation;

public class Startup
implements IStartup {
    public void earlyStartup() {
        try {
            String[] args = Platform.getCommandLineArgs();
            List files = FileUtil.gatherFilesFromCommandLineArguments((String[])args);
            if (files != null && !files.isEmpty()) {
                for (File file : files) {
                    if (!file.exists()) continue;
                    if (file.isFile()) {
                        this.openFile(file);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    this.openFolder(file);
                }
            }
        }
        catch (Exception e) {
            Stats.addExceptionInfo((Throwable)e);
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
        }
        this.addUntitledEditorListener();
    }

    private void addUntitledEditorListener() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                final IWorkbenchWindow currentWindow = workbench.getActiveWorkbenchWindow();
                this.addPartListener(currentWindow);
                this.addMouserListener(currentWindow);
                workbench.addWindowListener(new IWindowListener(){

                    public void windowOpened(IWorkbenchWindow window) {
                        if (window != currentWindow) {
                            this.addPartListener(window);
                            this.addMouserListener(window);
                        }
                    }

                    public void windowDeactivated(IWorkbenchWindow window) {
                    }

                    public void windowClosed(IWorkbenchWindow window) {
                    }

                    public void windowActivated(IWorkbenchWindow window) {
                    }
                });
            }

            private void addPartListener(final IWorkbenchWindow window) {
                window.getActivePage().addPartListener(new IPartListener(){

                    public void partOpened(IWorkbenchPart part) {
                        try {
                            IEditorReference[] editorReferences;
                            if (part instanceof IEditorPart && (editorReferences = part.getSite().getPage().getEditorReferences()).length == 1) {
                                this.addMouserListener(part.getSite().getWorkbenchWindow());
                            }
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                        }
                    }

                    public void partDeactivated(IWorkbenchPart part) {
                    }

                    public void partClosed(IWorkbenchPart part) {
                        try {
                            IEditorReference[] editorReferences;
                            if (part instanceof IEditorPart && !window.getWorkbench().isClosing() && (editorReferences = part.getSite().getPage().getEditorReferences()).length == 0) {
                                this.addMouserListener(part.getSite().getWorkbenchWindow());
                            }
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                        }
                    }

                    public void partBroughtToTop(IWorkbenchPart part) {
                    }

                    public void partActivated(IWorkbenchPart part) {
                    }
                });
            }

            private void addMouserListener(IWorkbenchWindow window) {
                if (window != null && window.getActivePage() != null) {
                    EditorAreaHelper editorAreaHelper = ((WorkbenchPage)window.getActivePage()).getEditorPresentation();
                    EditorStack editorStack = editorAreaHelper.getActiveWorkbook();
                    try {
                        if (editorStack.getProperty("addMouseListener") != null) {
                            return;
                        }
                        Method method = PartStack.class.getDeclaredMethod("getPresentation", new Class[0]);
                        method.setAccessible(true);
                        Object result = method.invoke((Object)editorStack, new Object[0]);
                        TabbedStackPresentation stackPresentation = (TabbedStackPresentation)result;
                        final DefaultTabFolder defaultTabFolder = (DefaultTabFolder)stackPresentation.getTabFolder();
                        Field field = DefaultTabFolder.class.getDeclaredField("paneFolder");
                        field.setAccessible(true);
                        result = field.get(defaultTabFolder);
                        PaneFolder paneFolder = (PaneFolder)result;
                        field = AbstractTabFolder.class.getDeclaredField("mouseListener");
                        field.setAccessible(true);
                        result = field.get(defaultTabFolder);
                        final MouseListener defaultMouseListener = (MouseListener)result;
                        MouseListener mouseListener = new MouseListener(){

                            public void mouseUp(MouseEvent e) {
                                defaultMouseListener.mouseUp(e);
                            }

                            public void mouseDown(MouseEvent e) {
                                defaultMouseListener.mouseDown(e);
                            }

                            public void mouseDoubleClick(MouseEvent e) {
                                try {
                                    AbstractTabItem item = defaultTabFolder.getItem(e.display.map((Control)e.widget, null, e.x, e.y));
                                    if (item != null) {
                                        defaultMouseListener.mouseDoubleClick(e);
                                    } else {
                                        UntitledTextFileWizard untitledTextFileWizard = new UntitledTextFileWizard();
                                        untitledTextFileWizard.init(workbench, null);
                                        untitledTextFileWizard.performFinish();
                                    }
                                }
                                catch (Exception ex) {
                                    defaultMouseListener.mouseDoubleClick(e);
                                    IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)ex);
                                }
                            }
                        };
                        CTabFolder cTabFolder = (CTabFolder)paneFolder.getControl();
                        cTabFolder.removeMouseListener(defaultMouseListener);
                        cTabFolder.addMouseListener(mouseListener);
                        editorStack.setProperty("addMouseListener", "true");
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                    }
                }
            }
        });
    }

    protected void openFile(final File file) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IDEUtils.openLocalFile((File)file, (IWorkbenchWindow)window);
            }
        });
    }

    protected void openFolder(final File folder) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ImportFolderAction action = new ImportFolderAction(folder);
                action.run();
            }
        });
    }
}

