/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.handler;

import com.aptana.core.util.StringUtil;
import com.aptana.core.util.WorkspaceUtil;
import com.pandora.core.auth.UserAuth;
import com.pandora.projects.ui.handler.ICreateProjectHandler;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public abstract class AbstractCreateAppHandler
implements ICreateProjectHandler {
    protected IProject createBasicProject(final IProject project, IProgressMonitor monitor) throws CoreException {
        if (project == null) {
            return project;
        }
        final IFile appConfigFile = project.getFile("manifest.json");
        if (!appConfigFile.getLocation().makeAbsolute().toFile().exists()) {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    AbstractCreateAppHandler.this.createAppConfigFile(project, appConfigFile.getLocation().makeAbsolute().toFile());
                }
            }, monitor);
        } else {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    AbstractCreateAppHandler.this.updateAppConfigFile(project, appConfigFile.getLocation().makeAbsolute().toFile());
                }
            }, monitor);
        }
        return project;
    }

    protected IPath getCodeDir(IWorkspace workspace, String projectName, String location) {
        IPath codeDir = workspace.getRoot().getLocation().append(projectName);
        String username = UserAuth.getUsername();
        if (StringUtil.isNotEmpty((String)username)) {
            String codeLocation = WorkspaceUtil.getCodeDir((String)username);
            if (codeLocation == null || "".equals(codeLocation)) {
                codeLocation = WorkspaceUtil.getCodeLocation();
            }
            if (!codeLocation.equals(location)) {
                WorkspaceUtil.setNewCodeDir((String)username, (String)location);
                codeLocation = location;
            }
            if (StringUtil.isNotEmpty((String)codeLocation)) {
                codeDir = new Path(codeLocation).append(projectName);
            }
        } else if (StringUtil.isNotBlank((String)location)) {
            codeDir = new Path(location).append(projectName);
        }
        return codeDir;
    }

    protected IPath getCodeDir(IWorkspace workspace, String projectName) {
        String codeLocation;
        IPath codeDir = workspace.getRoot().getLocation().append(projectName);
        String username = UserAuth.getUsername();
        if (StringUtil.isNotEmpty((String)username) && StringUtil.isNotEmpty((String)(codeLocation = WorkspaceUtil.getCodeDir((String)username)))) {
            codeDir = new Path(codeLocation).append(projectName);
        }
        return codeDir;
    }

    protected void updateAppConfigFile(IProject project, File file) {
        try {
            String contents = FileUtils.readFileToString((File)file);
            if (contents.indexOf("\"id\": \"HelloH5\"") >= 0) {
                contents = contents.replace("\"id\": \"HelloH5\"", "\"id\": \"" + (this.getAppid().equals("nologin") ? "" : this.getAppid()) + "\"");
                contents = contents.replace("\"name\": \"HelloH5\"", "\"name\": \"" + project.getName() + "\"");
                FileUtils.writeStringToFile((File)file, (String)contents);
            }
            if (contents.indexOf("\"id\": \"CSDN\"") >= 0) {
                contents = contents.replace("\"id\": \"CSDN\"", "\"id\": \"" + (this.getAppid().equals("nologin") ? "" : this.getAppid()) + "\"");
                contents = contents.replace("\"name\": \"CSDN\u8d44\u8baf\"", "\"name\": \"" + project.getName() + "\"");
                FileUtils.writeStringToFile((File)file, (String)contents);
            }
            if (contents.indexOf("\"id\": \"Ratchet\"") >= 0) {
                contents = contents.replace("\"id\": \"Ratchet\"", "\"id\": \"" + (this.getAppid().equals("nologin") ? "" : this.getAppid()) + "\"");
                contents = contents.replace("\"name\": \"DCloud_Ratchet\"", "\"name\": \"" + project.getName() + "\"");
                FileUtils.writeStringToFile((File)file, (String)contents);
            }
            if (contents.indexOf("\"id\": \"default\"") >= 0) {
                contents = contents.replace("\"id\": \"default\"", "\"id\": \"" + (this.getAppid().equals("nologin") ? "" : this.getAppid()) + "\"");
                contents = contents.replace("\"name\": \"default\"", "\"name\": \"" + project.getName() + "\"");
                FileUtils.writeStringToFile((File)file, (String)contents);
            }
            if (contents.indexOf("\"id\": \"mui\"") >= 0) {
                contents = contents.replace("\"id\": \"mui\"", "\"id\": \"" + (this.getAppid().equals("nologin") ? "" : this.getAppid()) + "\"");
                contents = contents.replace("\"name\": \"mui\"", "\"name\": \"" + project.getName() + "\"");
                FileUtils.writeStringToFile((File)file, (String)contents);
            }
            if (contents.indexOf("\"id\": \"hellomui\"") >= 0) {
                contents = contents.replace("\"id\": \"hellomui\"", "\"id\": \"" + (this.getAppid().equals("nologin") ? "" : this.getAppid()) + "\"");
                contents = contents.replace("\"name\": \"hellomui\"", "\"name\": \"" + project.getName() + "\"");
                FileUtils.writeStringToFile((File)file, (String)contents);
            }
            if (contents.indexOf("\"id\": \"mui-login-setting\"") >= 0) {
                contents = contents.replace("\"id\": \"mui-login-setting\"", "\"id\": \"" + (this.getAppid().equals("nologin") ? "" : this.getAppid()) + "\"");
                contents = contents.replace("\"name\": \"mui-login-setting\"", "\"name\": \"" + project.getName() + "\"");
                FileUtils.writeStringToFile((File)file, (String)contents);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean createAppConfigFile(IProject project, File appConfigFile) {
        try {
            String manifest = FileUtils.readFileToString((File)appConfigFile, (String)"utf8");
            System.out.println(manifest);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public abstract String getAppid();
}

