/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.text;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.text.TextEditorPlugin;
import com.aptana.editor.text.TextSourceViewerConfiguration;
import com.pandora.ui.action.OpenWithMenu;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextEditor
extends AbstractThemeableEditor {
    protected void initializeEditor() {
        super.initializeEditor();
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new TextSourceViewerConfiguration(this.getPreferenceStore(), this));
        this.setDocumentProvider(TextEditorPlugin.getDefault().getTextDocumentProvider());
    }

    protected IPreferenceStore getPluginPreferenceStore() {
        return TextEditorPlugin.getDefault().getPreferenceStore();
    }

    public String getContentType() {
        return "com.aptana.editor.text.content-type.generic";
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof NonExistingFileEditorInput) {
            MenuManager openWithSubMenu = new MenuManager("\u6253\u5f00\u65b9\u5f0f(&W)");
            final IWorkbenchPage page = this.getEditorSite().getPage();
            OpenWithMenu openWithMenu = new OpenWithMenu(page, (IAdaptable)editorInput){

                protected void openEditor(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
                    super.openEditor(editorDescriptor, openUsingDescriptor);
                    try {
                        if (TextEditor.this.getSelectionProvider() == null) {
                            return;
                        }
                        ISelection selection = TextEditor.this.getSelectionProvider().getSelection();
                        if (selection instanceof ITextSelection) {
                            TextEditor.revealInEditor(page.getActiveEditor(), ((ITextSelection)selection).getOffset(), ((ITextSelection)selection).getLength());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            openWithMenu.setExistingFile(false);
            openWithSubMenu.add((IContributionItem)openWithMenu);
            menu.appendToGroup("group.open", (IContributionItem)openWithSubMenu);
        }
    }

    private static void revealInEditor(IEditorPart editor, final int offset, final int length) {
        IGotoMarker gotoMarkerTarget;
        if (editor instanceof ITextEditor) {
            ((ITextEditor)editor).selectAndReveal(offset, length);
            return;
        }
        if (editor instanceof IGotoMarker) {
            gotoMarkerTarget = (IGotoMarker)editor;
        } else {
            IGotoMarker iGotoMarker = gotoMarkerTarget = editor != null ? (IGotoMarker)editor.getAdapter(IGotoMarker.class) : null;
        }
        if (gotoMarkerTarget != null) {
            final IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        IMarker marker = null;
                        try {
                            marker = ((IFileEditorInput)input).getFile().createMarker("org.eclipse.core.resources.textmarker");
                            marker.setAttribute("charStart", offset);
                            marker.setAttribute("charEnd", offset + length);
                            gotoMarkerTarget.gotoMarker(marker);
                        }
                        finally {
                            if (marker != null) {
                                marker.delete();
                            }
                        }
                    }
                };
                try {
                    op.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
    }
}

