/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json;

import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.json.parsing.lexer.JSONTokenType;
import com.aptana.editor.json.text.rules.JSONNumberRule;
import com.aptana.editor.json.text.rules.JSONPropertyRule;
import java.util.ArrayList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class JSONSourceScanner
extends RuleBasedScanner {
    public JSONSourceScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        rules.add(new MultiLineRule("/*", "*/", this.createToken(JSONTokenType.COMMENT)));
        rules.add(new EndOfLineRule("//", this.createToken(JSONTokenType.COMMENT)));
        rules.add(new JSONPropertyRule(this.createToken(JSONTokenType.STRING_SINGLE), this.createToken(JSONTokenType.STRING_DOUBLE), this.createToken(JSONTokenType.PROPERTY)));
        WordRule keywordRule = new WordRule((IWordDetector)new KeywordDetector(), Token.UNDEFINED);
        keywordRule.addWord("true", this.createToken(JSONTokenType.TRUE));
        keywordRule.addWord("false", this.createToken(JSONTokenType.FALSE));
        keywordRule.addWord("null", this.createToken(JSONTokenType.NULL));
        rules.add(keywordRule);
        CharacterMapRule cmRule = new CharacterMapRule();
        cmRule.add('{', this.createToken(JSONTokenType.LCURLY));
        cmRule.add('}', this.createToken(JSONTokenType.RCURLY));
        cmRule.add('[', this.createToken(JSONTokenType.LBRACKET));
        cmRule.add(']', this.createToken(JSONTokenType.RBRACKET));
        cmRule.add(',', this.createToken(JSONTokenType.COMMA));
        cmRule.add(':', this.createToken(JSONTokenType.COLON));
        rules.add(cmRule);
        rules.add((Object)new JSONNumberRule(this.createToken(JSONTokenType.NUMBER)));
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    protected IToken createToken(JSONTokenType type) {
        return new Token((Object)type.getScope());
    }

    public class KeywordDetector
    implements IWordDetector {
        public boolean isWordPart(char c) {
            return this.isWordStart(c);
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c);
        }
    }
}

