/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import com.aptana.build.util.BuildHelper;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.RequiredBuildParticipant;
import com.aptana.index.core.build.BuildContext;
import com.pandora.core.utils.ReflectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;

public abstract class TaskDetectorBuildParticipant
extends RequiredBuildParticipant {
    private static final String COMMENT_ENDING = "*/";

    @Override
    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        if (!context.isFullBuild() && !context.isSave()) {
            return;
        }
        Collection<IProblem> tasks = this.detectTasks(context, monitor);
        context.putProblems("com.aptana.core.task", tasks);
    }

    protected Collection<IProblem> detectTasks(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return Collections.emptyList();
        }
        try {
            Document source = new Document(context.getContents());
            RuleBasedPartitionScanner ruleScanner = new RuleBasedPartitionScanner();
            ruleScanner.setPredicateRules(this.getCommentRules());
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)ruleScanner, new String[]{this.getCommentContentType()});
            partitioner.connect((IDocument)source);
            source.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            Position[] comments = null;
            try {
                comments = source.getPositions((String)ReflectUtils.getFieldValue((Object)partitioner, (String[])new String[]{"fPositionCategory"}));
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            if (comments == null) {
                return Collections.emptyList();
            }
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)comments.length);
            ArrayList<IProblem> tasks = new ArrayList<IProblem>(comments.length);
            try {
                String filePath = context.getURI().toString();
                int i = 0;
                Position[] positionArray = comments;
                int n = comments.length;
                int n2 = 0;
                while (n2 < n) {
                    Position commentNode = positionArray[n2];
                    if (context.isNeedSleep()) {
                        BuildHelper.sleepLoop((String)"TASK_TYPE", (int)(++i));
                    }
                    tasks.addAll(this.processCommentNode(filePath, (IDocument)source, 0, commentNode, COMMENT_ENDING, context.isNeedSleep()));
                    sub.worked(1);
                    ++n2;
                }
            }
            finally {
                sub.done();
            }
            return tasks;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    protected abstract IPredicateRule[] getCommentRules();

    protected abstract String getCommentContentType();
}

