/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import com.aptana.core.util.PlatformUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public abstract class BuilderJob
extends Job {
    public static final QualifiedName BUILDTYPE_VALIDATION = new QualifiedName("BuildType", "VALIDATION");
    public static final String VALIDATION_ONLY_REMOVE_MARKEER = "VALIDATION_ONLY_REMOVE_MARKEER";
    public static final String VALIDATION_ALL = "VALIDATION_ALL";
    protected IProject project;
    private IFile file;
    private boolean isProjectBuild;
    private boolean isFullBuild;

    public BuilderJob(IProject project, boolean isProjectBuild) {
        super(String.valueOf(project != null ? "\u9879\u76ee" + project.getName() : "") + "\u6784\u5efa");
        this.project = project;
        this.isProjectBuild = isProjectBuild;
        this.setRule(new BuildJobRule(project, isProjectBuild));
    }

    public boolean belongsTo(Object family) {
        if (!(family instanceof IProject)) {
            return false;
        }
        return this.project.equals(family);
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public void setIsFullBuild(boolean isFullBuild) {
        this.isFullBuild = isFullBuild;
    }

    public boolean equalsBuild(BuilderJob job) {
        return job != null && (!this.isProjectBuild && !job.isProjectBuild && this.file != null && this.file.equals((Object)job.file) || this.isProjectBuild && job.isProjectBuild && this.project != null && this.project.equals((Object)job.project) && this.isFullBuild == job.isFullBuild);
    }

    public void cancelSameJobs() {
        Job[] jobs;
        if (this.project != null && (jobs = Job.getJobManager().find((Object)this.project)) != null) {
            Job[] jobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job instanceof BuilderJob && ((BuilderJob)job).equalsBuild(this)) {
                    job.cancel();
                }
                ++n2;
            }
        }
    }

    private class BuildJobRule
    implements ISchedulingRule {
        private IProject project;
        private boolean isProjectBuild;

        public BuildJobRule(IProject project, boolean isProjectBuild) {
            this.project = project;
            this.isProjectBuild = isProjectBuild;
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (this == rule) {
                return true;
            }
            if (this.project == null) {
                return false;
            }
            if (PlatformUtil.isClosing() && rule.equals(ResourcesPlugin.getWorkspace().getRoot())) {
                return true;
            }
            if (rule instanceof BuildJobRule) {
                BuildJobRule buildJobRule = (BuildJobRule)rule;
                return this.isProjectBuild == buildJobRule.isProjectBuild;
            }
            return false;
        }
    }
}

