/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.build.IBuildParticipantWorkingCopy;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.PreferenceUtil;
import com.aptana.core.build.Problem;
import com.aptana.core.internal.build.BuildParticipantWorkingCopy;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.TaskTag;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ast.IParseNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractBuildParticipant
implements IBuildParticipant,
IExecutableExtension {
    protected static final IScopeContext[] CONTEXTS = new IScopeContext[]{EclipseUtil.instanceScope(), EclipseUtil.defaultScope()};
    public static final String FILTER_DELIMITER = "####";
    private static final Pattern filterSplitter = Pattern.compile("####");
    private static final String CONTENT_TYPE_ID = "contentTypeId";
    private static final String CONTENT_TYPE_BINDING = "contentTypeBinding";
    private static final String PROJECT_NATURE_BINDING = "projectNatureBinding";
    private static final String NATURE_ID = "natureId";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String ATTR_PRIORITY = "priority";
    private static final String LAZY = "lazy";
    public static final int DEFAULT_PRIORITY = 50;
    private int fPriority = 50;
    private Set<IContentType> contentTypes = Collections.emptySet();
    private String fId;
    private String fName;
    private String contributor;
    private Set<String> projectNatures;
    private boolean lazy = false;
    private Map<String, Pattern> compiledFilters;

    @Override
    public int getPriority() {
        return this.fPriority;
    }

    @Override
    public Set<IContentType> getContentTypes() {
        return Collections.unmodifiableSet(this.contentTypes);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public boolean isEnabled(IBuildParticipant.BuildType type) {
        if (this.isRequired()) {
            return true;
        }
        if (type == IBuildParticipant.BuildType.RECONCILE) {
            return false;
        }
        return this.getPreferenceBoolean(this.getEnablementPreferenceKey(type));
    }

    protected String getEnablementPreferenceKey(IBuildParticipant.BuildType type) {
        return PreferenceUtil.getEnablementPreferenceKey(this.getId(), type);
    }

    @Override
    public void restoreDefaults() {
        if (this.isRequired()) {
            return;
        }
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(this.getPreferenceNode());
        prefs.remove(this.getEnablementPreferenceKey(IBuildParticipant.BuildType.BUILD));
        prefs.remove(this.getEnablementPreferenceKey(IBuildParticipant.BuildType.RECONCILE));
        prefs.remove(this.getFiltersPreferenceKey());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
        }
    }

    @Override
    public List<String> getFilters() {
        if (this.isRequired()) {
            return Collections.emptyList();
        }
        String rawFilters = this.getPreferenceString(this.getFiltersPreferenceKey());
        if (StringUtil.isEmpty((String)rawFilters)) {
            return Collections.emptyList();
        }
        return Arrays.asList(filterSplitter.split(rawFilters));
    }

    private String getFiltersPreferenceKey() {
        return PreferenceUtil.getFiltersKey(this.getId());
    }

    protected String getPreferenceNode() {
        return this.contributor;
    }

    @Override
    public void buildStarting(IProject project, int kind, IProgressMonitor monitor) {
    }

    @Override
    public void buildEnding(IProgressMonitor monitor) {
    }

    @Override
    public void clean(IProject project, IProgressMonitor monitor) {
    }

    protected int getLineNumber(int start, String source) {
        if (start < 0 || start >= source.length()) {
            return -1;
        }
        if (start == 0) {
            return 1;
        }
        Matcher m = StringUtil.LINE_SPLITTER.matcher(source.substring(0, start));
        int line = 1;
        while (m.find()) {
            int offset = m.start();
            if (offset > start) break;
            ++line;
        }
        return line;
    }

    protected Collection<IProblem> processCommentNode(String filePath, IDocument source, int initialOffset, int startingOffset, int endingOffset, String text, String commentEnding, boolean needSleep) {
        if (text == null) {
            return Collections.emptyList();
        }
        if (StringUtil.isEmpty((String)text)) {
            text = this.getText(source.get(), startingOffset, endingOffset);
        }
        if (!TaskTag.isCaseSensitive()) {
            text = text.toLowerCase();
        }
        Collection taskTags = TaskTag.getTaskTags();
        HashSet<TaskTag> tags = new HashSet<TaskTag>(taskTags.size());
        for (TaskTag entry : taskTags) {
            String tag = entry.getName();
            if (!TaskTag.isCaseSensitive()) {
                tag = tag.toLowerCase();
            }
            if (text.indexOf(tag) == -1) continue;
            tags.add(entry);
        }
        if (CollectionsUtil.isEmpty(tags)) {
            return Collections.emptyList();
        }
        String[] lines = StringUtil.LINE_SPLITTER.split(text);
        ArrayList<IProblem> tasks = new ArrayList<IProblem>();
        for (TaskTag entry : tags) {
            String tag = entry.getName();
            if (!TaskTag.isCaseSensitive()) {
                tag = tag.toLowerCase();
            }
            if (text.indexOf(tag) == -1) continue;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                int index = line.indexOf(tag);
                if (index != -1) {
                    String message = new String(line.substring(index).trim());
                    if (message.endsWith(commentEnding)) {
                        message = message.substring(0, message.length() - commentEnding.length()).trim();
                    }
                    int lineIndex = text.indexOf(line);
                    int start = startingOffset + lineIndex + index + initialOffset;
                    int lineNum = 0;
                    try {
                        lineNum = source.getLineOfOffset(start);
                    }
                    catch (BadLocationException badLocationException) {
                        lineNum = this.getLineNumber(start, source.get());
                    }
                    tasks.add(this.createTask(filePath, message, entry.getPriority(), lineNum, start, start + message.length()));
                }
                ++n2;
            }
        }
        return tasks;
    }

    protected Collection<IProblem> processCommentNode(String filePath, IDocument source, int initialOffset, IParseNode commentNode, String commentEnding, boolean needSleep) {
        if (commentNode == null) {
            return Collections.emptyList();
        }
        return this.processCommentNode(filePath, source, initialOffset, commentNode.getStartingOffset(), commentNode.getEndingOffset(), commentNode.getText(), commentEnding, needSleep);
    }

    protected Collection<IProblem> processCommentNode(String filePath, IDocument source, int initialOffset, Position commentNode, String commentEnding, boolean needSleep) {
        if (commentNode == null) {
            return Collections.emptyList();
        }
        String text = "";
        try {
            text = source.get(commentNode.getOffset(), commentNode.getLength());
        }
        catch (BadLocationException badLocationException) {
            return Collections.emptyList();
        }
        return this.processCommentNode(filePath, source, initialOffset, commentNode.getOffset(), commentNode.getOffset() + commentNode.getLength(), text, commentEnding, needSleep);
    }

    private String getText(String source, int startingOffset, int endingOffset) {
        if (source == null) {
            return "";
        }
        int start = Math.max(0, startingOffset);
        int end = Math.min(endingOffset + 1, source.length());
        return new String(source.substring(start, end));
    }

    protected IProblem createTask(String sourcePath, String message, Integer priority, int lineNumber, int offset, int endOffset) {
        return new Problem(0, message, offset, endOffset - offset, lineNumber, sourcePath, priority.intValue());
    }

    protected IProblem createInfo(String message, int lineNumber, int offset, int length, String sourcePath) {
        return new Problem(0, message, offset, length, lineNumber, sourcePath);
    }

    protected IProblem createWarning(String message, int lineNumber, int offset, int length, String sourcePath) {
        return new Problem(1, message, offset, length, lineNumber, sourcePath);
    }

    protected IProblem createError(String message, int lineNumber, int offset, int length, String sourcePath) {
        return new Problem(2, message, offset, length, lineNumber, sourcePath);
    }

    protected IProblem createQuickFixError(String message, int lineNumber, int offset, int length, String sourcePath) {
        Problem quickfix = new Problem(2, message, offset, length, lineNumber, sourcePath);
        quickfix.setQuickFixable(true);
        return quickfix;
    }

    protected boolean hasErrorOrWarningOnLine(List<IProblem> items, int line) {
        if (items == null) {
            return false;
        }
        for (IProblem item : items) {
            if (item.getLineNumber() != line) continue;
            return true;
        }
        return false;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String rawPriority = config.getAttribute(ATTR_PRIORITY);
        if (!StringUtil.isEmpty((String)rawPriority)) {
            try {
                this.fPriority = Integer.parseInt(rawPriority);
            }
            catch (NumberFormatException e) {
                IdeLog.logWarning((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Unable to parse priority value ({0}) as an integer, defaulting to 50.", rawPriority), (Throwable)e);
            }
        }
        this.lazy = Boolean.parseBoolean(config.getAttribute(LAZY));
        this.fId = config.getAttribute(ID);
        this.fName = config.getAttribute(NAME);
        this.contributor = config.getContributor().getName();
        IContentTypeManager manager = this.getContentTypeManager();
        IConfigurationElement[] rawContentTypes = config.getChildren(CONTENT_TYPE_BINDING);
        this.contentTypes = new HashSet<IContentType>(rawContentTypes.length);
        IConfigurationElement[] iConfigurationElementArray = rawContentTypes;
        int n = rawContentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement contentTypeBinding = iConfigurationElementArray[n2];
            String contentTypeId = contentTypeBinding.getAttribute(CONTENT_TYPE_ID);
            IContentType type = manager.getContentType(contentTypeId);
            if (type != null) {
                this.contentTypes.add(type);
            }
            ++n2;
        }
        IConfigurationElement[] rawProjectNatures = config.getChildren(PROJECT_NATURE_BINDING);
        this.projectNatures = new HashSet<String>(rawContentTypes.length);
        IConfigurationElement[] iConfigurationElementArray2 = rawProjectNatures;
        int n3 = rawProjectNatures.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement projectNatureBinding = iConfigurationElementArray2[n];
            String natureId = projectNatureBinding.getAttribute(NATURE_ID);
            if (!StringUtil.isEmpty((String)natureId)) {
                this.projectNatures.add(natureId);
            }
            ++n;
        }
    }

    protected IContentTypeManager getContentTypeManager() {
        return Platform.getContentTypeManager();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isEnabled(IProject project) {
        if (CollectionsUtil.isEmpty(this.projectNatures)) {
            return true;
        }
        try {
            String[] natureIds;
            String[] stringArray = natureIds = project.getDescription().getNatureIds();
            int n = natureIds.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String natureId = stringArray[n2];
                if (this.projectNatures.contains(natureId)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
        }
        return false;
    }

    protected synchronized boolean isIgnored(String message, List<String> expressions) {
        if (CollectionsUtil.isEmpty(expressions)) {
            return false;
        }
        if (this.compiledFilters == null) {
            this.compiledFilters = new HashMap<String, Pattern>(expressions.size());
        }
        for (String expression : expressions) {
            Pattern p = this.compiledFilters.get(expression);
            if (p == null) {
                p = Pattern.compile(expression);
                this.compiledFilters.put(expression, p);
            }
            if (!p.matcher(message).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getPreferenceString(String prefKey) {
        return Platform.getPreferencesService().getString(this.getPreferenceNode(), prefKey, null, CONTEXTS);
    }

    @Override
    public boolean getPreferenceBoolean(String prefKey) {
        return Platform.getPreferencesService().getBoolean(this.getPreferenceNode(), prefKey, false, CONTEXTS);
    }

    @Override
    public int getPreferenceInt(String prefKey, int defaultValue) {
        return Platform.getPreferencesService().getInt(this.getPreferenceNode(), prefKey, defaultValue, CONTEXTS);
    }

    @Override
    public IBuildParticipantWorkingCopy getWorkingCopy() {
        return new BuildParticipantWorkingCopy(this, this.getPreferenceNode());
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public Set<IFile> relatedFile(BuildContext context, IBuildParticipant.RelatedType type, IProgressMonitor monitor) {
        return null;
    }
}

