/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.buildpath.core;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.buildpath.core.BuildPathEntry;
import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.index.core.IIndexFileContributor;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;

public class BuildPathIndexContributor
implements IIndexFileContributor {
    public Set<IFileStore> getFiles(URI containerURI) {
        Object[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(containerURI);
        if (ArrayUtil.isEmpty((Object[])containers)) {
            return Collections.emptySet();
        }
        HashSet<IFileStore> result = new HashSet<IFileStore>();
        Object[] objectArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            Object container = objectArray[n2];
            if (container instanceof IProject) {
                IProject project = (IProject)container;
                Set<BuildPathEntry> entries = BuildPathManager.getInstance().getBuildPaths(project);
                if (entries != null) {
                    for (BuildPathEntry entry : entries) {
                        try {
                            IFileStore fileStore = EFS.getStore((URI)entry.getPath());
                            result.add(fileStore);
                        }
                        catch (CoreException e) {
                            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
                        }
                    }
                }
            }
            ++n2;
        }
        return result;
    }
}

