/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.formatter.epl.FormatterPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public final class PreferenceKey {
    private final String fQualifier;
    private final String fKey;

    public PreferenceKey(String qualifier, String key) {
        assert (qualifier != null);
        assert (key != null);
        this.fQualifier = qualifier;
        this.fKey = key;
    }

    public String getName() {
        return this.fKey;
    }

    public void flush(IScopeContext context) {
        IEclipsePreferences node = context.getNode(this.fQualifier);
        if (node != null) {
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                IdeLog.logError((Plugin)FormatterPlugin.getDefault(), (String)"Error flushing a node", (Throwable)e, (String)"com.aptana.formatter.epl/debug");
            }
        }
    }

    private IEclipsePreferences getNode(IScopeContext context, IWorkingCopyManager manager) {
        IEclipsePreferences node = context.getNode(this.fQualifier);
        if (manager != null) {
            return manager.getWorkingCopy(node);
        }
        return node;
    }

    public String getStoredValue(IScopeContext context) {
        return this.getStoredValue(context, null);
    }

    public String getStoredValue(IScopeContext context, IWorkingCopyManager manager) {
        return this.getNode(context, manager).get(this.fKey, null);
    }

    public String getStoredValue(IScopeContext[] lookupOrder, boolean ignoreTopScope, IWorkingCopyManager manager) {
        int i = ignoreTopScope ? 1 : 0;
        while (i < lookupOrder.length) {
            String value = this.getStoredValue(lookupOrder[i], manager);
            if (value != null) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public void setStoredValue(IScopeContext context, String value, IWorkingCopyManager manager) {
        if (value != null) {
            this.getNode(context, manager).put(this.fKey, value);
        } else {
            this.getNode(context, manager).remove(this.fKey);
        }
    }

    public void setStoredValue(IScopeContext context, String value) {
        this.setStoredValue(context, value, null);
    }

    public int hashCode() {
        return this.fQualifier.hashCode() ^ this.fKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PreferenceKey) {
            PreferenceKey other = (PreferenceKey)obj;
            return this.fKey.equals(other.fKey) && this.fQualifier.equals(other.fQualifier);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.fQualifier) + '/' + this.fKey;
    }

    public String getQualifier() {
        return this.fQualifier;
    }
}

