/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.IFormatterNode;

public abstract class AbstractFormatterNode
implements IFormatterNode {
    private static final String SPACES = "                                                    ";
    private final IFormatterDocument document;

    public AbstractFormatterNode(IFormatterDocument document) {
        this.document = document;
    }

    @Override
    public IFormatterDocument getDocument() {
        return this.document;
    }

    protected String getShortClassName() {
        String name = this.getClass().getName();
        int index = name.lastIndexOf(46);
        return index > 0 ? name.substring(index + 1) : name;
    }

    public String toString() {
        return this.getShortClassName();
    }

    protected int getInt(String key) {
        return this.document.getInt(key);
    }

    protected void writeSpaces(IFormatterWriter visitor, IFormatterContext context, int count) {
        if (count > 0) {
            if (SPACES.length() > count) {
                visitor.writeText(context, SPACES.substring(0, count));
            } else {
                StringBuilder builder = new StringBuilder(SPACES.length() * 2);
                while (builder.length() < count) {
                    builder.append(SPACES);
                }
                visitor.writeText(context, builder.substring(0, count));
            }
        }
    }

    @Override
    public boolean shouldConsumePreviousWhiteSpaces() {
        return false;
    }

    @Override
    public int getSpacesCountBefore() {
        return 0;
    }

    @Override
    public int getSpacesCountAfter() {
        return 0;
    }
}

