/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter;

import com.aptana.formatter.IFormatterDocument;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IRegion;

public class FormatterDocument
implements IFormatterDocument {
    private final String text;
    private final Map<String, Boolean> booleans = new HashMap<String, Boolean>();
    private final Map<String, String> strings = new HashMap<String, String>();
    private final Map<String, Integer> ints = new HashMap<String, Integer>();
    private final Map<String, Set<String>> sets = new HashMap<String, Set<String>>();

    public FormatterDocument(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int getLength() {
        return this.text.length();
    }

    @Override
    public String get(int startOffset, int endOffset) {
        return this.text.substring(startOffset, endOffset);
    }

    @Override
    public String get(IRegion region) {
        return this.get(region.getOffset(), region.getOffset() + region.getLength());
    }

    public void setBoolean(String key, boolean value) {
        this.booleans.put(key, value);
    }

    @Override
    public boolean getBoolean(String key) {
        Boolean value = this.booleans.get(key);
        return value != null && value != false;
    }

    public void setString(String key, String value) {
        this.strings.put(key, value);
    }

    @Override
    public String getString(String key) {
        return this.strings.get(key);
    }

    public void setInt(String key, int value) {
        this.ints.put(key, new Integer(value));
    }

    @Override
    public int getInt(String key) {
        Integer value = this.ints.get(key);
        return value != null ? value : 0;
    }

    public void setSet(String key, Set<String> set) {
        this.sets.put(key, set);
    }

    @Override
    public Set<String> getSet(String key) {
        return this.sets.get(key);
    }

    @Override
    public char charAt(int index) {
        return this.text.charAt(index);
    }
}

