/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.index.service;

import com.pandora.index.service.ILinkedBlockingQueueService;
import com.pandora.index.service.ILocalIndexService;
import com.pandora.index.service.IRemoteIndexService;
import java.rmi.Naming;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class IndexServicePlugin
implements BundleActivator {
    private static BundleContext context;
    private static IndexServicePlugin plugin;
    ILocalIndexService localService;
    IRemoteIndexService remoteService;
    ILinkedBlockingQueueService linkedBlockingQueueService;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    public static IndexServicePlugin getDefault() {
        return plugin;
    }

    public ILocalIndexService getLocalIndexService(BundleActivator bundle) throws Exception {
        if (bundle != null) {
            Thread.currentThread().setContextClassLoader(bundle.getClass().getClassLoader());
        }
        if (this.localService == null) {
            this.localService = (ILocalIndexService)Naming.lookup("rmi://127.0.0.1:56789/index");
        }
        return this.localService;
    }

    public IRemoteIndexService getRemoteIndexService(BundleActivator bundle) throws Exception {
        if (bundle != null) {
            Thread.currentThread().setContextClassLoader(bundle.getClass().getClassLoader());
        }
        if (this.remoteService == null) {
            this.remoteService = (IRemoteIndexService)Naming.lookup("rmi://127.0.0.1:45678/index");
        }
        return this.remoteService;
    }

    public ILinkedBlockingQueueService getLinkedBlockingQueueService() {
        return this.linkedBlockingQueueService;
    }

    public void setLinkedBlockingQueueService(ILinkedBlockingQueueService linkedBlockingQueueService) {
        this.linkedBlockingQueueService = linkedBlockingQueueService;
    }

    public void restartRemoteService() throws Exception {
        this.remoteService = null;
    }
}

