/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.browser.remote.debug.domain;

import com.pandora.browser.remote.debug.RemoteDebugActivator;
import com.pandora.browser.remote.debug.domain.AbstractDomain;
import com.pandora.browser.remote.debug.listener.MessageListener;
import com.pandora.core.log.HBLog;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.runtime.Plugin;

public class RunTime
extends AbstractDomain {
    public static final String RUNTIME_GETPROPERTIES = "Runtime.getProperties";
    public static final String RUNTIME_CALLFUNCTIONON = "Runtime.callFunctionOn";
    public static final String RUNTIME_EVALUATE = "Runtime.evaluate";
    public static final String RUNTIME_RELEASEOBJECT = "Runtime.releaseObject";
    public static final String RUNTIME_RELEASEOBJECTGROUP = "Runtime.releaseObjectGroup";

    public boolean getProperties(String objectId, MessageListener messageRouter) {
        if (!this.checkClient() || objectId == null) {
            return false;
        }
        try {
            JSONObject params = new JSONObject();
            params.put("ownProperties", true);
            params.put("objectId", (Object)objectId);
            return this.remoteDebugClient.send(RUNTIME_GETPROPERTIES, params, messageRouter);
        }
        catch (JSONException e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
            return false;
        }
    }

    public boolean callFunctionOn(String objectId, String function, MessageListener messageRouter) {
        if (!this.checkClient() || objectId == null || function == null) {
            return false;
        }
        try {
            JSONObject params = new JSONObject();
            params.put("functionDeclaration", (Object)function);
            params.put("objectId", (Object)objectId);
            return this.remoteDebugClient.send(RUNTIME_CALLFUNCTIONON, params, messageRouter);
        }
        catch (JSONException e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
            return false;
        }
    }

    public boolean evaluate(String expression, String objectGroup, MessageListener messageRouter) {
        if (!this.checkClient() || expression == null) {
            return false;
        }
        try {
            JSONObject params = new JSONObject();
            params.put("expression", (Object)expression);
            if (objectGroup != null) {
                params.put("objectGroup", (Object)objectGroup);
            }
            params.put("includeCommandLineAPI", true);
            params.put("generatePreview", false);
            return this.remoteDebugClient.send(RUNTIME_EVALUATE, params, messageRouter);
        }
        catch (JSONException e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
            return false;
        }
    }

    public boolean releaseObject(String objectId, MessageListener messageRouter) {
        if (!this.checkClient() || objectId == null) {
            return false;
        }
        try {
            JSONObject params = new JSONObject();
            params.put("objectId", (Object)objectId);
            return this.remoteDebugClient.send(RUNTIME_RELEASEOBJECT, params, messageRouter);
        }
        catch (JSONException e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
            return false;
        }
    }

    public boolean releaseObjectGroup(String objectGroup, MessageListener messageRouter) {
        if (!this.checkClient() || objectGroup == null) {
            return false;
        }
        try {
            JSONObject params = new JSONObject();
            params.put("objectGroup", (Object)objectGroup);
            return this.remoteDebugClient.send(RUNTIME_RELEASEOBJECTGROUP, params, messageRouter);
        }
        catch (JSONException e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
            return false;
        }
    }
}

