/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.push.polling;

import com.pandora.core.auth.UserAuth;
import com.pandora.core.auth.UserAuthService;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.core.log.HBLog;
import com.pandora.core.ui.notifications.AbstractNotification;
import com.pandora.core.ui.notifications.MessageNotification;
import com.pandora.core.ui.notifications.NotificationAction;
import com.pandora.core.ui.notifications.NotificationFactory;
import com.pandora.core.ui.notifications.NotificationSender;
import com.pandora.push.PushActivator;
import com.pandora.ui.EventControlContributionHandler;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class EventPolling {
    private Random random = new Random();
    private Job pollingJob;
    private static Set<Integer> remindedMessages = new HashSet<Integer>();
    private static EventPolling eventPolling = new EventPolling();

    private EventPolling() {
    }

    public static EventPolling getInstance() {
        return eventPolling;
    }

    public void startPolling() {
        if (this.pollingJob == null) {
            this.pollingJob = new Job("\u6d3b\u52a8\u6d88\u606f\u8f6e\u8be2\u4efb\u52a1"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!Platform.isRunning()) {
                        return Status.OK_STATUS;
                    }
                    if (UserAuth.isLoginSucess() == 1) {
                        try {
                            JSONObject body;
                            HttpClientUtils httpclient = HttpClientUtils.getInstance((String)"EventAction!polling");
                            ResponseObj responseObj = httpclient.excute();
                            if (responseObj.isOk() && (body = (JSONObject)responseObj.getBody()) != null && body.has("status")) {
                                int status = body.optInt("status");
                                if (status == -1) {
                                    return Status.OK_STATUS;
                                }
                                if (status != 0 && remindedMessages.add(status) && body.has("title")) {
                                    final String[] title = new String[]{body.optString("title")};
                                    ResponseObj event = UserAuthService.checkIsDuringEvent((String)UserAuth.getUsername());
                                    if (event.isOk() && ((JSONObject)event.getBody()).has("title")) {
                                        title[0] = ((JSONObject)event.getBody()).optString("title");
                                    }
                                    NotificationAction action = null;
                                    if (body.optBoolean("link")) {
                                        action = new NotificationAction("\u67e5\u770b\u8be6\u60c5"){

                                            public void execute() {
                                                EventControlContributionHandler.showActivityDialog((String)title[0], (boolean)false);
                                            }
                                        };
                                    }
                                    MessageNotification msg = NotificationFactory.getInstance().createWorkbenchInfoNotify("\u6d3b\u52a8\u63d0\u9192", title[0], new NotificationAction[]{action});
                                    msg.setDelayClose(Integer.MAX_VALUE);
                                    NotificationSender.getInstance().notify(new AbstractNotification[]{msg});
                                }
                            }
                        }
                        catch (Throwable e) {
                            HBLog.logError((Plugin)PushActivator.getDefault(), (Throwable)e);
                        }
                    }
                    EventPolling.this.pollingJob.schedule(EventPolling.this.getPollingInterval());
                    return Status.OK_STATUS;
                }
            };
        }
        this.pollingJob.setSystem(true);
        this.pollingJob.schedule(30000L);
    }

    private long getPollingInterval() {
        long interval = (long)((this.random.nextDouble() + 5.0) * 1000.0 * 60.0);
        return interval;
    }
}

