/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.core.util;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.IUniformResource;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.SocketUtil;
import com.aptana.debug.core.DebugCorePlugin;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;

public final class DebugUtil {
    private static final Set<String> LOCAL_HOSTS = CollectionsUtil.newSet((Object[])new String[]{"lo", "lo0", "localhost", "127.0.0.1"});
    private static final int DEFAULT_PORT = 8999;
    private static final int SOCKET_TIMEOUT = 30000;

    private DebugUtil() {
    }

    public static Object findAdapter(IAdaptable adaptableObject, Class<?> adapterType) {
        ILaunch launch;
        Object result = null;
        if (adaptableObject != null && (result = adaptableObject.getAdapter(adapterType)) == null && (launch = (ILaunch)adaptableObject.getAdapter(ILaunch.class)) != null) {
            IProcess[] iProcessArray = launch.getProcesses();
            int n = iProcessArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess process = iProcessArray[n2];
                result = process.getAdapter(adapterType);
                if (result != null) break;
                ++n2;
            }
        }
        return result;
    }

    public static String getPath(Object element) {
        if (element instanceof IUniformResource) {
            IStorage storage;
            IUniformResource resource = (IUniformResource)element;
            IPath path = (IPath)resource.getAdapter(IPath.class);
            if (path == null && (storage = (IStorage)resource.getAdapter(IStorage.class)) != null) {
                path = (IPath)storage.getAdapter(IPath.class);
            }
            if (path != null) {
                return path.toOSString();
            }
            return resource.getURI().toString();
        }
        if (element instanceof String) {
            try {
                element = new URI((String)element);
            }
            catch (URISyntaxException ignore) {
                ignore.getCause();
            }
        }
        if (element instanceof URI) {
            URI uri = (URI)element;
            if ("file".equals(uri.getScheme())) {
                return uri.getSchemeSpecificPart();
            }
            return uri.toString();
        }
        return null;
    }

    public static int getDebuggerPort() {
        int port = SocketUtil.findFreePort(null);
        if (EclipseUtil.isDebugOptionEnabled((String)"com.aptana.debug.core/debugger_debug")) {
            port = 2525;
        }
        if (port == -1) {
            port = 8999;
        }
        return port;
    }

    public static ServerSocket allocateServerSocket(int port) throws IOException {
        ServerSocket socket = new ServerSocket(port);
        socket.setReuseAddress(true);
        if (!EclipseUtil.isDebugOptionEnabled((String)"com.aptana.debug.core/debugger_debug")) {
            socket.setSoTimeout(30000);
        }
        return socket;
    }

    public static List<String> getHostIPs() {
        ArrayList<String> hosts = new ArrayList<String>(5);
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface nextInterface = interfaces.nextElement();
                String interfaceName = nextInterface.getName();
                if (LOCAL_HOSTS.contains(interfaceName.toLowerCase())) continue;
                Enumeration<InetAddress> inetAddresses = nextInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress address = inetAddresses.nextElement();
                    if (address instanceof Inet6Address) continue;
                    String addressString = address.toString();
                    if (addressString.startsWith("/")) {
                        addressString = addressString.substring(1);
                    }
                    hosts.add(addressString);
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)DebugCorePlugin.getDefault(), (String)"Error resolving hosts", (Throwable)e);
        }
        return hosts;
    }
}

