/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.parsing;

import com.aptana.ruby.internal.debug.core.model.ThreadInfo;
import com.aptana.ruby.internal.debug.core.parsing.AbstractReadStrategy;
import com.aptana.ruby.internal.debug.core.parsing.XmlStreamReader;
import com.aptana.ruby.internal.debug.core.parsing.XmlStreamReaderException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ThreadInfoReader
extends XmlStreamReader {
    private List<ThreadInfo> threads = new ArrayList<ThreadInfo>();

    public ThreadInfoReader(XmlPullParser xpp) {
        super(xpp);
    }

    public ThreadInfoReader(AbstractReadStrategy readStrategy) {
        super(readStrategy);
    }

    public ThreadInfo[] readThreads() throws XmlPullParserException, IOException, XmlStreamReaderException {
        this.read();
        return this.threads.toArray(new ThreadInfo[this.threads.size()]);
    }

    @Override
    protected boolean processStartElement(XmlPullParser xpp) {
        String name = xpp.getName();
        if (name.equals("threads")) {
            return true;
        }
        if (name.equals("thread")) {
            int id = Integer.parseInt(xpp.getAttributeValue("", "id"));
            String status = xpp.getAttributeValue("", "status");
            this.threads.add(new ThreadInfo(id, status));
            return true;
        }
        return false;
    }

    @Override
    protected boolean processEndElement(XmlPullParser xpp) {
        return xpp.getName().equals("threads");
    }
}

