/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.ui.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.UniformResourceStorage;
import com.aptana.debug.core.IActiveResourcePathGetterAdapter;
import com.aptana.debug.ui.DebugUiPlugin;
import com.aptana.debug.ui.internal.UniformResourceStorageEditorInput;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;

public class ActiveResourcePathGetterAdapter
implements IActiveResourcePathGetterAdapter {
    public IResource getActiveResource() {
        final IResource[] result = new IResource[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (editorPart != null) {
                    IEditorInput editorInput = editorPart.getEditorInput();
                    result[0] = editorInput instanceof IFileEditorInput ? ((IFileEditorInput)editorInput).getFile() : (IResource)editorInput.getAdapter(IFile.class);
                }
            }
        });
        if (result[0] != null) {
            result[0] = this.findConnectedResource(result[0]);
        }
        return result[0];
    }

    public IPath getActiveResourcePath() {
        final IPath[] result = new IPath[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (editorPart != null) {
                    IEditorInput editorInput = editorPart.getEditorInput();
                    IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput.getAdapter(IFileEditorInput.class);
                    IPathEditorInput pathEditorInput = (IPathEditorInput)editorInput.getAdapter(IPathEditorInput.class);
                    if (fileEditorInput != null) {
                        result[0] = fileEditorInput.getFile().getLocation();
                    } else if (pathEditorInput != null) {
                        result[0] = pathEditorInput.getPath();
                    }
                }
            }
        });
        if (result[0] != null) {
            result[0] = this.findConnectedPath(result[0]);
        }
        return result[0];
    }

    public URL getActiveResourceURL() {
        final URL[] result = new URL[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IStorage storage;
                IEditorInput editorInput;
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (editorPart != null && (editorInput = editorPart.getEditorInput()) instanceof UniformResourceStorageEditorInput && (storage = ((UniformResourceStorageEditorInput)editorInput).getStorage()) instanceof UniformResourceStorage) {
                    try {
                        result[0] = ((UniformResourceStorage)storage).getURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
        });
        return result[0];
    }

    public IResource getCurrentSelectionResource() {
        final IResource[] result = new IResource[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Object part;
                Object element;
                Object object;
                IEditorPart part2;
                IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
                ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
                Object selection = selectionService.getSelection();
                if (selection instanceof ITextSelection && (part2 = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null && (object = part2.getEditorInput().getAdapter(IFile.class)) != null) {
                    result[0] = (IResource)object;
                }
                if (result[0] == null && (selection = selectionService.getSelection("org.eclipse.ui.navigator.ProjectExplorer")) instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
                    result[0] = (IResource)element;
                }
                IEvaluationContext currentState = evaluationService.getCurrentState();
                selection = currentState.getVariable("selection");
                if (result[0] == null && selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
                    result[0] = (IResource)object;
                }
                if (result[0] == null && (part = currentState.getVariable("activeEditorInput")) instanceof IFileEditorInput) {
                    result[0] = ((IFileEditorInput)part).getFile();
                }
            }
        });
        return result[0];
    }

    private IResource findConnectedResource(IResource resource) {
        IFile file;
        IPath location = resource.getLocation();
        IPath path = this.findConnectedPath(location);
        if (path != location && (file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path)) != null) {
            return file;
        }
        return resource;
    }

    private IPath findConnectedPath(IPath path) {
        return path;
    }

    public static class Factory
    implements IAdapterFactory {
        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (IActiveResourcePathGetterAdapter.class.equals((Object)adapterType)) {
                return new ActiveResourcePathGetterAdapter();
            }
            return null;
        }

        public Class[] getAdapterList() {
            return new Class[]{IActiveResourcePathGetterAdapter.class};
        }
    }
}

