/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.quicksearch.ui.internal.quicksearch;

import com.pandora.quicksearch.ui.QuickSearchActivator;
import com.pandora.quicksearch.ui.QuickSearchUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class GotoLineElement
extends QuickAccessElement {
    public static final String ID = "com.pandora.quicksearch.ui.internal.quicksearch.GotoLineElement";
    private String line;

    public GotoLineElement(QuickAccessProvider provider, int line) {
        super(provider);
        this.line = String.valueOf(line);
    }

    public String getLabel() {
        return this.line;
    }

    public String getSortLabel() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = String.valueOf(line);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)QuickSearchUtil.PROPERTY_IMAGE);
    }

    public String getId() {
        return ID;
    }

    public void execute() {
        IWorkbenchWindow workbenchWindow = QuickSearchActivator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            return;
        }
        IEditorPart editorPart = page.getActiveEditor();
        if (editorPart == null) {
            return;
        }
        if (editorPart instanceof AbstractTextEditor) {
            editorPart.setFocus();
            AbstractTextEditor editor = (AbstractTextEditor)editorPart;
            IDocumentProvider provider = editor.getDocumentProvider();
            IDocument document = provider.getDocument((Object)editor.getEditorInput());
            try {
                int l = Integer.parseInt(this.line);
                if (l < 1) {
                    return;
                }
                int start = document.getLineOffset(l - 1);
                editor.selectAndReveal(start, 0);
                page.activate((IWorkbenchPart)editor);
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

