/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.quicksearch.ui;

import com.pandora.core.index.QuickSearchType;
import com.pandora.core.log.HBLog;
import com.pandora.core.ui.ImageSelectWidget;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.SearchUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.core.utils.ThemeUtil;
import com.pandora.quicksearch.ui.IFocusHandler;
import com.pandora.quicksearch.ui.QuickSearchActivator;
import com.pandora.quicksearch.ui.QuickSearchDialog;
import com.pandora.quicksearch.ui.QuickSearchUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.internal.ui.SearchDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.wb.swt.ResourceManager;

public class QuickSearchText
extends WorkbenchWindowControlContribution
implements IFocusHandler {
    private static Image CLOSE_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/close.png");
    private static Image CLOSE_HOVER_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/close_hover.png");
    private static Image CLOSE_DOWN_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/close_down.png");
    private static Image UP_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/up.png");
    private static Image UP_HOVER_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/up_hover.png");
    private static Image UP_DOWN_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/up_down.png");
    private static Image DOWN_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/down.png");
    private static Image DOWN_HOVER_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/down_hover.png");
    private static Image DOWN_DOWN_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/down_down.png");
    private static QuickSearchDialog quickSearchDialog;
    private IFocusHandler handler;
    private Text searchText;
    private static Rectangle rectangle;
    private Composite parent;
    private ImageSelectWidget closeImageSelectWidget;
    private ImageSelectWidget downImageSelectWidget;
    private ImageSelectWidget upImageSelectWidget;
    private boolean isFocused;
    private Runnable themeChangeListener;
    private Job searchJob;
    private String fileName;
    private static Color warnColor;
    public static Font font;
    private int ph = 0;
    private boolean searchForward = true;
    private boolean needWarn;
    private QuickSearchType preType;
    private boolean isSetted;

    static {
        rectangle = null;
    }

    public QuickSearchText() {
    }

    public QuickSearchText(String id) {
        super(id);
    }

    protected Control createControl(Composite parent) {
        Composite main;
        this.handler = this;
        QuickSearchUtil.setFocusHandler(this.handler);
        this.parent = main = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 1;
        main.setLayout((Layout)gridLayout);
        String defaultFontName = "\u5fae\u8f6f\u96c5\u9ed1";
        int fontSize = 10;
        int defaultStyle = 0;
        if (PlatformUtil.isMac()) {
            Font dFont = JFaceResources.getDefaultFont();
            if (dFont != null) {
                FontData fd = dFont.getFontData()[0];
                defaultFontName = fd.getName();
            } else {
                defaultFontName = "consolas";
            }
            fontSize = 14;
        }
        final Composite composite = new Composite(main, 2048);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).spacing(0, 0).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        this.searchText = new Text(composite, 0);
        font = new Font((Device)this.searchText.getDisplay(), defaultFontName, fontSize, defaultStyle);
        this.setMessage(SearchUtil.getQuickSearchDoubleKeyValue());
        this.searchText.setLayoutData((Object)GridDataFactory.fillDefaults().hint(220, -1).grab(true, true).create());
        this.searchText.setFont(font);
        Point point = this.searchText.computeSize(-1, -1);
        Point ppoint = composite.computeSize(-1, -1);
        int num = 0;
        while (point.y > ppoint.y && num++ < 10) {
            --fontSize;
            font.dispose();
            try {
                font = new Font((Device)this.searchText.getDisplay(), defaultFontName, fontSize, defaultStyle);
                this.searchText.setFont(font);
                point = this.searchText.computeSize(-1, -1);
                ppoint = composite.computeSize(-1, -1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (PlatformUtil.isMac()) {
            this.ph = 5;
        }
        this.searchText.setToolTipText("\u6ce8\uff1a\u9ed8\u8ba4\u641c\u7d22\u662f\u5f53\u524d\u7f16\u8f91\u5668\u5355\u8bcd\uff0c\u8f93\u5165\u201c@\u201d\u53f7\u540e\u641c\u7d22\u76f8\u5173\u53d8\u91cf\uff0c\r\n\u8f93\u5165\u201c:\u201d\u53f7\u540e\u662f\u8f6c\u5230\u884c\uff0c\u8f93\u5165\u201c/\u201d\u53f7\u540e\u641c\u7d22\u6587\u4ef6\uff0c\r\n\u8f93\u5165\u201c!\u201d\u53f7\u540e\u641c\u7d22\u529f\u80fd\uff0c\u8f93\u5165\u201c?\u201d\u53f7\u540e\u641c\u7d22\u95ee\u7b54");
        main.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (QuickSearchText.this.isNeedWarn()) {
                    if (warnColor == null) {
                        QuickSearchText.this.createHighColor(main);
                    }
                    e.gc.setForeground(warnColor);
                    e.gc.setLineWidth(3);
                    e.gc.drawRectangle(0, 0, main.getBounds().width, main.getBounds().height - QuickSearchText.this.ph);
                }
            }
        });
        this.searchText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                QuickSearchText.this.isFocused = false;
                if (quickSearchDialog != null && !quickSearchDialog.isFocused()) {
                    quickSearchDialog.close();
                }
                QuickSearchDialog.needClose_ = false;
                QuickSearchText.this.highText(main, false);
            }

            public void focusGained(FocusEvent e) {
                QuickSearchText.this.isFocused = true;
                if (QuickSearchText.this.isNeedWarn()) {
                    QuickSearchText.this.highText(main, true);
                    e.display.timerExec(150, new Runnable(){

                        @Override
                        public void run() {
                            QuickSearchText.this.highText(main, false);
                        }
                    });
                    e.display.timerExec(300, new Runnable(){

                        @Override
                        public void run() {
                            QuickSearchText.this.highText(main, true);
                        }
                    });
                    e.display.timerExec(450, new Runnable(){

                        @Override
                        public void run() {
                            QuickSearchText.this.highText(main, false);
                        }
                    });
                    e.display.timerExec(600, new Runnable(){

                        @Override
                        public void run() {
                            QuickSearchText.this.highText(main, true);
                        }
                    });
                } else {
                    QuickSearchText.this.highText(main, true);
                }
                if (StringUtil.isBlank((String)QuickSearchText.this.getFilterText())) {
                    return;
                }
                if (QuickSearchText.this.isSetted) {
                    QuickSearchText.this.isSetted = false;
                    QuickSearchText.this.openSearchDialog(true);
                } else {
                    QuickSearchText.this.openSearchDialog(false);
                }
            }
        });
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int delay = 0;
                QuickSearchType type = QuickSearchUtil.getSearchType();
                boolean visible = false;
                if (StringUtil.isNotBlank((String)QuickSearchText.this.getFilterText())) {
                    visible = true;
                }
                if (QuickSearchUtil.getSearchType() != type && quickSearchDialog != null) {
                    quickSearchDialog.setNeedClose(true);
                    QuickSearchText.this.closeDialog();
                    quickSearchDialog.setNeedClose(false);
                }
                if (QuickSearchType.ASK == QuickSearchUtil.getSearchType()) {
                    delay = 50;
                }
                QuickSearchText.this.showImage(visible);
                if (QuickSearchText.this.searchJob != null && QuickSearchText.this.searchJob.getState() != 4) {
                    QuickSearchText.this.searchJob.cancel();
                }
                QuickSearchText.this.searchJob = new Job("\u4e00\u952e\u641c\u7d22"){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (QuickSearchText.this.isSetted) {
                                    QuickSearchText.this.isSetted = false;
                                    QuickSearchText.this.openSearchDialog(true);
                                    if (quickSearchDialog != null && quickSearchDialog.isOpened()) {
                                        QuickSearchText.this.searchText.setFocus();
                                    }
                                } else {
                                    QuickSearchText.this.openSearchDialog(false);
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                QuickSearchText.this.searchJob.setUser(false);
                QuickSearchText.this.searchJob.setSystem(true);
                QuickSearchText.this.searchJob.schedule((long)delay);
            }
        });
        this.searchText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                char key = e.character;
                if ((e.stateMask & SWT.MOD2) != 0) {
                    return;
                }
                if ((e.stateMask & SWT.MOD3) != 0) {
                    return;
                }
                if (PlatformUtil.isMac() && (e.stateMask & SWT.MOD4) != 0) {
                    return;
                }
                switch (key) {
                    case '\u001b': {
                        QuickSearchText.this.closeDialog();
                        IEditorPart editorPart = QuickSearchText.this.getEditorPart();
                        if (editorPart != null) {
                            editorPart.setFocus();
                        }
                    }
                    case '\n': 
                    case '\r': {
                        if (QuickSearchUtil.getSearchType() != QuickSearchType.DEFAULT && (e.stateMask & SWT.MOD1) != 0) {
                            quickSearchDialog.handleSelection(2);
                            return;
                        }
                        if (quickSearchDialog != null && !quickSearchDialog.isClosed() && quickSearchDialog.getSelectionCount() > 0) {
                            quickSearchDialog.handleSelection(-1);
                            break;
                        }
                        if (QuickSearchUtil.getSearchType() != QuickSearchType.DEFAULT) break;
                        QuickSearchText.this.findAndSelect(true);
                        break;
                    }
                }
                if (e.keyCode == 104 && (e.stateMask & SWT.MOD1) != 0) {
                    QuickSearchText.this.openSeniorSearchDialog();
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    e.doit = false;
                    QuickSearchText.this.setSelection(1);
                    return;
                }
                if (e.keyCode == 0x1000001) {
                    e.doit = false;
                    QuickSearchText.this.setSelection(-1);
                    return;
                }
                if (e.keyCode == 104) {
                    if (e.stateMask == SWT.MOD1) {
                        e.doit = false;
                    }
                    return;
                }
                if (e.character == '\n' || e.character == '\r') {
                    e.doit = false;
                    if (e.stateMask == SWT.MOD2) {
                        e.doit = false;
                        QuickSearchText.this.openSeniorSearchDialog();
                    } else if (e.stateMask == SWT.MOD1) {
                        e.doit = false;
                    }
                }
            }
        });
        this.createImage(composite, false);
        this.hookUpSelectAll();
        this.themeChangeListener = new Runnable(){

            @Override
            public void run() {
                try {
                    if (QuickSearchText.this.searchText.isDisposed()) {
                        return;
                    }
                    QuickSearchText.this.setForeground(ThemeUtil.getForegroundColor());
                    if (composite.isDisposed()) {
                        return;
                    }
                    composite.setBackground(ThemeUtil.getBackgroundColor());
                }
                catch (Throwable e) {
                    HBLog.logError((Plugin)QuickSearchActivator.getDefault(), (Throwable)e);
                }
            }
        };
        return main;
    }

    @Override
    public void setMessage(boolean b) {
        String message = "";
        if (PlatformUtil.isMac()) {
            message = "\u641c\u7d22                                                ";
            if (b) {
                message = "\u641c\u7d22\uff08\u53cc\u51fbcontrol\uff09              ";
            }
            this.searchText.setMessage(message);
        } else {
            message = "\u641c\u7d22                                                                        ";
            if (b) {
                message = "\u641c\u7d22\uff08\u53cc\u51fbCtrl\uff09                                               ";
            }
            this.searchText.setMessage(message);
        }
    }

    private void hookUpSelectAll() {
        IFocusService focus = (IFocusService)this.getWorkbenchWindow().getService(IFocusService.class);
        focus.addFocusTracker((Control)this.searchText, QuickSearchText.class.getName());
        Expression focusExpr = new Expression(){

            public void collectExpressionInfo(ExpressionInfo info) {
                info.addVariableNameAccess("activeFocusControlId");
            }

            public EvaluationResult evaluate(IEvaluationContext context) {
                return EvaluationResult.valueOf((boolean)QuickSearchText.class.getName().equals(context.getVariable("activeFocusControlId")));
            }
        };
        IHandlerService whService = (IHandlerService)this.getWorkbenchWindow().getService(IHandlerService.class);
        whService.activateHandler("org.eclipse.ui.edit.selectAll", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                QuickSearchText.this.searchText.selectAll();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.cut", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                QuickSearchText.this.searchText.cut();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                QuickSearchText.this.searchText.copy();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.paste", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                QuickSearchText.this.searchText.paste();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.undo", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.redo", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.text.smartEnter", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.text.goto.lineStart", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.text.goto.lineEnd", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.text.select.lineStart", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.text.select.lineEnd", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.search.ui.openSearchDialog", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                return null;
            }
        }, focusExpr);
    }

    public void showImage(boolean visible) {
        if (this.closeImageSelectWidget != null) {
            this.closeImageSelectWidget.setVisible(visible);
        }
        if (this.downImageSelectWidget != null) {
            this.downImageSelectWidget.setVisible(visible);
        }
        if (this.upImageSelectWidget != null) {
            this.upImageSelectWidget.setVisible(visible);
        }
    }

    public void createImage(Composite composite, boolean visible) {
        int width = QuickSearchText.CLOSE_IMAGE.getImageData().width;
        int height = QuickSearchText.CLOSE_IMAGE.getImageData().height;
        if (this.closeImageSelectWidget == null) {
            this.closeImageSelectWidget = new ImageSelectWidget(composite, CLOSE_IMAGE);
            this.closeImageSelectWidget.setLayoutData((Object)GridDataFactory.swtDefaults().hint(width, height).align(0x1000008, 0x1000000).create());
            this.closeImageSelectWidget.setCursorStyle(0);
            this.closeImageSelectWidget.setToolTipText("\u6e05\u9664\u641c\u7d22\u5185\u5bb9");
        }
        this.closeImageSelectWidget.setImage(CLOSE_IMAGE);
        this.closeImageSelectWidget.setVisible(visible);
        this.closeImageSelectWidget.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                QuickSearchText.this.closeImageSelectWidget.setImage(CLOSE_HOVER_IMAGE);
                QuickSearchText.this.closeImageSelectWidget.redraw();
                QuickSearchText.this.searchText.setText("");
            }

            public void mouseDown(MouseEvent e) {
                QuickSearchText.this.closeImageSelectWidget.setImage(CLOSE_DOWN_IMAGE);
                QuickSearchText.this.closeImageSelectWidget.redraw();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.closeImageSelectWidget.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                QuickSearchText.this.closeImageSelectWidget.setImage(CLOSE_HOVER_IMAGE);
                QuickSearchText.this.closeImageSelectWidget.redraw();
            }

            public void mouseExit(MouseEvent e) {
                QuickSearchText.this.closeImageSelectWidget.setImage(CLOSE_IMAGE);
                QuickSearchText.this.closeImageSelectWidget.redraw();
            }

            public void mouseEnter(MouseEvent e) {
                QuickSearchText.this.closeImageSelectWidget.setImage(CLOSE_HOVER_IMAGE);
                QuickSearchText.this.closeImageSelectWidget.redraw();
            }
        });
        width = QuickSearchText.UP_IMAGE.getImageData().width;
        height = QuickSearchText.UP_IMAGE.getImageData().height;
        if (this.upImageSelectWidget == null) {
            this.upImageSelectWidget = new ImageSelectWidget(composite, UP_IMAGE);
            this.upImageSelectWidget.setLayoutData((Object)GridDataFactory.swtDefaults().hint(width, height).align(0x1000008, 0x1000000).create());
            this.upImageSelectWidget.setCursorStyle(0);
            this.upImageSelectWidget.setToolTipText("\u4e0a\u4e00\u4e2a");
        }
        this.upImageSelectWidget.setImage(UP_IMAGE);
        this.upImageSelectWidget.setVisible(visible);
        this.upImageSelectWidget.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                QuickSearchText.this.upImageSelectWidget.setImage(UP_HOVER_IMAGE);
                QuickSearchText.this.upImageSelectWidget.redraw();
            }

            public void mouseDown(MouseEvent e) {
                QuickSearchText.this.upImageSelectWidget.setImage(UP_DOWN_IMAGE);
                QuickSearchText.this.upImageSelectWidget.redraw();
                QuickSearchText.this.findAndSelect(false);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.upImageSelectWidget.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                QuickSearchText.this.upImageSelectWidget.setImage(UP_HOVER_IMAGE);
                QuickSearchText.this.upImageSelectWidget.redraw();
            }

            public void mouseExit(MouseEvent e) {
                QuickSearchText.this.upImageSelectWidget.setImage(UP_IMAGE);
                QuickSearchText.this.upImageSelectWidget.redraw();
            }

            public void mouseEnter(MouseEvent e) {
                QuickSearchText.this.upImageSelectWidget.setImage(UP_HOVER_IMAGE);
                QuickSearchText.this.upImageSelectWidget.redraw();
            }
        });
        width = QuickSearchText.DOWN_IMAGE.getImageData().width;
        height = QuickSearchText.DOWN_IMAGE.getImageData().height;
        if (this.downImageSelectWidget == null) {
            this.downImageSelectWidget = new ImageSelectWidget(composite, DOWN_IMAGE);
            this.downImageSelectWidget.setLayoutData((Object)GridDataFactory.swtDefaults().hint(width, height).align(0x1000008, 0x1000000).create());
            this.downImageSelectWidget.setCursorStyle(0);
            this.downImageSelectWidget.setToolTipText("\u4e0b\u4e00\u4e2a");
        }
        this.downImageSelectWidget.setImage(DOWN_IMAGE);
        this.downImageSelectWidget.setVisible(visible);
        this.downImageSelectWidget.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                QuickSearchText.this.downImageSelectWidget.setImage(DOWN_HOVER_IMAGE);
                QuickSearchText.this.downImageSelectWidget.redraw();
            }

            public void mouseDown(MouseEvent e) {
                QuickSearchText.this.downImageSelectWidget.setImage(DOWN_DOWN_IMAGE);
                QuickSearchText.this.downImageSelectWidget.redraw();
                QuickSearchText.this.findAndSelect(true);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.downImageSelectWidget.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                QuickSearchText.this.downImageSelectWidget.setImage(DOWN_HOVER_IMAGE);
                QuickSearchText.this.downImageSelectWidget.redraw();
            }

            public void mouseExit(MouseEvent e) {
                QuickSearchText.this.downImageSelectWidget.setImage(DOWN_IMAGE);
                QuickSearchText.this.downImageSelectWidget.redraw();
            }

            public void mouseEnter(MouseEvent e) {
                QuickSearchText.this.downImageSelectWidget.setImage(DOWN_HOVER_IMAGE);
                QuickSearchText.this.downImageSelectWidget.redraw();
            }
        });
    }

    protected void findAndSelect(boolean b) {
        this.setSearchForward(b);
        this.findAndSelect();
    }

    protected void findAndSelect() {
        IFindReplaceTarget target;
        AbstractTextEditor editor;
        ISelection selection;
        if (StringUtil.isBlank((String)this.getFilterText())) {
            return;
        }
        IEditorPart editorPart = this.getEditorPart();
        quickSearchDialog.setNeedClose(true);
        this.closeDialog();
        quickSearchDialog.setNeedClose(false);
        int start = 0;
        if (editorPart instanceof AbstractTextEditor && (selection = (editor = (AbstractTextEditor)editorPart).getSelectionProvider().getSelection()) != null && selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            start = this.getSearchForward() ? textSelection.getOffset() + textSelection.getLength() : textSelection.getOffset();
        }
        if ((target = (IFindReplaceTarget)editorPart.getAdapter(IFindReplaceTarget.class)) != null && target.canPerformFind()) {
            if (target instanceof IFindReplaceTargetExtension3) {
                IFindReplaceTargetExtension3 exts = (IFindReplaceTargetExtension3)target;
                int i = exts.findAndSelect(start, this.getFilterText(), this.getSearchForward(), false, false, true);
                if (i == -1) {
                    start = 0;
                    i = exts.findAndSelect(start, this.getFilterText(), this.getSearchForward(), false, false, true);
                }
                if (i != -1) {
                    editorPart.setFocus();
                }
            } else {
                int i = target.findAndSelect(start, this.getFilterText(), this.getSearchForward(), false, true);
                if (i == -1) {
                    start = 0;
                    i = target.findAndSelect(start, this.getFilterText(), this.getSearchForward(), false, true);
                }
                if (i != -1) {
                    editorPart.setFocus();
                }
            }
        }
    }

    public IEditorPart getEditorPart() {
        IWorkbenchWindow workbenchWindow = QuickSearchActivator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editorPart = page.getActiveEditor();
        if (editorPart == null) {
            return null;
        }
        return editorPart;
    }

    private boolean getSearchForward() {
        return this.searchForward;
    }

    private void setSearchForward(boolean searchForward) {
        this.searchForward = searchForward;
    }

    protected void setSelection(int i) {
        if (quickSearchDialog != null && !quickSearchDialog.isClosed()) {
            if (i < 0) {
                if (quickSearchDialog.getSelectionIndex() < 0) {
                    return;
                }
                if (quickSearchDialog.getSelectionCount() == 0) {
                    this.setFocus(true, false);
                    return;
                }
            }
            quickSearchDialog.setSelection(i);
        }
    }

    public boolean isNeedWarn() {
        return this.needWarn;
    }

    public void setNeedWarn(boolean needWarn) {
        this.needWarn = needWarn;
    }

    @Override
    public void setFocus(boolean b, boolean needWarn) {
        this.setNeedWarn(needWarn);
        if (b) {
            this.searchText.setFocus();
            this.searchText.selectAll();
        }
    }

    @Override
    public String getFilterText() {
        if (this.searchText == null || this.searchText.isDisposed()) {
            return null;
        }
        String text = this.searchText.getText();
        this.fileName = "";
        if (StringUtil.isNotBlank((String)text)) {
            boolean isDefault = false;
            if (text.startsWith("@")) {
                QuickSearchUtil.setSearchType(QuickSearchType.INDEX);
            } else if (text.startsWith(":") || text.startsWith("\uff1a")) {
                QuickSearchUtil.setSearchType(QuickSearchType.GOTO_LINE);
            } else if (text.startsWith("/")) {
                int index = text.indexOf("@");
                if (index > 0) {
                    QuickSearchUtil.setSearchType(QuickSearchType.INDEX);
                    isDefault = true;
                    this.fileName = text.substring(1, index);
                    text = text.substring(index + 1);
                } else {
                    QuickSearchUtil.setSearchType(QuickSearchType.FILE);
                }
            } else if (text.startsWith("!") || text.startsWith("\uff01")) {
                QuickSearchUtil.setSearchType(QuickSearchType.ABILITY);
            } else if (text.startsWith("?") || text.startsWith("\uff1f")) {
                QuickSearchUtil.setSearchType(QuickSearchType.ASK);
            } else {
                isDefault = true;
                QuickSearchUtil.setSearchType(QuickSearchType.DEFAULT);
            }
            if (!isDefault) {
                text = text.substring(1);
            }
        }
        return text;
    }

    @Override
    public Point getPoint() {
        if (rectangle == null && this.searchText != null && !this.searchText.isDisposed()) {
            rectangle = this.searchText.getBounds();
        }
        Point pt = new Point(QuickSearchText.rectangle.x - 5, QuickSearchText.rectangle.y + QuickSearchText.rectangle.height + 6);
        pt = this.parent.toDisplay(pt);
        return pt;
    }

    public void openSearchDialog(boolean needExcute) {
        if (QuickSearchDialog.needClose_) {
            return;
        }
        if (quickSearchDialog == null || quickSearchDialog.isClosed()) {
            quickSearchDialog = new QuickSearchDialog(this.getWorkbenchWindow(), null, this.handler, this.fileName, needExcute);
        }
        if (StringUtil.isBlank((String)this.getFilterText())) {
            quickSearchDialog.setNeedClose(true);
            this.closeDialog();
            quickSearchDialog.setNeedClose(false);
            return;
        }
        quickSearchDialog.toggleShowAllMatches();
        if (quickSearchDialog.isCanOpen()) {
            quickSearchDialog.open();
            this.searchText.setFocus();
        } else {
            quickSearchDialog.excute();
        }
    }

    public void openSeniorSearchDialog() {
        String type = "0";
        if (QuickSearchUtil.getSearchType() == QuickSearchType.DEFAULT) {
            type = "1";
        }
        SearchDialog dialog = new SearchDialog(this.getWorkbenchWindow(), null, type, this.getRealFilterText());
        dialog.open();
    }

    @Override
    public void closeDialog() {
        if (quickSearchDialog != null) {
            quickSearchDialog.close();
        }
    }

    @Override
    public void setForeground(Color color) {
        if (this.searchText.isDisposed()) {
            return;
        }
        this.searchText.setForeground(color);
    }

    @Override
    public boolean getFocus() {
        return this.isFocused;
    }

    @Override
    public String getRealFilterText() {
        String text = this.searchText.getText();
        return text.trim();
    }

    public void dispose() {
        if (this.themeChangeListener != null) {
            ThemeUtil.getThemeListener().removeThemeChangeListenner(this.themeChangeListener);
        }
        super.dispose();
    }

    public void highText(Composite main, boolean b) {
        this.setNeedWarn(b);
        main.redraw();
    }

    public void createHighColor(Composite parent) {
        warnColor = new Color((Device)parent.getDisplay(), 153, 207, 249);
    }

    @Override
    public void setPrefixText() {
        this.isSetted = false;
        String text = this.getRealFilterText();
        QuickSearchType type = QuickSearchUtil.getSearchType();
        text = type == QuickSearchType.ABILITY ? this.setText(text, type, "!", "\uff01") : (type == QuickSearchType.ASK ? this.setText(text, type, "?", "\uff1f") : (type == QuickSearchType.FILE ? this.setText(text, type, "/", "") : (type == QuickSearchType.GOTO_LINE ? this.setText(text, type, ":", "\uff1a") : (type == QuickSearchType.INDEX ? this.setText(text, type, "@", "") : this.setText(text, type, "", "")))));
        if (quickSearchDialog != null) {
            quickSearchDialog.setNeedClose(true);
            this.closeDialog();
            quickSearchDialog.setNeedClose(false);
        }
        if (QuickSearchUtil.getSearchType() == QuickSearchType.DEFAULT) {
            this.findAndSelect(true);
            this.isSetted = false;
        } else {
            if (!this.isSetted) {
                this.openSearchDialog(true);
            }
            if (quickSearchDialog != null && (quickSearchDialog.isOpened() || quickSearchDialog.isCanOpen())) {
                this.searchText.setFocus();
            }
        }
        if (StringUtil.isBlank((String)this.getFilterText())) {
            this.searchText.setFocus();
        }
        int l = text.length();
        this.searchText.setSelection(l, l);
    }

    public String setText(String text, QuickSearchType type, String f1, String f2) {
        if (!(!StringUtil.isBlank((String)f1) && text.startsWith(f1) || !StringUtil.isBlank((String)f2) && text.startsWith(f2))) {
            text = this.setFilterText(text, f1);
        }
        this.preType = type;
        return text;
    }

    public String setFilterText(String text, String filter) {
        String oldText = text;
        text = this.filterText(text);
        text = String.valueOf(filter) + text;
        if (QuickSearchUtil.getSearchType() != QuickSearchType.DEFAULT || !text.equals(oldText)) {
            this.isSetted = true;
            this.searchText.setText(text);
        }
        return text;
    }

    public String filterText(String text) {
        if (this.preType == QuickSearchType.ABILITY && text.startsWith("!")) {
            text = text.substring(1);
        } else if (this.preType == QuickSearchType.ASK && (text.startsWith("?") || text.startsWith("\uff1f"))) {
            text = text.substring(1);
        } else if (this.preType == QuickSearchType.FILE && text.startsWith("/")) {
            text = text.substring(1);
        } else if (this.preType == QuickSearchType.GOTO_LINE && (text.startsWith(":") || text.startsWith("\uff1a"))) {
            text = text.substring(1);
        } else if (this.preType == QuickSearchType.INDEX && text.startsWith("@")) {
            text = text.substring(1);
        }
        return text;
    }
}

