/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.quicksearch.ui;

import com.pandora.core.index.QuickSearchType;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.core.utils.ThemeUtil;
import com.pandora.quicksearch.ui.IFocusHandler;
import com.pandora.quicksearch.ui.QuickSearchText;
import com.pandora.quicksearch.ui.QuickSearchUtil;
import com.pandora.quicksearch.ui.internal.quicksearch.AskProvider;
import com.pandora.quicksearch.ui.internal.quicksearch.CurrentEditorElement;
import com.pandora.quicksearch.ui.internal.quicksearch.CurrentEditorProvider;
import com.pandora.quicksearch.ui.internal.quicksearch.FileProvider;
import com.pandora.quicksearch.ui.internal.quicksearch.GotoLineElement;
import com.pandora.quicksearch.ui.internal.quicksearch.GotoLineProvider;
import com.pandora.quicksearch.ui.internal.quicksearch.IndexProvider;
import com.pandora.quicksearch.ui.internal.quicksearch.SearchInCurrentEditorElement;
import com.pandora.quicksearch.ui.internal.quicksearch.SearchInCurrentEditorProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.quickaccess.ActionProvider;
import org.eclipse.ui.internal.quickaccess.CommandProvider;
import org.eclipse.ui.internal.quickaccess.EditorProvider;
import org.eclipse.ui.internal.quickaccess.PerspectiveProvider;
import org.eclipse.ui.internal.quickaccess.PreferenceProvider;
import org.eclipse.ui.internal.quickaccess.PropertiesProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessEntry;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.ViewProvider;
import org.eclipse.ui.internal.quickaccess.WizardProvider;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.themes.ColorUtil;

public class QuickSearchDialog
extends PopupDialog {
    private static final String TEXT_ARRAY = "textArray";
    private static final String TEXT_ENTRIES = "textEntries";
    private static final String ORDERED_PROVIDERS = "orderedProviders";
    private static final String ORDERED_ELEMENTS = "orderedElements";
    private QuickAccessProvider[] providers;
    private IWorkbenchWindow window;
    protected Map providerMap;
    private Command invokingCommand;
    private LinkedList previousPicksList = new LinkedList();
    protected Map textMap = new HashMap();
    protected Map elementMap = new HashMap();
    private TriggerSequence[] invokingCommandKeySequences;
    protected Table table;
    private TextLayout textLayout;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private boolean showAllMatches = true;
    protected boolean resized = false;
    private Color grayColor;
    static final int MAXIMUM_NUMBER_OF_ELEMENTS = 60;
    static final int MAXIMUM_NUMBER_OF_TEXT_ENTRIES_PER_ELEMENT = 3;
    private KeyAdapter keyAdapter;
    private static final int INITIAL_COUNT_PER_PROVIDER = 5;
    private static final int MAX_COUNT_TOTAL = 20;
    public static boolean needClose_ = false;
    private IFocusHandler handler;
    private boolean needExcute;
    private boolean listenToParentDeactivate = true;
    private boolean listenToDeactivate = true;
    private boolean isClosed = false;
    private boolean needClose = false;
    public static final Color BACKGROUND_COLOR = new Color((Device)Display.getDefault(), 255, 252, 244);
    private boolean canOpen = false;
    private boolean isOpened = false;
    private QuickAccessElement excuteElement;

    public QuickSearchDialog(IWorkbenchWindow window, final Command invokingCommand, final IFocusHandler handler, final String fileName, boolean needExcute) {
        super(ProgressManagerUtil.getDefaultParent(), 8, false, true, false, false, true, null, null);
        this.window = window;
        this.handler = handler;
        this.needExcute = needExcute;
        needClose_ = false;
        BusyIndicator.showWhile((Display)(window.getShell() == null ? null : window.getShell().getDisplay()), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (QuickSearchUtil.getSearchType() == QuickSearchType.FILE) {
                    QuickSearchDialog.this.providers = new QuickAccessProvider[]{new CurrentEditorProvider(), new SearchInCurrentEditorProvider(), new FileProvider()};
                } else if (QuickSearchUtil.getSearchType() == QuickSearchType.ABILITY) {
                    QuickSearchDialog.this.providers = new QuickAccessProvider[]{new CurrentEditorProvider(), new SearchInCurrentEditorProvider(), new PreviousPicksProvider(), new EditorProvider(), new ViewProvider(), new PerspectiveProvider(), new CommandProvider(), new ActionProvider(), new WizardProvider(), new PreferenceProvider(), new PropertiesProvider()};
                } else if (QuickSearchUtil.getSearchType() == QuickSearchType.ASK) {
                    QuickSearchDialog.this.providers = new QuickAccessProvider[]{new CurrentEditorProvider(), new SearchInCurrentEditorProvider(), new AskProvider(handler)};
                } else if (QuickSearchUtil.getSearchType() == QuickSearchType.INDEX) {
                    QuickSearchDialog.this.providers = new QuickAccessProvider[]{new CurrentEditorProvider(), new SearchInCurrentEditorProvider(), new IndexProvider(fileName)};
                } else if (QuickSearchUtil.getSearchType() == QuickSearchType.GOTO_LINE) {
                    QuickSearchDialog.this.providers = new QuickAccessProvider[]{new CurrentEditorProvider(), new SearchInCurrentEditorProvider(), new GotoLineProvider()};
                } else {
                    QuickSearchDialog.this.providers = new QuickAccessProvider[]{new CurrentEditorProvider(), new SearchInCurrentEditorProvider()};
                }
                QuickSearchDialog.this.providerMap = new HashMap();
                int i = 0;
                while (i < QuickSearchDialog.this.providers.length) {
                    QuickSearchDialog.this.providerMap.put(QuickSearchDialog.this.providers[i].getId(), QuickSearchDialog.this.providers[i]);
                    ++i;
                }
                QuickSearchDialog.this.restoreDialog();
                QuickSearchDialog.this.invokingCommand = invokingCommand;
                if (QuickSearchDialog.this.invokingCommand != null && !QuickSearchDialog.this.invokingCommand.isDefined()) {
                    QuickSearchDialog.this.invokingCommand = null;
                } else {
                    QuickSearchDialog.this.getInvokingCommandKeySequences();
                }
                QuickSearchDialog.this.create();
            }
        });
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = QuickSearchDialog.this.getShell();
                if (shell != null && !shell.isDisposed()) {
                    Point size = shell.getSize();
                    shell.setSize(size.x, size.y + 1);
                }
            }
        });
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                QuickSearchDialog.this.listenToDeactivate = true;
            }
        });
        shell.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                QuickSearchDialog.this.listenToDeactivate = false;
            }
        });
        if ((this.getShellStyle() & 0x4000) != 0 && shell.getParent() != null) {
            shell.getParent().addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    if (!QuickSearchDialog.this.listenToDeactivate) {
                        QuickSearchDialog.this.listenToParentDeactivate = false;
                    } else {
                        QuickSearchDialog.this.listenToParentDeactivate = true;
                    }
                }
            });
        }
    }

    protected Point getDefaultSize() {
        int y;
        GC gc = new GC((Drawable)this.table);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int x = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)300);
        if (x < 350) {
            x = 350;
        }
        if ((y = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)270)) < 420) {
            y = 420;
        }
        return new Point(x, y);
    }

    public boolean isFocused() {
        return !this.listenToDeactivate || !this.listenToParentDeactivate;
    }

    protected Control createDialogArea(Composite parent) {
        TextStyle boldStyle;
        Composite composite = (Composite)super.createDialogArea(parent);
        boolean isWin32 = Util.isWindows();
        GridLayoutFactory.fillDefaults().extendedMargins(isWin32 ? 0 : 3, 3, 2, 2).applyTo(composite);
        Composite tableComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.table = new Table(tableComposite, 65540);
        this.table.setFont(QuickSearchText.font);
        this.textLayout = new TextLayout((Device)this.table.getDisplay());
        this.textLayout.setOrientation(QuickSearchDialog.getDefaultOrientation());
        Font boldFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)JFaceResources.getDialogFont()).setStyle(1));
        this.textLayout.setFont(QuickSearchText.font);
        this.textLayout.setText(QuickAccessMessages.QuickAccess_AvailableCategories);
        int maxProviderWidth = (int)((double)this.textLayout.getBounds().width * 1.1);
        this.textLayout.setFont(QuickSearchText.font);
        int i = 0;
        while (i < this.providers.length) {
            QuickAccessProvider provider = this.providers[i];
            this.textLayout.setText(provider.getName());
            int width = (int)((double)this.textLayout.getBounds().width * 1.1);
            if (width > maxProviderWidth) {
                maxProviderWidth = width;
            }
            ++i;
        }
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(0, maxProviderWidth));
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(100, 100));
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(30, 10));
        this.table.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!QuickSearchDialog.this.showAllMatches && !QuickSearchDialog.this.resized) {
                    QuickSearchDialog.this.resized = true;
                    e.display.timerExec(100, new Runnable(){

                        @Override
                        public void run() {
                            if (QuickSearchDialog.this.getShell() != null && !QuickSearchDialog.this.getShell().isDisposed()) {
                                QuickSearchDialog.this.refresh(QuickSearchDialog.this.getFilterText());
                            }
                            (this).QuickSearchDialog.this.resized = false;
                        }
                    });
                }
            }
        });
        this.table.addKeyListener((KeyListener)this.getKeyAdapter());
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 && QuickSearchDialog.this.table.getSelectionIndex() == 0) {
                    QuickSearchDialog.this.setFilterTextFocus();
                } else if (e.character == '\u001b') {
                    QuickSearchDialog.this.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (QuickSearchDialog.this.table.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (QuickSearchDialog.this.table.equals(e.getSource())) {
                    TableItem o = QuickSearchDialog.this.table.getItem(new Point(e.x, e.y));
                    TableItem selection = QuickSearchDialog.this.table.getSelection()[0];
                    if (selection.equals(o)) {
                        QuickSearchDialog.this.handleSelection(-1);
                    }
                }
            }
        });
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickSearchDialog.this.handleSelection(-1);
            }
        });
        if (PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS")) {
            boldStyle = new TextStyle(boldFont, null, null);
            this.grayColor = this.resourceManager.createColor(ColorUtil.blend((RGB)this.table.getBackground().getRGB(), (RGB)this.table.getForeground().getRGB()));
        } else {
            boldStyle = null;
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                QuickAccessEntry entry = (QuickAccessEntry)event.item.getData();
                if (entry != null) {
                    switch (event.type) {
                        case 41: {
                            entry.measure(event, QuickSearchDialog.this.textLayout, (ResourceManager)QuickSearchDialog.this.resourceManager, boldStyle);
                            break;
                        }
                        case 42: {
                            entry.paint(event, QuickSearchDialog.this.textLayout, (ResourceManager)QuickSearchDialog.this.resourceManager, boldStyle, QuickSearchDialog.this.grayColor);
                            break;
                        }
                        case 40: {
                            entry.erase(event);
                        }
                    }
                }
            }
        };
        this.table.addListener(41, listener);
        this.table.addListener(40, listener);
        this.table.addListener(42, listener);
        return composite;
    }

    protected Point getInitialLocation(Point initialSize) {
        IDialogSettings settings;
        Point result = this.handler.getPoint();
        if (this.getPersistLocation() && (settings = this.getDialogSettings()) != null) {
            try {
                int x = settings.getInt(String.valueOf(((Object)((Object)this)).getClass().getName()) + "DIALOG_X_ORIGIN");
                int y = settings.getInt(String.valueOf(((Object)((Object)this)).getClass().getName()) + "DIALOG_Y_ORIGIN");
                result = new Point(x, y);
                Shell parent = this.getParentShell();
                if (parent != null) {
                    Point parentLocation = parent.getLocation();
                    result.x += parentLocation.x;
                    result.y += parentLocation.y;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public void handleSelection(int index) {
        QuickAccessElement selectedElement = null;
        String text = this.getFilterText();
        int iCount = this.table.getItemCount();
        if (index == -1) {
            if (this.table.getSelectionCount() == 1) {
                QuickAccessEntry entry = (QuickAccessEntry)this.table.getSelection()[0].getData();
                selectedElement = entry == null ? null : entry.element;
            }
        } else {
            if (iCount < index) {
                return;
            }
            QuickAccessEntry entry = (QuickAccessEntry)this.table.getItem(index).getData();
            selectedElement = entry == null ? null : entry.element;
        }
        needClose_ = true;
        this.setNeedClose(needClose_);
        this.close();
        if (selectedElement != null) {
            this.handleElementSelected(text, selectedElement);
        }
        this.handler.setFocus(false, false);
    }

    protected void handleElementSelected(String text, Object selectedElement) {
        if (selectedElement instanceof QuickAccessElement) {
            this.addPreviousPick(text, selectedElement);
            this.storeDialog(this.getDialogSettings());
            QuickAccessElement element = (QuickAccessElement)selectedElement;
            element.execute();
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings result = workbenchDialogSettings.getSection(this.getId());
        if (result == null) {
            result = workbenchDialogSettings.addNewSection(this.getId());
        }
        return result;
    }

    protected String getId() {
        return "com.pandora.ui.QuickAccess";
    }

    private void storeDialog(IDialogSettings dialogSettings) {
        String[] orderedElements = new String[this.previousPicksList.size()];
        String[] orderedProviders = new String[this.previousPicksList.size()];
        String[] textEntries = new String[this.previousPicksList.size()];
        ArrayList arrayList = new ArrayList();
        int i = 0;
        while (i < orderedElements.length) {
            QuickAccessElement quickAccessElement = (QuickAccessElement)this.previousPicksList.get(i);
            ArrayList elementText = (ArrayList)this.textMap.get(quickAccessElement);
            Assert.isNotNull((Object)elementText);
            orderedElements[i] = quickAccessElement.getId();
            orderedProviders[i] = quickAccessElement.getProvider().getId();
            arrayList.addAll(elementText);
            textEntries[i] = String.valueOf(elementText.size());
            ++i;
        }
        String[] textArray = arrayList.toArray(new String[arrayList.size()]);
        dialogSettings.put(ORDERED_ELEMENTS, orderedElements);
        dialogSettings.put(ORDERED_PROVIDERS, orderedProviders);
        dialogSettings.put(TEXT_ENTRIES, textEntries);
        dialogSettings.put(TEXT_ARRAY, textArray);
    }

    private void addPreviousPick(String text, Object element) {
        this.previousPicksList.remove(element);
        if (element instanceof SearchInCurrentEditorElement || element instanceof CurrentEditorElement) {
            return;
        }
        if (this.previousPicksList.size() == 60) {
            Object removedElement = this.previousPicksList.removeLast();
            ArrayList removedList = (ArrayList)this.textMap.remove(removedElement);
            int i = 0;
            while (i < removedList.size()) {
                this.elementMap.remove(removedList.get(i));
                ++i;
            }
        }
        this.previousPicksList.addFirst(element);
        ArrayList textList = (ArrayList)this.textMap.get(element);
        if (textList == null) {
            textList = new ArrayList();
            this.textMap.put(element, textList);
        }
        textList.remove(text);
        if (textList.size() == 3) {
            Object removedText = textList.remove(0);
            this.elementMap.remove(removedText);
        }
        if (text.length() > 0) {
            textList.add(text);
            Object replacedElement = this.elementMap.put(text, element);
            if (replacedElement != null && !replacedElement.equals(element) && (textList = (ArrayList)this.textMap.get(replacedElement)) != null) {
                textList.remove(text);
                if (textList.isEmpty()) {
                    this.textMap.remove(replacedElement);
                    this.previousPicksList.remove(replacedElement);
                }
            }
        }
    }

    private KeyAdapter getKeyAdapter() {
        if (this.keyAdapter == null) {
            this.keyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                    TriggerSequence[] sequences = QuickSearchDialog.this.getInvokingCommandKeySequences();
                    if (sequences == null) {
                        return;
                    }
                    int i = 0;
                    while (i < sequences.length) {
                        if (sequences[i].equals((Object)keySequence)) {
                            e.doit = false;
                            QuickSearchDialog.this.toggleShowAllMatches();
                            return;
                        }
                        ++i;
                    }
                }
            };
        }
        return this.keyAdapter;
    }

    protected void toggleShowAllMatches() {
        this.refresh(this.getFilterText());
    }

    private void refresh(String filter) {
        int numItems = this.computeNumberOfItems();
        List[] entries = this.computeMatchingEntries(filter, null, numItems);
        int selectionIndex = this.refreshTable(null, entries);
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(selectionIndex);
        } else if (filter.length() == 0) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, QuickAccessMessages.QuickAccess_AvailableCategories);
            item.setForeground(0, this.grayColor);
            int i = 0;
            while (i < this.providers.length) {
                QuickAccessProvider provider = this.providers[i];
                TableItem item2 = new TableItem(this.table, 0);
                item2.setText(1, provider.getName());
                item2.setForeground(1, this.grayColor);
                ++i;
            }
        }
        if (filter.length() == 0) {
            this.setInfoText(QuickAccessMessages.QuickAccess_StartTypingToFindMatches);
        } else {
            TriggerSequence[] sequences = this.getInvokingCommandKeySequences();
            if (sequences != null && sequences.length != 0) {
                if (this.showAllMatches) {
                    this.setInfoText(NLS.bind((String)QuickAccessMessages.QuickAccess_PressKeyToShowInitialMatches, (Object)sequences[0].format()));
                } else {
                    this.setInfoText(NLS.bind((String)QuickAccessMessages.QuickAccess_PressKeyToShowAllMatches, (Object)sequences[0].format()));
                }
            } else {
                this.setInfoText("");
            }
        }
        Point size = this.getShell().computeSize(-1, -1);
        int height = size.y;
        int width = size.x;
        if (size.y > 420) {
            height = 420;
        }
        if (size.x > 440) {
            width = 440;
        }
        GC gc = new GC((Drawable)this.table);
        Point p = gc.textExtent("Ctrl+Enter");
        int c1 = this.table.getColumn(0).getWidth();
        this.table.getColumn(0).setWidth(c1);
        this.table.getColumn(1).setWidth(width - c1 - p.x + 6);
        if (QuickSearchUtil.getSearchType() != QuickSearchType.DEFAULT) {
            this.table.getColumn(2).setWidth(p.x + 7);
        }
        this.getShell().setSize(width + 18, height);
    }

    public void setBackAndForegGround(TableItem item) {
        item.setBackground(ThemeUtil.getBackgroundColor());
        item.setForeground(ThemeUtil.getForegroundColor());
    }

    private int refreshTable(QuickAccessElement perfectMatch, List[] entries) {
        if (this.table.getItemCount() > entries.length && this.table.getItemCount() - entries.length > 20) {
            this.table.removeAll();
        }
        TableItem[] items = this.table.getItems();
        int selectionIndex = -1;
        int index = 0;
        int i = 0;
        while (i < this.providers.length) {
            if (entries[i] != null) {
                boolean firstEntry = true;
                Iterator it = entries[i].iterator();
                while (it.hasNext()) {
                    TableItem item;
                    QuickAccessEntry entry = (QuickAccessEntry)it.next();
                    entry.firstInCategory = firstEntry;
                    firstEntry = false;
                    if (!it.hasNext()) {
                        entry.lastInCategory = true;
                    }
                    if (index < items.length) {
                        item = items[index];
                        this.table.clear(index);
                    } else {
                        item = new TableItem(this.table, 0);
                    }
                    if (perfectMatch == entry.element && selectionIndex == -1) {
                        selectionIndex = index;
                    }
                    item.setData((Object)entry);
                    item.setText(0, entry.provider.getName());
                    item.setText(1, StringUtil.isBlank((String)entry.element.getSortLabel()) ? entry.element.getLabel() : entry.element.getSortLabel());
                    if (Util.isWpf()) {
                        item.setImage(1, entry.getImage(entry.element, (ResourceManager)this.resourceManager));
                    }
                    if (index == 0) {
                        item.setData("ENTER", (Object)"Enter");
                    } else if (index == 1) {
                        if (PlatformUtil.isMac()) {
                            item.setData("ENTER", (Object)"command+H");
                        } else {
                            item.setData("ENTER", (Object)"Ctrl+H");
                        }
                    } else if (index == 2 && QuickSearchUtil.getSearchType() != QuickSearchType.DEFAULT) {
                        if (PlatformUtil.isMac()) {
                            item.setData("ENTER", (Object)"command+enter");
                        } else {
                            item.setData("ENTER", (Object)"Ctrl+Enter");
                        }
                    }
                    ++index;
                }
            }
            ++i;
        }
        if (index < items.length) {
            this.table.remove(index, items.length - 1);
        }
        if (selectionIndex == -1) {
            selectionIndex = 0;
        }
        return selectionIndex;
    }

    private List[] computeMatchingEntries(final String filter, QuickAccessElement perfectMatch, int maxCount) {
        QuickAccessEntry entry;
        boolean done;
        List[] entries = new ArrayList[this.providers.length];
        int[] indexPerProvider = new int[this.providers.length];
        int countPerProvider = Math.min(maxCount / 4, 5);
        int countTotal = 0;
        boolean perfectMatchAdded = true;
        if (perfectMatch != null) {
            --maxCount;
            perfectMatchAdded = false;
        }
        do {
            done = true;
            int i = 0;
            while (i < this.providers.length && (this.showAllMatches || countTotal < maxCount)) {
                if (entries[i] == null) {
                    entries[i] = new ArrayList();
                    indexPerProvider[i] = 0;
                }
                int count = 0;
                QuickAccessProvider provider = this.providers[i];
                if (filter.length() > 0 || provider instanceof PreviousPicksProvider || this.showAllMatches) {
                    QuickAccessElement[] elements = null;
                    if (QuickSearchUtil.getSearchType() == QuickSearchType.ASK) {
                        elements = provider.getElements();
                    } else {
                        elements = provider.getElementsSorted();
                        Arrays.sort(elements, new Comparator(){

                            public int compare(Object o1, Object o2) {
                                QuickAccessElement e1 = (QuickAccessElement)o1;
                                QuickAccessElement e2 = (QuickAccessElement)o2;
                                boolean b1 = e1.getLabel().startsWith(filter);
                                boolean b2 = e2.getLabel().startsWith(filter);
                                if (b1 && !b2) {
                                    return -1;
                                }
                                if (b2 && !b1) {
                                    return 1;
                                }
                                return e1.getLabel().compareTo(e2.getLabel());
                            }
                        });
                    }
                    int j = indexPerProvider[i];
                    while (j < elements.length && (this.showAllMatches || count < countPerProvider && countTotal < maxCount)) {
                        QuickAccessElement element = elements[j];
                        if (element instanceof SearchInCurrentEditorElement && "com.pandora.quicksearch.ui.internal.quicksearch.SearchInCurrentEditorElement".equals(element.getId())) {
                            ((SearchInCurrentEditorElement)element).setText(QuickSearchUtil.getFocusHandler().getRealFilterText());
                        }
                        if (element instanceof CurrentEditorElement && "com.pandora.quicksearch.ui.internal.quicksearch.CurrentEditorElement".equals(element.getId())) {
                            ((CurrentEditorElement)element).setText(QuickSearchUtil.getFocusHandler().getRealFilterText());
                        }
                        if (QuickSearchUtil.getSearchType() == QuickSearchType.GOTO_LINE && element instanceof GotoLineElement && "com.pandora.quicksearch.ui.internal.quicksearch.GotoLineElement".equals(element.getId())) {
                            try {
                                String text = this.getFilterText();
                                int line = Integer.parseInt(text);
                                IDocument document = QuickSearchUtil.getCurrentDocument();
                                if (document == null || document.getNumberOfLines() < line) {
                                    ++j;
                                    continue;
                                }
                                ((GotoLineElement)element).setLine(line);
                            }
                            catch (NumberFormatException numberFormatException) {
                                ++j;
                                continue;
                            }
                        }
                        Object entry2 = filter.length() == 0 ? (i == 0 || this.showAllMatches ? new QuickAccessEntry(element, provider, new int[0][0], new int[0][0]) : null) : element.match(filter, provider);
                        if (entry2 != null) {
                            entries[i].add(entry2);
                            ++count;
                            ++countTotal;
                            if (i == 0 && entry2.element == perfectMatch) {
                                perfectMatchAdded = true;
                                maxCount = 20;
                            }
                        }
                        ++j;
                    }
                    if (this.needExcute && entries[i].size() == 1) {
                        if (QuickSearchUtil.getSearchType() == QuickSearchType.GOTO_LINE && provider instanceof GotoLineProvider || QuickSearchUtil.getSearchType() == QuickSearchType.ASK && provider instanceof AskProvider || QuickSearchUtil.getSearchType() == QuickSearchType.INDEX && provider instanceof IndexProvider || QuickSearchUtil.getSearchType() == QuickSearchType.FILE && provider instanceof FileProvider) {
                            this.excuteElement = ((QuickAccessEntry)entries[i].get((int)0)).element;
                            this.canOpen = false;
                        } else {
                            this.canOpen = true;
                        }
                    } else {
                        this.canOpen = true;
                    }
                    indexPerProvider[i] = j;
                    if (j < elements.length) {
                        done = false;
                    }
                }
                ++i;
            }
            countPerProvider = 1;
        } while ((this.showAllMatches || countTotal < maxCount) && !done);
        if (!perfectMatchAdded && (entry = perfectMatch.match(filter, this.providers[0])) != null) {
            if (entries[0] == null) {
                entries[0] = new ArrayList();
                indexPerProvider[0] = 0;
            }
            entries[0].add(entry);
        }
        return entries;
    }

    private int computeNumberOfItems() {
        Rectangle rect = this.table.getClientArea();
        int itemHeight = this.table.getItemHeight();
        int headerHeight = this.table.getHeaderHeight();
        return (rect.height - headerHeight + itemHeight - 1) / (itemHeight + this.table.getGridLineWidth());
    }

    private void restoreDialog() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            String[] orderedElements = dialogSettings.getArray(ORDERED_ELEMENTS);
            String[] orderedProviders = dialogSettings.getArray(ORDERED_PROVIDERS);
            String[] textEntries = dialogSettings.getArray(TEXT_ENTRIES);
            String[] textArray = dialogSettings.getArray(TEXT_ARRAY);
            this.elementMap = new HashMap();
            this.textMap = new HashMap();
            this.previousPicksList = new LinkedList();
            if (orderedElements != null && orderedProviders != null && textEntries != null && textArray != null) {
                int arrayIndex = 0;
                int i = 0;
                while (i < orderedElements.length) {
                    QuickAccessElement quickAccessElement;
                    QuickAccessProvider quickAccessProvider = (QuickAccessProvider)this.providerMap.get(orderedProviders[i]);
                    int numTexts = Integer.parseInt(textEntries[i]);
                    if (quickAccessProvider != null && (quickAccessElement = quickAccessProvider.getElementForId(orderedElements[i])) != null) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        int j = arrayIndex;
                        while (j < arrayIndex + numTexts) {
                            String text = textArray[j];
                            if (text.length() > 0) {
                                arrayList.add(text);
                                this.elementMap.put(text, quickAccessElement);
                            }
                            ++j;
                        }
                        this.textMap.put(quickAccessElement, arrayList);
                        this.previousPicksList.add(quickAccessElement);
                    }
                    arrayIndex += numTexts;
                    ++i;
                }
            }
        }
    }

    protected final TriggerSequence[] getInvokingCommandKeySequences() {
        if (this.invokingCommandKeySequences == null && this.invokingCommand != null) {
            IBindingService bindingService = (IBindingService)this.window.getWorkbench().getAdapter(IBindingService.class);
            this.invokingCommandKeySequences = bindingService.getActiveBindingsFor(this.invokingCommand.getId());
        }
        return this.invokingCommandKeySequences;
    }

    public String getFilterText() {
        return this.handler.getFilterText().toLowerCase();
    }

    public void setFilterTextFocus() {
        this.handler.setFocus(true, false);
    }

    public boolean close() {
        if (this.isNeedClose()) {
            this.isClosed = true;
            return super.close();
        }
        if (this.handler.getFocus() && StringUtil.isNotBlank((String)this.handler.getFilterText())) {
            return false;
        }
        this.isClosed = true;
        return super.close();
    }

    public void setNeedClose(boolean needClose) {
        this.needClose = needClose;
    }

    public boolean isNeedClose() {
        return this.needClose;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setSelection(int i) {
        if (this.table != null && !this.table.isDisposed() && this.table.getItems().length > 0) {
            int selection = this.table.getSelectionIndex();
            this.table.setSelection(selection + i);
        }
    }

    public int getSelectionCount() {
        if (this.table != null && !this.table.isDisposed() && this.table.getItems().length > 0) {
            return this.table.getSelectionCount();
        }
        return -1;
    }

    public int getSelectionIndex() {
        if (this.table != null && !this.table.isDisposed() && this.table.getItems().length > 0) {
            return this.table.getSelectionIndex();
        }
        return -1;
    }

    protected Color getBackground() {
        return BACKGROUND_COLOR;
    }

    public int open() {
        this.isOpened = true;
        return super.open();
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public boolean isCanOpen() {
        return this.canOpen;
    }

    public void excute() {
        if (this.excuteElement != null) {
            this.excuteElement.execute();
        }
    }

    private class PreviousPicksProvider
    extends QuickAccessProvider {
        private PreviousPicksProvider() {
        }

        public QuickAccessElement getElementForId(String id) {
            return null;
        }

        public QuickAccessElement[] getElements() {
            return QuickSearchDialog.this.previousPicksList.toArray(new QuickAccessElement[QuickSearchDialog.this.previousPicksList.size()]);
        }

        public QuickAccessElement[] getElementsSorted() {
            return this.getElements();
        }

        public String getId() {
            return "org.eclipse.ui.previousPicks";
        }

        public ImageDescriptor getImageDescriptor() {
            return WorkbenchImages.getImageDescriptor((String)"IMG_OBJ_NODE");
        }

        public String getName() {
            return QuickAccessMessages.QuickAccess_Previous;
        }
    }
}

