/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.formatter;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.formatter.JSFormatterContext;
import com.aptana.editor.js.formatter.JSFormatterNodeBuilder;
import com.aptana.editor.js.formatter.JSFormatterNodeRewriter;
import com.aptana.editor.js.formatter.JSFormatterPlugin;
import com.aptana.formatter.AbstractScriptFormatter;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.FormatterIndentDetector;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.FormatterWriter;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.epl.FormatterPlugin;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.ui.FormatterException;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.ScriptFormattingContextProperties;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.IParser;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.StatusLineMessageTimerManager;
import com.pandora.nodejs.service.ContentType;
import com.pandora.nodejs.service.NodeService;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class JSFormatter
extends AbstractScriptFormatter
implements IScriptFormatter {
    protected static final String[] BRACE_POSITIONS = new String[]{"js.formatter.brace.position.blocks", "js.formatter.brace.position.case.block", "js.formatter.brace.position.switch.block", "js.formatter.brace.position.function.declaration"};
    protected static final String[] NEW_LINES_POSITIONS = new String[]{"js.formatter.newline.before.catch", "js.formatter.newline.before.dowhile", "js.formatter.newline.before.else", "js.formatter.newline.before.if.in.elseif", "js.formatter.newline.before.finally", "js.formatter.newline.before.name.value.pairs"};
    protected static final String[] INDENTATIONS = new String[]{"js.formatter.indent.blocks", "js.formatter.indent.case.body", "js.formatter.indent.switch.body", "js.formatter.indent.function.body", "js.formatter.indent.group.body"};
    protected static final String[] SPACES = new String[]{"js.formatter.spaces.before.commas", "js.formatter.spaces.after.commas", "js.formatter.spaces.before.unary.operator", "js.formatter.spaces.after.unary.operator", "js.formatter.spaces.before.key.value.operator", "js.formatter.spaces.after.key.value.operator", "js.formatter.spaces.before.assignment.operator", "js.formatter.spaces.after.assignment.operator", "js.formatter.spaces.before.relational.operator", "js.formatter.spaces.after.relational.operator", "js.formatter.spaces.before.concatenation.operator", "js.formatter.spaces.after.concatenation.operator", "js.formatter.spaces.before.conditional.operator", "js.formatter.spaces.after.conditional.operator", "js.formatter.spaces.before.postfix.operator", "js.formatter.spaces.after.postfix.operator", "js.formatter.spaces.before.prefix.operator", "js.formatter.spaces.after.prefix.operator", "js.formatter.spaces.before.arithmetic.operator", "js.formatter.spaces.after.arithmetic.operator", "js.formatter.spaces.before.for.semicolon.operator", "js.formatter.spaces.after.for.semicolon.operator", "js.formatter.spaces.before.semicolon.operator", "js.formatter.spaces.after.semicolon.operator", "js.formatter.spaces.before.case.colon.operator", "js.formatter.spaces.after.case.colon.operator", "js.formatter.spaces.before.parentheses", "js.formatter.spaces.after.parentheses", "js.formatter.spaces.before.parentheses.closing", "js.formatter.spaces.before.declaration.parentheses.opening", "js.formatter.spaces.after.declaration.parentheses.opening", "js.formatter.spaces.before.declaration.parentheses.closing", "js.formatter.spaces.before.invocation.parentheses.opening", "js.formatter.spaces.after.invocation.parentheses.opening", "js.formatter.spaces.before.invocation.parentheses.closing", "js.formatter.spaces.before.array.access.parentheses.opening", "js.formatter.spaces.after.array.access.parentheses.opening", "js.formatter.spaces.before.array.access.parentheses.closing", "js.formatter.spaces.before.loop.parentheses.opening", "js.formatter.spaces.after.loop.parentheses.opening", "js.formatter.spaces.before.loop.parentheses.closing", "js.formatter.spaces.before.conditional.parentheses.opening", "js.formatter.spaces.after.conditional.parentheses.opening", "js.formatter.spaces.before.conditional.parentheses.closing"};

    protected JSFormatter(String lineSeparator, Map<String, String> preferences, String mainContentType) {
        super(preferences, mainContentType, lineSeparator);
    }

    public int detectIndentationLevel(IDocument document, int offset, boolean isSelection, IFormattingContext formattingContext) {
        int indent = 0;
        try {
            ITypedRegion partition = document.getPartition(offset);
            if (partition != null && partition.getOffset() == offset) {
                return super.detectIndentationLevel(document, offset);
            }
            String source = document.get();
            IParseRootNode parseResult = ParserPoolFactory.parse((String)this.getMainContentType(), (String)source).getRootNode();
            if (parseResult != null) {
                JSFormatterNodeBuilder builder = new JSFormatterNodeBuilder();
                FormatterDocument formatterDocument = this.createFormatterDocument(source, offset);
                IFormatterContainerNode root = builder.build((IParseNode)parseResult, formatterDocument);
                new JSFormatterNodeRewriter(parseResult, formatterDocument).rewrite(root);
                JSFormatterContext context = new JSFormatterContext(0);
                FormatterIndentDetector detector = new FormatterIndentDetector(offset);
                try {
                    root.accept((IFormatterContext)context, (IFormatterWriter)detector);
                    return detector.getLevel();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            return super.detectIndentationLevel(document, offset);
        }
        return indent;
    }

    public TextEdit format(String source, int offset, int length, int indentationLevel, boolean isSelection, IFormattingContext context, String indentSufix) throws FormatterException {
        String substring;
        String input = source;
        if (context != null) {
            Integer lastOffset = (Integer)context.getProperty((Object)ScriptFormattingContextProperties.CONTEXT_LAST_FORMAT_OFFSET);
            Integer lastLength = (Integer)context.getProperty((Object)ScriptFormattingContextProperties.CONTEXT_LAST_FORMAT_LENGTH);
            Boolean formatAll = (Boolean)context.getProperty((Object)ScriptFormattingContextProperties.CONTEXT_LAST_FORMAT_ALL);
            if (formatAll != null && formatAll.booleanValue() || lastOffset != null && lastLength != null && lastOffset <= offset && lastLength >= length) {
                return null;
            }
            IDocument document = (IDocument)context.getProperty((Object)ScriptFormattingContextProperties.CONTEXT_DOCUMENT);
            if (isSelection && document != null) {
                try {
                    input = document.get(offset, length);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            } else {
                String originalText = source.substring(offset, offset + length);
                input = JSFormatter.leftTrim((String)originalText, (int)0);
            }
        }
        if (indentationLevel > 0 && FormatterWriter.endsWithNewLine((String)input, (String)this.lineSeparator) && !FormatterWriter.endsWithNewLine((String)(substring = input.substring(0, input.length() - this.lineSeparator.length())), (String)this.lineSeparator)) {
            input = substring;
        }
        try {
            JSONObject config = new JSONObject();
            this.initConfig((Map)config);
            String output = NodeService.format((JSONObject)config, (ContentType)ContentType.JS, (String)input);
            if (output != null) {
                if (!input.equals(output)) {
                    return new ReplaceEdit(offset, length, output);
                }
                return new MultiTextEdit();
            }
        }
        catch (FormatterException e) {
            StatusLineMessageTimerManager.setErrorMessage((String)NLS.bind((String)FormatterMessages.Formatter_formatterParsingErrorStatus, (Object)e.getMessage()), (long)3000L, (boolean)true);
        }
        catch (Exception e) {
            StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.Formatter_formatterErrorStatus, (long)3000L, (boolean)true);
            IdeLog.logError((Plugin)JSFormatterPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
        }
        return null;
    }

    public int getIndentSize() {
        return this.getInt("js.formatter.formatter.indentation.size", 1);
    }

    public String getIndentType() {
        return this.getString("js.formatter.formatter.tabulation.char");
    }

    public int getTabSize() {
        return this.getInt("js.formatter.formatter.tabulation.size", this.getEditorSpecificTabWidth());
    }

    public int getEditorSpecificTabWidth() {
        return EditorUtil.getSpaceIndentSize((String)JSPlugin.getDefault().getBundle().getSymbolicName());
    }

    public boolean isEditorInsertSpacesForTabs() {
        return FormatterUtils.isInsertSpacesForTabs((IPreferenceStore)JSPlugin.getDefault().getPreferenceStore());
    }

    private FormatterDocument createFormatterDocument(String input, int offset) {
        String key;
        FormatterDocument document = new FormatterDocument(input);
        document.setInt("js.formatter.formatter.tabulation.size", this.getInt("js.formatter.formatter.tabulation.size"));
        document.setBoolean("js.formatter.wrap.comments", this.getBoolean("js.formatter.wrap.comments"));
        document.setInt("js.formatter.line.after.function.declaration", this.getInt("js.formatter.line.after.function.declaration"));
        document.setInt("js.formatter.line.after.function.declaration.expression", this.getInt("js.formatter.line.after.function.declaration.expression"));
        document.setInt(ScriptFormattingContextProperties.CONTEXT_ORIGINAL_OFFSET, offset);
        document.setBoolean("js.formatter.formatter.on.off.enabled", this.getBoolean("js.formatter.formatter.on.off.enabled"));
        document.setString("js.formatter.formatter.on", this.getString("js.formatter.formatter.on"));
        document.setString("js.formatter.formatter.off", this.getString("js.formatter.formatter.off"));
        String[] stringArray = INDENTATIONS;
        int n = INDENTATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            document.setBoolean(key, this.getBoolean(key));
            ++n2;
        }
        stringArray = NEW_LINES_POSITIONS;
        n = NEW_LINES_POSITIONS.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            document.setBoolean(key, this.getBoolean(key));
            ++n2;
        }
        stringArray = BRACE_POSITIONS;
        n = BRACE_POSITIONS.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            document.setString(key, this.getString(key));
            ++n2;
        }
        stringArray = SPACES;
        n = SPACES.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            document.setInt(key, this.getInt(key));
            ++n2;
        }
        return document;
    }

    protected List<IRegion> getOutputOnOffRegions(String formatterOffPattern, String formatterOnPattern, IParseState parseState) {
        String output = parseState.getSource();
        IParser parser = this.checkoutParser();
        List onOffRegions = null;
        try {
            IParseNode[] commentNodes;
            IParseRootNode parseResult = parser.parse(parseState).getRootNode();
            this.checkinParser(parser);
            if (parseResult != null && (commentNodes = parseResult.getCommentNodes()) != null) {
                LinkedHashMap<Integer, String> commentsMap = new LinkedHashMap<Integer, String>(commentNodes.length);
                IParseNode[] iParseNodeArray = commentNodes;
                int n = commentNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    IParseNode comment = iParseNodeArray[n2];
                    int start = comment.getStartingOffset();
                    int end = comment.getEndingOffset() + 1;
                    String commentStr = output.substring(start, end);
                    commentsMap.put(start, commentStr);
                    ++n2;
                }
                if (!commentsMap.isEmpty()) {
                    Pattern onPattern = Pattern.compile(Pattern.quote(formatterOnPattern));
                    Pattern offPattern = Pattern.compile(Pattern.quote(formatterOffPattern));
                    onOffRegions = FormatterUtils.resolveOnOffRegions(commentsMap, (Pattern)onPattern, (Pattern)offPattern, (int)(output.length() - 1));
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)FormatterPlugin.getDefault(), (String)"Error while computing the formatter's output OFF/ON regions", (Throwable)e, (String)"com.aptana.formatter.epl/debug");
        }
        return onOffRegions;
    }

    public void initConfig(Map config) {
        try {
            if (config == null) {
                return;
            }
            String tab = "\t";
            int size = 1;
            String indentType = this.getIndentType();
            if ("editor".equals(indentType)) {
                if (this.isEditorInsertSpacesForTabs()) {
                    tab = " ";
                    size = this.getEditorSpecificTabWidth();
                }
            } else if ("space".equals(indentType)) {
                tab = " ";
                size = this.getIndentSize();
            }
            config.put("indent_char", tab);
            config.put("indent_size", size);
            config.put("keep_array_indentation", this.getBoolean("js.formatter.indent.keep.array.indentation"));
            int maxPreserveNewlines = this.getInt("js.formatter.line.preserve", 0);
            config.put("max_preserve_newlines", maxPreserveNewlines);
            config.put("preserve_newlines", maxPreserveNewlines > 0);
            config.put("wrap_line_length", this.getInt("js.formatter.wrap.length", 0));
            config.put("break_chained_methods", this.getBoolean("js.formatter.wrap.break.chained.methods"));
            config.put("space_in_paren", this.getBoolean("js.formatter.spaces.in.paren"));
            config.put("space_after_anon_function", this.getBoolean("js.formatter.spaces.after.anon.function"));
            config.put("space_before_conditional", this.getBoolean("js.formatter.spaces.before.conditional"));
            config.put("brace_style", this.getString("js.formatter.brace.position.blocks"));
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSFormatterPlugin.getDefault(), (Throwable)e);
        }
    }
}

