/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.formatter.preferences;

import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.formatter.preferences.Messages;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.IFormatterControlManager;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.preferences.FormatterModifyTabPage;
import com.aptana.formatter.ui.util.SWTFactory;
import java.net.URL;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class CSSFormatterControlStatementsPage
extends FormatterModifyTabPage {
    private static final String CONTROL_STATEMENTS_PREVIEW_NAME = "preview.css";
    private static final String[] TAB_OPTION_ITEMS = new String[]{"space", "tab", "editor"};
    private static final String[] TAB_OPTION_NAMES = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_EDITOR};

    public CSSFormatterControlStatementsPage(IFormatterModifyDialog dialog) {
        super(dialog);
    }

    protected void createOptions(IFormatterControlManager manager, Composite parent) {
        Group generalGroup = SWTFactory.createGroup((Composite)parent, (String)Messages.CSSFormatterControlStatementsPage_general_group_label, (int)2, (int)1, (int)768);
        Combo tabOptions = manager.createCombo((Composite)generalGroup, (Object)"css.formatter.formatter.tabulation.char", Messages.CSSFormatterControlStatementsPage_tab_policy_group_option, TAB_OPTION_ITEMS, TAB_OPTION_NAMES);
        Text indentationSize = manager.createNumber((Composite)generalGroup, "css.formatter.formatter.indentation.size", Messages.CSSFormatterControlStatementsPage_indentation_size_group_option, 1);
        new TabOptionHandler(manager, tabOptions, indentationSize);
    }

    protected URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource(CONTROL_STATEMENTS_PREVIEW_NAME);
    }

    private class TabOptionHandler
    extends SelectionAdapter
    implements IFormatterControlManager.IInitializeListener {
        private IFormatterControlManager manager;
        private Combo tabOptions;
        private Text indentationSize;

        public TabOptionHandler(IFormatterControlManager controlManager, Combo tabOptions, Text indentationSize) {
            this.manager = controlManager;
            this.tabOptions = tabOptions;
            this.indentationSize = indentationSize;
            tabOptions.addSelectionListener((SelectionListener)this);
            this.manager.addInitializeListener((IFormatterControlManager.IInitializeListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            int index = this.tabOptions.getSelectionIndex();
            if (index >= 0) {
                boolean tabMode = "tab".equals(TAB_OPTION_ITEMS[index]);
                boolean editorSettingsMode = "editor".equals(TAB_OPTION_ITEMS[index]);
                this.manager.enableControl((Control)this.indentationSize, !tabMode && !editorSettingsMode);
                if (editorSettingsMode) {
                    CSSFormatterControlStatementsPage.this.setEditorTabWidth(CSSPlugin.getDefault().getBundle().getSymbolicName(), new Text[]{this.indentationSize});
                }
            }
        }

        public void initialize() {
            boolean tabMode = "tab".equals(this.manager.getString((Object)"css.formatter.formatter.tabulation.char"));
            boolean editorSettingsMode = "editor".equals(this.manager.getString((Object)"css.formatter.formatter.tabulation.char"));
            this.manager.enableControl((Control)this.indentationSize, !tabMode && !editorSettingsMode);
            if (editorSettingsMode) {
                CSSFormatterControlStatementsPage.this.setEditorTabWidth(CSSPlugin.getDefault().getBundle().getSymbolicName(), new Text[]{this.indentationSize});
            }
        }
    }
}

