/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.less.formatter;

import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.formatter.CSSFormatterContext;
import com.aptana.editor.css.formatter.CSSFormatterNodeBuilder;
import com.aptana.editor.css.formatter.CSSFormatterNodeRewriter;
import com.aptana.editor.sass.SassPlugin;
import com.aptana.formatter.AbstractScriptFormatter;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.FormatterIndentDetector;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.ui.FormatterException;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.ScriptFormattingContextProperties;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.StatusLineMessageTimerManager;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.StringUtil;
import com.pandora.editor.less.formatter.Activator;
import com.pandora.nodejs.service.ContentType;
import com.pandora.nodejs.service.NodeService;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class LESSFormatter
extends AbstractScriptFormatter
implements IScriptFormatter {
    private static final Pattern whiteSpaceAsterisk = Pattern.compile("[\\s\\*\\u00A0]");
    protected static final String[] SPACES = new String[]{"less.scss.formatter.formatter.tabulation.char", "less.scss.formatter.formatter.tabulation.char"};

    protected LESSFormatter(String lineSeparator, Map<String, String> preferences, String mainContentType) {
        super(preferences, mainContentType, lineSeparator);
    }

    public int detectIndentationLevel(IDocument document, int offset, boolean isSelection, IFormattingContext formattingContext) {
        int indent = 0;
        try {
            ITypedRegion partition = document.getPartition(offset);
            if (partition != null && partition.getOffset() == offset) {
                return super.detectIndentationLevel(document, offset);
            }
            String source = document.get();
            IParseRootNode parseResult = ParserPoolFactory.parse((String)this.getMainContentType(), (String)source).getRootNode();
            if (parseResult != null) {
                CSSFormatterNodeBuilder builder = new CSSFormatterNodeBuilder();
                FormatterDocument formatterDocument = this.createFormatterDocument(source, offset);
                IFormatterContainerNode root = builder.build((IParseNode)parseResult, formatterDocument);
                new CSSFormatterNodeRewriter(parseResult, formatterDocument).rewrite(root);
                CSSFormatterContext context = new CSSFormatterContext(0);
                FormatterIndentDetector detector = new FormatterIndentDetector(offset);
                try {
                    root.accept((IFormatterContext)context, (IFormatterWriter)detector);
                    return detector.getLevel();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            return super.detectIndentationLevel(document, offset);
        }
        return indent;
    }

    public TextEdit format(String source, int offset, int length, int indentationLevel, boolean isSelection, IFormattingContext context, String indentSufix) throws FormatterException {
        if (isSelection) {
            IDocument document = (IDocument)context.getProperty((Object)ScriptFormattingContextProperties.CONTEXT_DOCUMENT);
            try {
                IRegion regin = document.getLineInformationOfOffset(offset);
                String indent = document.get(regin.getOffset(), offset - regin.getOffset());
                if (StringUtil.isBlank((String)indent)) {
                    length = offset - regin.getOffset() + length;
                    offset = regin.getOffset();
                }
            }
            catch (Exception e) {
                HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
            }
        }
        String input = new String(source.substring(offset, offset + length));
        try {
            String tab = "\t";
            int size = 1;
            if (this.isEditorInsertSpacesForTabs()) {
                tab = " ";
                size = this.getEditorSpecificTabWidth();
            }
            JSONObject config = new JSONObject();
            config.put("insize", size);
            config.put("inchar", (Object)tab);
            String output = NodeService.format((JSONObject)config, (ContentType)ContentType.LESS, (String)input);
            if (output != null) {
                if (!input.equals(output)) {
                    return new ReplaceEdit(offset, length, output);
                }
                return new MultiTextEdit();
            }
        }
        catch (Exception e) {
            StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.Formatter_formatterErrorStatus, (long)3000L, (boolean)true);
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
        return null;
    }

    public int getIndentSize() {
        return this.getInt("less.scss.formatter.formatter.indentation.size", 1);
    }

    public String getIndentType() {
        return this.getString("less.scss.formatter.formatter.tabulation.char");
    }

    public int getTabSize() {
        return this.getInt("less.scss.formatter.formatter.tabulation.size", this.getEditorSpecificTabWidth());
    }

    public int getEditorSpecificTabWidth() {
        return EditorUtil.getSpaceIndentSize((String)SassPlugin.getDefault().getBundle().getSymbolicName());
    }

    public boolean isEditorInsertSpacesForTabs() {
        return FormatterUtils.isInsertSpacesForTabs((IPreferenceStore)SassPlugin.getDefault().getPreferenceStore());
    }

    private FormatterDocument createFormatterDocument(String input, int offset) {
        FormatterDocument document = new FormatterDocument(input);
        document.setInt("less.scss.formatter.formatter.tabulation.size", this.getInt("less.scss.formatter.formatter.tabulation.size"));
        document.setInt(ScriptFormattingContextProperties.CONTEXT_ORIGINAL_OFFSET, offset);
        String[] stringArray = SPACES;
        int n = SPACES.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            document.setInt(key, this.getInt(key));
            ++n2;
        }
        return document;
    }

    private boolean equalsIgnoreWhiteSpaceAndAsterisk(String in, String out) {
        if (in == null || out == null) {
            return in == out;
        }
        boolean result = (in = whiteSpaceAsterisk.matcher(in).replaceAll("")).equals(out = whiteSpaceAsterisk.matcher(out).replaceAll(""));
        if (!result) {
            FormatterUtils.logDiff((String)in, (String)out);
        }
        return result;
    }
}

